/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.Collection;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.ItemCollection;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.ScanFilter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Table;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.ScanApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.AbstractImpl;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.ScanCollection;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ScanRequest;

public class ScanImpl
extends AbstractImpl
implements ScanApi {
    public ScanImpl(AmazonDynamoDB client, Table table) {
        super(client, table);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanFilter ... scanFilters) {
        return this.doScan(new ScanSpec().withScanFilters(scanFilters));
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doScan(new ScanSpec().withFilterExpression(filterExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doScan(new ScanSpec().withFilterExpression(filterExpression).withProjectionExpression(projectionExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanSpec spec) {
        return this.doScan(spec);
    }

    protected ItemCollection<ScanOutcome> doScan(ScanSpec spec) {
        Collection<ScanFilter> filters;
        String tableName = this.getTable().getTableName();
        ScanRequest req = ((ScanRequest)spec.getRequest()).withTableName(tableName);
        Collection<KeyAttribute> startKey = spec.getExclusiveStartKey();
        if (startKey != null) {
            req.setExclusiveStartKey(InternalUtils.toAttributeValueMap(startKey));
        }
        if ((filters = spec.getScanFilters()) != null) {
            req.setScanFilter(InternalUtils.toAttributeConditionMap(filters));
        }
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.getValueMap());
        req.withExpressionAttributeNames(spec.getNameMap()).withExpressionAttributeValues(attrValMap);
        return new ScanCollection(this.getClient(), spec);
    }
}

