/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.ItemCollection;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Page;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.ScanPage;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ScanRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ScanResult;

class ScanCollection
extends ItemCollection<ScanOutcome> {
    private final AmazonDynamoDB client;
    private final ScanSpec spec;
    private final Map<String, AttributeValue> startKey;

    public ScanCollection(AmazonDynamoDB client, ScanSpec spec) {
        this.client = client;
        this.spec = spec;
        Map<String, AttributeValue> startKey = ((ScanRequest)spec.getRequest()).getExclusiveStartKey();
        this.startKey = startKey == null ? null : new LinkedHashMap<String, AttributeValue>(startKey);
    }

    @Override
    public Page<Item, ScanOutcome> firstPage() {
        ScanRequest request = (ScanRequest)this.spec.getRequest();
        request.setExclusiveStartKey(this.startKey);
        request.setLimit(InternalUtils.minimum(this.spec.getMaxResultSize(), this.spec.getMaxPageSize()));
        ScanResult result = this.client.scan(request);
        ScanOutcome outcome = new ScanOutcome(result);
        this.setLastLowLevelResult(outcome);
        return new ScanPage(this.client, this.spec, request, 0, outcome);
    }

    @Override
    public Integer getMaxResultSize() {
        return this.spec.getMaxResultSize();
    }

    @Override
    protected void setLastLowLevelResult(ScanOutcome lowLevelResult) {
        super.setLastLowLevelResult(lowLevelResult);
        ScanResult result = lowLevelResult.getScanResult();
        this.accumulateStats(result.getConsumedCapacity(), result.getCount(), result.getScannedCount());
    }
}

