/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document;

import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.KeyConditions;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;

public class RangeKeyCondition {
    private final String attrName;
    private KeyConditions kcond;
    private Object[] values;

    public RangeKeyCondition(String attrName) {
        InternalUtils.checkInvalidAttrName(attrName);
        this.attrName = attrName;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public KeyConditions getKeyCondition() {
        return this.kcond;
    }

    public Object[] getValues() {
        return this.values == null ? null : (Object[])this.values.clone();
    }

    public RangeKeyCondition eq(Object val) {
        this.kcond = KeyConditions.EQ;
        return this.withValues(val);
    }

    public RangeKeyCondition beginsWith(String val) {
        this.kcond = KeyConditions.BEGINS_WITH;
        return this.withValues(val);
    }

    public RangeKeyCondition between(Object low, Object hi) {
        this.kcond = KeyConditions.BETWEEN;
        return this.withValues(low, hi);
    }

    public RangeKeyCondition ge(Object val) {
        this.kcond = KeyConditions.GE;
        return this.withValues(val);
    }

    public RangeKeyCondition gt(Object val) {
        this.kcond = KeyConditions.GT;
        return this.withValues(val);
    }

    public RangeKeyCondition le(Object val) {
        this.kcond = KeyConditions.LE;
        return this.withValues(val);
    }

    public RangeKeyCondition lt(Object val) {
        this.kcond = KeyConditions.LT;
        return this.withValues(val);
    }

    private RangeKeyCondition withValues(Object ... values) {
        this.values = values;
        return this;
    }
}

