/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.marshallers;

import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;

public class CustomMarshaller
implements ArgumentMarshaller.StringAttributeMarshaller {
    private final Class<? extends DynamoDBMarshaller<?>> marshallerClass;

    public CustomMarshaller(Class<? extends DynamoDBMarshaller<?>> marshallerClass) {
        this.marshallerClass = marshallerClass;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        DynamoDBMarshaller<Object> marshaler = CustomMarshaller.createMarshaller(this.marshallerClass);
        String stringValue = marshaler.marshall(obj);
        if (stringValue == null) {
            return null;
        }
        return new AttributeValue(stringValue);
    }

    private static DynamoDBMarshaller<Object> createMarshaller(Class<?> clazz) {
        try {
            return (DynamoDBMarshaller)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
    }
}

