/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.ConvertibleType;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;

@SdkInternalApi
final class StandardBeanProperties {
    StandardBeanProperties() {
    }

    static final <T> Beans<T> of(Class<T> clazz) {
        return ((CachedBeans)CachedBeans.CACHE).getBeans(clazz);
    }

    static final String fieldNameOf(Method getter) {
        String name = getter.getName().replaceFirst("^(get|is)", "");
        return StringUtils.lowerCase(name.substring(0, 1)) + name.substring(1);
    }

    static final class BeanMap<T, V>
    extends LinkedHashMap<String, Bean<T, V>> {
        private final Class<T> clazz;

        BeanMap(Class<T> clazz, boolean inherited) {
            this.clazz = clazz;
            this.putAll(clazz, inherited);
        }

        private void putAll(Class<T> clazz, boolean inherited) {
            for (Method method : clazz.getMethods()) {
                StandardAnnotationMaps.FieldMap annotations;
                if (!this.canMap(method, inherited) || (annotations = StandardAnnotationMaps.of(method, null)).ignored()) continue;
                MethodReflect reflect = new MethodReflect(method);
                this.putOrFlatten(annotations, reflect, method);
            }
        }

        private void putOrFlatten(StandardAnnotationMaps.FieldMap<V> annotations, DynamoDBMapperFieldModel.Reflect<T, V> reflect, Method getter) {
            if (annotations.flattened()) {
                this.flatten(annotations.targetType(), annotations.attributes(), reflect);
            } else {
                Bean bean = new Bean(annotations, reflect, getter);
                if (this.put(bean.properties().attributeName(), bean) != null) {
                    throw new DynamoDBMappingException("duplicate attribute name " + bean.properties().attributeName());
                }
            }
        }

        private void flatten(Class<T> targetType, Map<String, String> attributes, DynamoDBMapperFieldModel.Reflect<T, T> declaring) {
            for (Method method : targetType.getMethods()) {
                StandardAnnotationMaps.FieldMap annotations;
                if (!this.canMap(method, true)) continue;
                String name = StandardBeanProperties.fieldNameOf(method);
                if ((name = attributes.remove(name)) == null || (annotations = StandardAnnotationMaps.of(method, name)).ignored()) continue;
                DeclaringReflect reflect = new DeclaringReflect(method, declaring, targetType);
                this.putOrFlatten(annotations, reflect, method);
            }
            if (!attributes.isEmpty()) {
                throw new DynamoDBMappingException("contains unknown flattened attribute(s): " + attributes);
            }
        }

        private boolean canMap(Method method, boolean inherited) {
            if (!method.getName().matches("^(get|is).+")) {
                return false;
            }
            if (method.getParameterTypes().length != 0) {
                return false;
            }
            if (method.isBridge() || method.isSynthetic()) {
                return false;
            }
            if (method.getDeclaringClass() == Object.class) {
                return false;
            }
            return inherited || method.getDeclaringClass() == this.clazz || StandardAnnotationMaps.of(method.getDeclaringClass()).attributeType() != null;
        }
    }

    static final class DeclaringReflect<T, V>
    implements DynamoDBMapperFieldModel.Reflect<T, V> {
        private final DynamoDBMapperFieldModel.Reflect<T, V> reflect;
        private final DynamoDBMapperFieldModel.Reflect<T, T> declaring;
        private final Class<T> targetType;

        private DeclaringReflect(Method getter, DynamoDBMapperFieldModel.Reflect<T, T> declaring, Class<T> targetType) {
            this.reflect = new MethodReflect(getter);
            this.declaring = declaring;
            this.targetType = targetType;
        }

        @Override
        public V get(T object) {
            T declaringObject = this.declaring.get(object);
            if (declaringObject == null) {
                return null;
            }
            return this.reflect.get(declaringObject);
        }

        @Override
        public void set(T object, V value) {
            T declaringObject = this.declaring.get(object);
            if (declaringObject == null) {
                declaringObject = DeclaringReflect.newInstance(this.targetType);
                this.declaring.set(object, declaringObject);
            }
            this.reflect.set(declaringObject, value);
        }

        static <T> T newInstance(Class<T> targetType) {
            try {
                return targetType.newInstance();
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not instantiate " + targetType, e);
            }
        }
    }

    static final class MethodReflect<T, V>
    implements DynamoDBMapperFieldModel.Reflect<T, V> {
        private final Method getter;
        private final Method setter;

        private MethodReflect(Method getter) {
            this.setter = MethodReflect.setterOf(getter);
            this.getter = getter;
        }

        @Override
        public V get(T object) {
            try {
                return (V)this.getter.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not invoke " + this.getter + " on " + object.getClass(), e);
            }
        }

        @Override
        public void set(T object, V value) {
            try {
                this.setter.invoke(object, value);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not invoke " + this.setter + " on " + object.getClass() + " with value " + value + " of type " + (value == null ? null : value.getClass()), e);
            }
        }

        static Method setterOf(Method getter) {
            try {
                String name = "set" + getter.getName().replaceFirst("^(get|is)", "");
                return getter.getDeclaringClass().getMethod(name, getter.getReturnType());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    static final class Bean<T, V> {
        private final DynamoDBMapperFieldModel.Properties<V> properties;
        private final ConvertibleType<V> type;
        private final DynamoDBMapperFieldModel.Reflect<T, V> reflect;

        private Bean(StandardAnnotationMaps.FieldMap<V> annotations, DynamoDBMapperFieldModel.Reflect<T, V> reflect, Method getter) {
            this.properties = new DynamoDBMapperFieldModel.Properties.Immutable<V>(annotations);
            this.type = ConvertibleType.of(getter, annotations);
            this.reflect = reflect;
        }

        final DynamoDBMapperFieldModel.Properties<V> properties() {
            return this.properties;
        }

        final ConvertibleType<V> type() {
            return this.type;
        }

        final DynamoDBMapperFieldModel.Reflect<T, V> reflect() {
            return this.reflect;
        }
    }

    static final class Beans<T> {
        private final DynamoDBMapperTableModel.Properties<T> properties;
        private final Map<String, Bean<T, Object>> map;

        private Beans(StandardAnnotationMaps.TableMap<T> annotations, Map<String, Bean<T, Object>> map) {
            this.properties = new DynamoDBMapperTableModel.Properties.Immutable<T>(annotations);
            this.map = Collections.unmodifiableMap(map);
        }

        final DynamoDBMapperTableModel.Properties<T> properties() {
            return this.properties;
        }

        final Map<String, Bean<T, Object>> map() {
            return this.map;
        }
    }

    private static final class CachedBeans<T> {
        private static final CachedBeans<Object> CACHE = new CachedBeans();
        private final ConcurrentMap<Class<T>, Beans<T>> cache = new ConcurrentHashMap<Class<T>, Beans<T>>();

        private CachedBeans() {
        }

        private final Beans<T> getBeans(Class<T> clazz) {
            if (!this.cache.containsKey(clazz)) {
                StandardAnnotationMaps.TableMap<T> annotations = StandardAnnotationMaps.of(clazz);
                BeanMap map = new BeanMap(clazz, false);
                this.cache.putIfAbsent(clazz, new Beans(annotations, map));
            }
            return (Beans)this.cache.get(clazz);
        }
    }
}

