/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.internal.StaticCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.regions.RegionUtils;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.AmazonS3;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.AmazonS3Client;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.model.Region;
import software.amazon.kinesis.shaded.com.amazonaws.services.s3.transfer.TransferManager;

public class S3ClientCache {
    private final ConcurrentMap<String, AmazonS3> clientsByRegion = new ConcurrentHashMap<String, AmazonS3>();
    private final Map<String, TransferManager> transferManagersByRegion = new ConcurrentHashMap<String, TransferManager>();
    private final AWSCredentialsProvider awscredentialsProvider;

    @Deprecated
    S3ClientCache(AWSCredentials credentials) {
        this(new StaticCredentialsProvider(credentials));
    }

    S3ClientCache(AWSCredentialsProvider awsCredentialsProvider) {
        this.awscredentialsProvider = awsCredentialsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useClient(AmazonS3 client) {
        String region = client.getRegionName();
        Map<String, TransferManager> map = this.transferManagersByRegion;
        synchronized (map) {
            TransferManager tm = this.transferManagersByRegion.remove(region);
            if (tm != null) {
                tm.shutdownNow();
            }
            this.clientsByRegion.put(region, client);
        }
    }

    public AmazonS3 getClient(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("S3 region must be specified");
        }
        return this.getClient(region.toAWSRegion().getName());
    }

    public AmazonS3 getClient(String region) {
        if (region == null) {
            throw new IllegalArgumentException("S3 region must be specified");
        }
        AmazonS3 client = (AmazonS3)this.clientsByRegion.get(region);
        return client != null ? client : this.cacheClient(region);
    }

    private AmazonS3 cacheClient(String region) {
        if (this.awscredentialsProvider == null) {
            throw new IllegalArgumentException("No credentials provider found to connect to S3");
        }
        AmazonS3Client client = new AmazonS3Client(this.awscredentialsProvider);
        client.setRegion(RegionUtils.getRegion(region));
        this.clientsByRegion.put(region, client);
        return client;
    }

    public TransferManager getTransferManager(Region region) {
        return this.getTransferManager(region.toAWSRegion().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferManager getTransferManager(String region) {
        Map<String, TransferManager> map = this.transferManagersByRegion;
        synchronized (map) {
            TransferManager tm = this.transferManagersByRegion.get(region);
            if (tm == null) {
                tm = new TransferManager(this.getClient(region));
                this.transferManagersByRegion.put(region, tm);
            }
            return tm;
        }
    }
}

