/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonClientException;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.SdkTestInternalApi;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ScanRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ScanResult;

public class ParallelScanTask {
    private final List<ScanRequest> parallelScanRequests;
    private final int totalSegments;
    private final List<Future<ScanResult>> segmentScanFutureTasks;
    private final List<ScanResult> segmentScanResults;
    private final List<SegmentScanState> segmentScanStates;
    private ExecutorService executorService;
    private final AmazonDynamoDB dynamo;

    @Deprecated
    public ParallelScanTask(DynamoDBMapper mapper, AmazonDynamoDB dynamo, List<ScanRequest> parallelScanRequests) {
        this(dynamo, parallelScanRequests);
    }

    ParallelScanTask(AmazonDynamoDB dynamo, List<ScanRequest> parallelScanRequests) {
        this(dynamo, parallelScanRequests, Executors.newCachedThreadPool());
    }

    @SdkTestInternalApi
    ParallelScanTask(AmazonDynamoDB dynamo, List<ScanRequest> parallelScanRequests, ExecutorService executorService) {
        this.dynamo = dynamo;
        this.parallelScanRequests = parallelScanRequests;
        this.totalSegments = parallelScanRequests.size();
        this.executorService = executorService;
        this.segmentScanFutureTasks = Collections.synchronizedList(new ArrayList(this.totalSegments));
        this.segmentScanResults = Collections.synchronizedList(new ArrayList(this.totalSegments));
        this.segmentScanStates = Collections.synchronizedList(new ArrayList(this.totalSegments));
        this.initSegmentScanStates();
    }

    String getTableName() {
        return this.parallelScanRequests.get(0).getTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllSegmentScanFinished() {
        List<SegmentScanState> list = this.segmentScanStates;
        synchronized (list) {
            for (int segment = 0; segment < this.totalSegments; ++segment) {
                if (this.segmentScanStates.get(segment) == SegmentScanState.SegmentScanCompleted) continue;
                return false;
            }
            this.executorService.shutdown();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScanResult> getNextBatchOfScanResults() throws SdkClientException {
        this.startScanNextPages();
        List<SegmentScanState> list = this.segmentScanStates;
        synchronized (list) {
            while (this.segmentScanStates.contains((Object)SegmentScanState.Waiting) || this.segmentScanStates.contains((Object)SegmentScanState.Scanning)) {
                try {
                    this.segmentScanStates.wait();
                }
                catch (InterruptedException ie) {
                    throw new SdkClientException("Parallel scan interrupted by other thread.", ie);
                }
            }
            return this.marshalParallelScanResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScanNextPages() {
        for (int segment = 0; segment < this.totalSegments; ++segment) {
            final int currentSegment = segment;
            final SegmentScanState currentSegmentState = this.segmentScanStates.get(currentSegment);
            if (currentSegmentState == SegmentScanState.Scanning) {
                throw new SdkClientException("Should never see a 'Scanning' state when starting parallel scans.");
            }
            if (currentSegmentState == SegmentScanState.Failed || currentSegmentState == SegmentScanState.SegmentScanCompleted) {
                this.segmentScanResults.set(currentSegment, null);
                continue;
            }
            List<SegmentScanState> list = this.segmentScanStates;
            synchronized (list) {
                this.segmentScanStates.set(currentSegment, SegmentScanState.Scanning);
                this.segmentScanStates.notifyAll();
            }
            Future<ScanResult> futureTask = this.executorService.submit(new Callable<ScanResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ScanResult call() throws Exception {
                    try {
                        if (currentSegmentState == SegmentScanState.HasNextPage) {
                            return ParallelScanTask.this.scanNextPageOfSegment(currentSegment, true);
                        }
                        if (currentSegmentState == SegmentScanState.Waiting) {
                            return ParallelScanTask.this.scanNextPageOfSegment(currentSegment, false);
                        }
                        throw new SdkClientException("Should not start a new future task");
                    }
                    catch (Exception e) {
                        List list = ParallelScanTask.this.segmentScanStates;
                        synchronized (list) {
                            ParallelScanTask.this.segmentScanStates.set(currentSegment, SegmentScanState.Failed);
                            ParallelScanTask.this.segmentScanStates.notifyAll();
                            ParallelScanTask.this.executorService.shutdown();
                        }
                        throw e;
                    }
                }
            });
            this.segmentScanFutureTasks.set(currentSegment, futureTask);
        }
    }

    private List<ScanResult> marshalParallelScanResults() {
        LinkedList<ScanResult> scanResults = new LinkedList<ScanResult>();
        for (int segment = 0; segment < this.totalSegments; ++segment) {
            SegmentScanState currentSegmentState = this.segmentScanStates.get(segment);
            if (currentSegmentState == SegmentScanState.Failed) {
                try {
                    this.segmentScanFutureTasks.get(segment).get();
                    throw new SdkClientException("No Exception found in the failed scan task.");
                }
                catch (ExecutionException ee) {
                    if (ee.getCause() instanceof AmazonClientException) {
                        throw (SdkClientException)ee.getCause();
                    }
                    throw new SdkClientException("Internal error during the scan on segment #" + segment + ".", ee.getCause());
                }
                catch (Exception e) {
                    throw new SdkClientException("Error during the scan on segment #" + segment + ".", e);
                }
            }
            if (currentSegmentState == SegmentScanState.HasNextPage || currentSegmentState == SegmentScanState.SegmentScanCompleted) {
                ScanResult scanResult = this.segmentScanResults.get(segment);
                scanResults.add(scanResult);
                continue;
            }
            if (currentSegmentState != SegmentScanState.Waiting && currentSegmentState != SegmentScanState.Scanning) continue;
            throw new SdkClientException("Should never see a 'Scanning' or 'Waiting' state when marshalling parallel scan results.");
        }
        return scanResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScanResult scanNextPageOfSegment(int currentSegment, boolean checkLastEvaluatedKey) {
        ScanRequest segmentScanRequest = this.parallelScanRequests.get(currentSegment);
        if (checkLastEvaluatedKey) {
            ScanResult lastScanResult = this.segmentScanResults.get(currentSegment);
            segmentScanRequest.setExclusiveStartKey(lastScanResult.getLastEvaluatedKey());
        } else {
            segmentScanRequest.setExclusiveStartKey(null);
        }
        ScanResult scanResult = this.dynamo.scan(DynamoDBMapper.applyUserAgent(segmentScanRequest));
        this.segmentScanResults.set(currentSegment, scanResult);
        List<SegmentScanState> list = this.segmentScanStates;
        synchronized (list) {
            if (null == scanResult.getLastEvaluatedKey()) {
                this.segmentScanStates.set(currentSegment, SegmentScanState.SegmentScanCompleted);
            } else {
                this.segmentScanStates.set(currentSegment, SegmentScanState.HasNextPage);
            }
            this.segmentScanStates.notifyAll();
        }
        return scanResult;
    }

    private void initSegmentScanStates() {
        for (int segment = 0; segment < this.totalSegments; ++segment) {
            this.segmentScanFutureTasks.add(null);
            this.segmentScanResults.add(null);
            this.segmentScanStates.add(SegmentScanState.Waiting);
        }
    }

    private static enum SegmentScanState {
        Waiting,
        Scanning,
        Failed,
        HasNextPage,
        SegmentScanCompleted;

    }
}

