/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import software.amazon.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;

@DynamoDB
@DynamoDBAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBAutoGeneratedDefault {
    public String value();

    public static final class Generator<T>
    extends DynamoDBAutoGenerator.AbstractGenerator<T> {
        private final DynamoDBTypeConverter<T, String> converter;
        private final String defaultValue;

        public Generator(Class<T> targetType, DynamoDBAutoGeneratedDefault annotation) {
            super(DynamoDBAutoGenerateStrategy.CREATE);
            this.converter = StandardTypeConverters.factory().getConverter(targetType, String.class);
            this.defaultValue = annotation.value();
        }

        @Override
        public final T generate(T currentValue) {
            return this.converter.convert(this.defaultValue);
        }
    }
}

