/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.DefaultRequest;
import software.amazon.kinesis.shaded.com.amazonaws.Request;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.UntagResourceRequest;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Marshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;

public class UntagResourceRequestMarshaller
implements Marshaller<Request<UntagResourceRequest>, UntagResourceRequest> {
    @Override
    public Request<UntagResourceRequest> marshall(UntagResourceRequest untagResourceRequest) {
        if (untagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UntagResourceRequest> request = new DefaultRequest<UntagResourceRequest>(untagResourceRequest, "AmazonCloudWatch");
        request.addParameter("Action", "UntagResource");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (untagResourceRequest.getResourceARN() != null) {
            request.addParameter("ResourceARN", StringUtils.fromString(untagResourceRequest.getResourceARN()));
        }
        if (!untagResourceRequest.getTagKeys().isEmpty() || !((SdkInternalList)untagResourceRequest.getTagKeys()).isAutoConstruct()) {
            SdkInternalList tagKeysList = (SdkInternalList)untagResourceRequest.getTagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.member." + tagKeysListIndex, StringUtils.fromString(tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        return request;
    }
}

