/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.DefaultRequest;
import software.amazon.kinesis.shaded.com.amazonaws.Request;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.DimensionFilter;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Marshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;

public class ListMetricsRequestMarshaller
implements Marshaller<Request<ListMetricsRequest>, ListMetricsRequest> {
    @Override
    public Request<ListMetricsRequest> marshall(ListMetricsRequest listMetricsRequest) {
        if (listMetricsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListMetricsRequest> request = new DefaultRequest<ListMetricsRequest>(listMetricsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "ListMetrics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listMetricsRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(listMetricsRequest.getNamespace()));
        }
        if (listMetricsRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString(listMetricsRequest.getMetricName()));
        }
        if (!listMetricsRequest.getDimensions().isEmpty() || !((SdkInternalList)listMetricsRequest.getDimensions()).isAutoConstruct()) {
            SdkInternalList dimensionsList = (SdkInternalList)listMetricsRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (DimensionFilter dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null) {
                    if (dimensionsListValue.getName() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                    }
                    if (dimensionsListValue.getValue() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                    }
                }
                ++dimensionsListIndex;
            }
        }
        if (listMetricsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listMetricsRequest.getNextToken()));
        }
        if (listMetricsRequest.getRecentlyActive() != null) {
            request.addParameter("RecentlyActive", StringUtils.fromString(listMetricsRequest.getRecentlyActive()));
        }
        return request;
    }
}

