/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.DefaultRequest;
import software.amazon.kinesis.shaded.com.amazonaws.Request;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.ListDashboardsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Marshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;

public class ListDashboardsRequestMarshaller
implements Marshaller<Request<ListDashboardsRequest>, ListDashboardsRequest> {
    @Override
    public Request<ListDashboardsRequest> marshall(ListDashboardsRequest listDashboardsRequest) {
        if (listDashboardsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDashboardsRequest> request = new DefaultRequest<ListDashboardsRequest>(listDashboardsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "ListDashboards");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listDashboardsRequest.getDashboardNamePrefix() != null) {
            request.addParameter("DashboardNamePrefix", StringUtils.fromString(listDashboardsRequest.getDashboardNamePrefix()));
        }
        if (listDashboardsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listDashboardsRequest.getNextToken()));
        }
        return request;
    }
}

