/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import software.amazon.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class DimensionStaxUnmarshaller
implements Unmarshaller<Dimension, StaxUnmarshallerContext> {
    private static DimensionStaxUnmarshaller instance;

    @Override
    public Dimension unmarshall(StaxUnmarshallerContext context) throws Exception {
        Dimension dimension = new Dimension();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dimension;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    dimension.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                dimension.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dimension;
    }

    public static DimensionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DimensionStaxUnmarshaller();
        }
        return instance;
    }
}

