/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import software.amazon.kinesis.shaded.com.amazonaws.DefaultRequest;
import software.amazon.kinesis.shaded.com.amazonaws.Request;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.DeleteDashboardsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.transform.Marshaller;
import software.amazon.kinesis.shaded.com.amazonaws.util.StringUtils;

public class DeleteDashboardsRequestMarshaller
implements Marshaller<Request<DeleteDashboardsRequest>, DeleteDashboardsRequest> {
    @Override
    public Request<DeleteDashboardsRequest> marshall(DeleteDashboardsRequest deleteDashboardsRequest) {
        if (deleteDashboardsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteDashboardsRequest> request = new DefaultRequest<DeleteDashboardsRequest>(deleteDashboardsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DeleteDashboards");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!deleteDashboardsRequest.getDashboardNames().isEmpty() || !((SdkInternalList)deleteDashboardsRequest.getDashboardNames()).isAutoConstruct()) {
            SdkInternalList dashboardNamesList = (SdkInternalList)deleteDashboardsRequest.getDashboardNames();
            int dashboardNamesListIndex = 1;
            for (String dashboardNamesListValue : dashboardNamesList) {
                if (dashboardNamesListValue != null) {
                    request.addParameter("DashboardNames.member." + dashboardNamesListIndex, StringUtils.fromString(dashboardNamesListValue));
                }
                ++dashboardNamesListIndex;
            }
        }
        return request;
    }
}

