/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;

public class SingleMetricAnomalyDetector
implements Serializable,
Cloneable {
    private String namespace;
    private String metricName;
    private SdkInternalList<Dimension> dimensions;
    private String stat;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public SingleMetricAnomalyDetector withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public SingleMetricAnomalyDetector withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new SdkInternalList();
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new SdkInternalList<Dimension>(dimensions);
    }

    public SingleMetricAnomalyDetector withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new SdkInternalList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public SingleMetricAnomalyDetector withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public String getStat() {
        return this.stat;
    }

    public SingleMetricAnomalyDetector withStat(String stat) {
        this.setStat(stat);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getStat() != null) {
            sb.append("Stat: ").append(this.getStat());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleMetricAnomalyDetector)) {
            return false;
        }
        SingleMetricAnomalyDetector other = (SingleMetricAnomalyDetector)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getStat() == null ^ this.getStat() == null) {
            return false;
        }
        return other.getStat() == null || other.getStat().equals(this.getStat());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getStat() == null ? 0 : this.getStat().hashCode());
        return hashCode;
    }

    public SingleMetricAnomalyDetector clone() {
        try {
            return (SingleMetricAnomalyDetector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

