/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonWebServiceResult;
import software.amazon.kinesis.shaded.com.amazonaws.ResponseMetadata;
import software.amazon.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import software.amazon.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricStreamEntry;

public class ListMetricStreamsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private SdkInternalList<MetricStreamEntry> entries;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListMetricStreamsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<MetricStreamEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new SdkInternalList();
        }
        return this.entries;
    }

    public void setEntries(Collection<MetricStreamEntry> entries) {
        if (entries == null) {
            this.entries = null;
            return;
        }
        this.entries = new SdkInternalList<MetricStreamEntry>(entries);
    }

    public ListMetricStreamsResult withEntries(MetricStreamEntry ... entries) {
        if (this.entries == null) {
            this.setEntries(new SdkInternalList<MetricStreamEntry>(entries.length));
        }
        for (MetricStreamEntry ele : entries) {
            this.entries.add(ele);
        }
        return this;
    }

    public ListMetricStreamsResult withEntries(Collection<MetricStreamEntry> entries) {
        this.setEntries(entries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getEntries() != null) {
            sb.append("Entries: ").append(this.getEntries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricStreamsResult)) {
            return false;
        }
        ListMetricStreamsResult other = (ListMetricStreamsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getEntries() == null ^ this.getEntries() == null) {
            return false;
        }
        return other.getEntries() == null || other.getEntries().equals(this.getEntries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getEntries() == null ? 0 : this.getEntries().hashCode());
        return hashCode;
    }

    public ListMetricStreamsResult clone() {
        try {
            return (ListMetricStreamsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

