/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.shaded.com.amazonaws.auth;

import java.io.Closeable;
import java.util.concurrent.Callable;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.annotation.ThreadSafe;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSSessionCredentials;
import software.amazon.kinesis.shaded.com.amazonaws.auth.AWSSessionCredentialsProvider;
import software.amazon.kinesis.shaded.com.amazonaws.auth.RefreshableTask;
import software.amazon.kinesis.shaded.com.amazonaws.auth.SessionCredentialsHolder;
import software.amazon.kinesis.shaded.com.amazonaws.auth.ShouldDoAsyncSessionRefresh;
import software.amazon.kinesis.shaded.com.amazonaws.auth.ShouldDoBlockingSessionRefresh;
import software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetSessionTokenResult;

@ThreadSafe
public class STSSessionCredentialsProvider
implements AWSSessionCredentialsProvider,
Closeable {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    private final AWSSecurityTokenService securityTokenService;
    private final Callable<SessionCredentialsHolder> refreshCallable = new Callable<SessionCredentialsHolder>(){

        @Override
        public SessionCredentialsHolder call() throws Exception {
            return STSSessionCredentialsProvider.this.newSession();
        }
    };
    private volatile RefreshableTask<SessionCredentialsHolder> refreshableTask;

    public STSSessionCredentialsProvider(AWSCredentials longLivedCredentials) {
        this(longLivedCredentials, new ClientConfiguration());
    }

    public STSSessionCredentialsProvider(AWSCredentials longLivedCredentials, ClientConfiguration clientConfiguration) {
        this(new AWSSecurityTokenServiceClient(longLivedCredentials, clientConfiguration));
    }

    public STSSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider) {
        this(new AWSSecurityTokenServiceClient(longLivedCredentialsProvider));
    }

    public STSSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(new AWSSecurityTokenServiceClient(longLivedCredentialsProvider, clientConfiguration));
    }

    private RefreshableTask<SessionCredentialsHolder> createRefreshableTask() {
        return new RefreshableTask.Builder<SessionCredentialsHolder>().withRefreshCallable(this.refreshCallable).withBlockingRefreshPredicate(new ShouldDoBlockingSessionRefresh()).withAsyncRefreshPredicate(new ShouldDoAsyncSessionRefresh()).build();
    }

    public STSSessionCredentialsProvider(AWSSecurityTokenService sts) {
        this.securityTokenService = sts;
        this.refreshableTask = this.createRefreshableTask();
    }

    @Deprecated
    public synchronized void setSTSClientEndpoint(String endpoint) {
        this.securityTokenService.setEndpoint(endpoint);
        this.refreshableTask = this.createRefreshableTask();
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        return this.refreshableTask.getValue().getSessionCredentials();
    }

    @Override
    public void refresh() {
        this.refreshableTask.forceGetValue();
    }

    private SessionCredentialsHolder newSession() {
        GetSessionTokenResult sessionTokenResult = this.securityTokenService.getSessionToken(new GetSessionTokenRequest().withDurationSeconds(3600));
        return new SessionCredentialsHolder(sessionTokenResult.getCredentials());
    }

    @Override
    public void close() {
        this.refreshableTask.close();
    }
}

