/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.proxy;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.connectors.flink.model.StreamShardHandle;
import software.amazon.kinesis.connectors.flink.proxy.FullJitterBackoff;
import software.amazon.kinesis.connectors.flink.proxy.GetShardListResult;
import software.amazon.kinesis.connectors.flink.proxy.KinesisProxyInterface;
import software.amazon.kinesis.connectors.flink.util.AWSUtil;
import software.amazon.kinesis.connectors.flink.util.KinesisConfigUtil;
import software.amazon.kinesis.shaded.com.amazonaws.AmazonServiceException;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfiguration;
import software.amazon.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import software.amazon.kinesis.shaded.com.amazonaws.SdkClientException;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ExpiredNextTokenException;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.GetRecordsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.GetRecordsResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.InvalidArgumentException;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.LimitExceededException;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ListShardsRequest;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ListShardsResult;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ResourceInUseException;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.ShardIteratorType;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamStatus;

@Internal
public class KinesisProxy
implements KinesisProxyInterface {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisProxy.class);
    private static final FullJitterBackoff BACKOFF = new FullJitterBackoff();
    private final AmazonKinesis kinesisClient;
    private final long listShardsBaseBackoffMillis;
    private final long listShardsMaxBackoffMillis;
    private final double listShardsExpConstant;
    private final int listShardsMaxRetries;
    private final long getRecordsBaseBackoffMillis;
    private final long getRecordsMaxBackoffMillis;
    private final double getRecordsExpConstant;
    private final int getRecordsMaxRetries;
    private final long getShardIteratorBaseBackoffMillis;
    private final long getShardIteratorMaxBackoffMillis;
    private final double getShardIteratorExpConstant;
    private final int getShardIteratorMaxRetries;
    private final long describeStreamBaseBackoffMillis;
    private final long describeStreamMaxBackoffMillis;
    private final double describeStreamExpConstant;

    protected KinesisProxy(Properties configProps) {
        Preconditions.checkNotNull((Object)configProps);
        KinesisConfigUtil.backfillConsumerKeys(configProps);
        this.kinesisClient = this.createKinesisClient(configProps);
        this.listShardsBaseBackoffMillis = Long.parseLong(configProps.getProperty("flink.list.shards.backoff.base", Long.toString(1000L)));
        this.listShardsMaxBackoffMillis = Long.parseLong(configProps.getProperty("flink.list.shards.backoff.max", Long.toString(5000L)));
        this.listShardsExpConstant = Double.parseDouble(configProps.getProperty("flink.list.shards.backoff.expconst", Double.toString(1.5)));
        this.listShardsMaxRetries = Integer.parseInt(configProps.getProperty("flink.list.shards.maxretries", Long.toString(10L)));
        this.describeStreamBaseBackoffMillis = Long.parseLong(configProps.getProperty("flink.stream.describe.backoff.base", Long.toString(2000L)));
        this.describeStreamMaxBackoffMillis = Long.parseLong(configProps.getProperty("flink.stream.describe.backoff.max", Long.toString(5000L)));
        this.describeStreamExpConstant = Double.parseDouble(configProps.getProperty("flink.stream.describe.backoff.expconst", Double.toString(1.5)));
        this.getRecordsBaseBackoffMillis = Long.parseLong(configProps.getProperty("flink.shard.getrecords.backoff.base", Long.toString(300L)));
        this.getRecordsMaxBackoffMillis = Long.parseLong(configProps.getProperty("flink.shard.getrecords.backoff.max", Long.toString(1000L)));
        this.getRecordsExpConstant = Double.parseDouble(configProps.getProperty("flink.shard.getrecords.backoff.expconst", Double.toString(1.5)));
        this.getRecordsMaxRetries = Integer.parseInt(configProps.getProperty("flink.shard.getrecords.maxretries", Long.toString(3L)));
        this.getShardIteratorBaseBackoffMillis = Long.parseLong(configProps.getProperty("flink.shard.getiterator.backoff.base", Long.toString(300L)));
        this.getShardIteratorMaxBackoffMillis = Long.parseLong(configProps.getProperty("flink.shard.getiterator.backoff.max", Long.toString(1000L)));
        this.getShardIteratorExpConstant = Double.parseDouble(configProps.getProperty("flink.shard.getiterator.backoff.expconst", Double.toString(1.5)));
        this.getShardIteratorMaxRetries = Integer.parseInt(configProps.getProperty("flink.shard.getiterator.maxretries", Long.toString(3L)));
    }

    protected AmazonKinesis createKinesisClient(Properties configProps) {
        ClientConfiguration awsClientConfig = new ClientConfigurationFactory().getConfig();
        AWSUtil.setAwsClientConfigProperties(awsClientConfig, configProps);
        return AWSUtil.createKinesisClient(configProps, awsClientConfig);
    }

    public static KinesisProxyInterface create(Properties configProps) {
        return new KinesisProxy(configProps);
    }

    @Override
    public GetRecordsResult getRecords(String shardIterator, int maxRecordsToGet) throws InterruptedException {
        GetRecordsRequest getRecordsRequest = new GetRecordsRequest();
        getRecordsRequest.setShardIterator(shardIterator);
        getRecordsRequest.setLimit(maxRecordsToGet);
        GetRecordsResult getRecordsResult = null;
        int retryCount = 0;
        while (retryCount <= this.getRecordsMaxRetries && getRecordsResult == null) {
            try {
                getRecordsResult = this.kinesisClient.getRecords(getRecordsRequest);
            }
            catch (SdkClientException ex) {
                if (this.isRecoverableSdkClientException(ex)) {
                    long backoffMillis = BACKOFF.calculateFullJitterBackoff(this.getRecordsBaseBackoffMillis, this.getRecordsMaxBackoffMillis, this.getRecordsExpConstant, retryCount++);
                    LOG.warn("Got recoverable SdkClientException. Backing off for " + backoffMillis + " millis (" + ex.getClass().getName() + ": " + ex.getMessage() + ")");
                    BACKOFF.sleep(backoffMillis);
                    continue;
                }
                throw ex;
            }
        }
        if (getRecordsResult == null) {
            throw new RuntimeException("Retries exceeded for getRecords operation - all " + this.getRecordsMaxRetries + " retry attempts failed.");
        }
        return getRecordsResult;
    }

    @Override
    public GetShardListResult getShardList(Map<String, String> streamNamesWithLastSeenShardIds) throws InterruptedException {
        GetShardListResult result = new GetShardListResult();
        for (Map.Entry<String, String> streamNameWithLastSeenShardId : streamNamesWithLastSeenShardIds.entrySet()) {
            String stream = streamNameWithLastSeenShardId.getKey();
            String lastSeenShardId = streamNameWithLastSeenShardId.getValue();
            result.addRetrievedShardsToStream(stream, this.getShardsOfStream(stream, lastSeenShardId));
        }
        return result;
    }

    @Override
    public String getShardIterator(StreamShardHandle shard, String shardIteratorType, @Nullable Object startingMarker) throws InterruptedException {
        GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest().withStreamName(shard.getStreamName()).withShardId(shard.getShard().getShardId()).withShardIteratorType(shardIteratorType);
        switch (ShardIteratorType.fromValue(shardIteratorType)) {
            case TRIM_HORIZON: 
            case LATEST: {
                break;
            }
            case AT_TIMESTAMP: {
                if (startingMarker instanceof Date) {
                    getShardIteratorRequest.setTimestamp((Date)startingMarker);
                    break;
                }
                throw new IllegalArgumentException("Invalid object given for GetShardIteratorRequest() when ShardIteratorType is AT_TIMESTAMP. Must be a Date object.");
            }
            case AT_SEQUENCE_NUMBER: 
            case AFTER_SEQUENCE_NUMBER: {
                if (startingMarker instanceof String) {
                    getShardIteratorRequest.setStartingSequenceNumber((String)startingMarker);
                    break;
                }
                throw new IllegalArgumentException("Invalid object given for GetShardIteratorRequest() when ShardIteratorType is AT_SEQUENCE_NUMBER or AFTER_SEQUENCE_NUMBER. Must be a String.");
            }
        }
        return this.getShardIterator(getShardIteratorRequest);
    }

    private String getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws InterruptedException {
        GetShardIteratorResult getShardIteratorResult = null;
        int retryCount = 0;
        while (retryCount <= this.getShardIteratorMaxRetries && getShardIteratorResult == null) {
            try {
                getShardIteratorResult = this.kinesisClient.getShardIterator(getShardIteratorRequest);
            }
            catch (AmazonServiceException ex) {
                if (KinesisProxy.isRecoverableException(ex)) {
                    long backoffMillis = BACKOFF.calculateFullJitterBackoff(this.getShardIteratorBaseBackoffMillis, this.getShardIteratorMaxBackoffMillis, this.getShardIteratorExpConstant, retryCount++);
                    LOG.warn("Got recoverable AmazonServiceException. Backing off for " + backoffMillis + " millis (" + ex.getClass().getName() + ": " + ex.getMessage() + ")");
                    BACKOFF.sleep(backoffMillis);
                    continue;
                }
                throw ex;
            }
        }
        if (getShardIteratorResult == null) {
            throw new RuntimeException("Retries exceeded for getShardIterator operation - all " + this.getShardIteratorMaxRetries + " retry attempts failed.");
        }
        return getShardIteratorResult.getShardIterator();
    }

    protected boolean isRecoverableSdkClientException(SdkClientException ex) {
        if (ex instanceof AmazonServiceException) {
            return KinesisProxy.isRecoverableException((AmazonServiceException)ex);
        }
        return false;
    }

    protected static boolean isRecoverableException(AmazonServiceException ex) {
        if (ex.getErrorType() == null) {
            return false;
        }
        switch (ex.getErrorType()) {
            case Client: {
                return ex instanceof ProvisionedThroughputExceededException;
            }
            case Service: 
            case Unknown: {
                return true;
            }
        }
        return false;
    }

    private List<StreamShardHandle> getShardsOfStream(String streamName, @Nullable String lastSeenShardId) throws InterruptedException {
        ListShardsResult listShardsResult;
        ArrayList<StreamShardHandle> shardsOfStream = new ArrayList<StreamShardHandle>();
        String startShardToken = null;
        do {
            if ((listShardsResult = this.listShards(streamName, lastSeenShardId, startShardToken)) == null) {
                shardsOfStream.clear();
                return shardsOfStream;
            }
            List<Shard> shards = listShardsResult.getShards();
            for (Shard shard : shards) {
                shardsOfStream.add(new StreamShardHandle(streamName, shard));
            }
        } while ((startShardToken = listShardsResult.getNextToken()) != null);
        return shardsOfStream;
    }

    private ListShardsResult listShards(String streamName, @Nullable String startShardId, @Nullable String startNextToken) throws InterruptedException {
        ListShardsRequest listShardsRequest = new ListShardsRequest();
        if (startNextToken == null) {
            listShardsRequest.setExclusiveStartShardId(startShardId);
            listShardsRequest.setStreamName(streamName);
        } else {
            listShardsRequest.setNextToken(startNextToken);
        }
        ListShardsResult listShardsResults = null;
        int retryCount = 0;
        while (retryCount <= this.listShardsMaxRetries && listShardsResults == null) {
            long backoffMillis;
            try {
                listShardsResults = this.kinesisClient.listShards(listShardsRequest);
            }
            catch (LimitExceededException le) {
                backoffMillis = BACKOFF.calculateFullJitterBackoff(this.listShardsBaseBackoffMillis, this.listShardsMaxBackoffMillis, this.listShardsExpConstant, retryCount++);
                LOG.warn("Got LimitExceededException when listing shards from stream " + streamName + ". Backing off for " + backoffMillis + " millis.");
                BACKOFF.sleep(backoffMillis);
            }
            catch (ResourceInUseException reInUse) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.info("The stream is currently not in active state. Reusing the older state for the time being");
                break;
            }
            catch (ResourceNotFoundException reNotFound) {
                throw new RuntimeException("Stream not found. Error while getting shard list.", reNotFound);
            }
            catch (InvalidArgumentException inArg) {
                throw new RuntimeException("Invalid Arguments to listShards.", inArg);
            }
            catch (ExpiredNextTokenException expiredToken) {
                LOG.warn("List Shards has an expired token. Reusing the previous state.");
                break;
            }
            catch (SdkClientException ex) {
                if (retryCount < this.listShardsMaxRetries && this.isRecoverableSdkClientException(ex)) {
                    backoffMillis = BACKOFF.calculateFullJitterBackoff(this.listShardsBaseBackoffMillis, this.listShardsMaxBackoffMillis, this.listShardsExpConstant, retryCount++);
                    LOG.warn("Got SdkClientException when listing shards from stream {}. Backing off for {} millis.", (Object)streamName, (Object)backoffMillis);
                    BACKOFF.sleep(backoffMillis);
                    continue;
                }
                throw ex;
            }
        }
        if (startShardId != null && listShardsResults != null) {
            List<Shard> shards = listShardsResults.getShards();
            shards.removeIf(shard -> StreamShardHandle.compareShardIds(shard.getShardId(), startShardId) <= 0);
        }
        return listShardsResults;
    }

    protected DescribeStreamResult describeStream(String streamName, @Nullable String startShardId) throws InterruptedException {
        DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest();
        describeStreamRequest.setStreamName(streamName);
        describeStreamRequest.setExclusiveStartShardId(startShardId);
        DescribeStreamResult describeStreamResult = null;
        int attemptCount = 0;
        while (describeStreamResult == null) {
            try {
                describeStreamResult = this.kinesisClient.describeStream(describeStreamRequest);
            }
            catch (LimitExceededException le) {
                long backoffMillis = BACKOFF.calculateFullJitterBackoff(this.describeStreamBaseBackoffMillis, this.describeStreamMaxBackoffMillis, this.describeStreamExpConstant, attemptCount++);
                LOG.warn(String.format("Got LimitExceededException when describing stream %s. Backing off for %d millis.", streamName, backoffMillis));
                BACKOFF.sleep(backoffMillis);
            }
            catch (ResourceNotFoundException re) {
                throw new RuntimeException("Error while getting stream details", re);
            }
        }
        String streamStatus = describeStreamResult.getStreamDescription().getStreamStatus();
        if (!streamStatus.equals(StreamStatus.ACTIVE.toString()) && !streamStatus.equals(StreamStatus.UPDATING.toString()) && LOG.isWarnEnabled()) {
            LOG.warn(String.format("The status of stream %s is %s ; result of the current describeStream operation will not contain any shard information.", streamName, streamStatus));
        }
        return describeStreamResult;
    }
}

