/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.model;

import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import software.amazon.kinesis.connectors.flink.model.SequenceNumber;
import software.amazon.kinesis.connectors.flink.model.StreamShardHandle;
import software.amazon.kinesis.connectors.flink.model.StreamShardMetadata;

@Internal
public class KinesisStreamShardState {
    private StreamShardHandle streamShardHandle;
    private StreamShardMetadata streamShardMetadata;
    private SequenceNumber lastProcessedSequenceNum;

    public KinesisStreamShardState(StreamShardMetadata streamShardMetadata, StreamShardHandle streamShardHandle, SequenceNumber lastProcessedSequenceNum) {
        this.streamShardMetadata = (StreamShardMetadata)Preconditions.checkNotNull((Object)streamShardMetadata);
        this.streamShardHandle = (StreamShardHandle)Preconditions.checkNotNull((Object)streamShardHandle);
        this.lastProcessedSequenceNum = (SequenceNumber)Preconditions.checkNotNull((Object)lastProcessedSequenceNum);
    }

    public StreamShardMetadata getStreamShardMetadata() {
        return this.streamShardMetadata;
    }

    public StreamShardHandle getStreamShardHandle() {
        return this.streamShardHandle;
    }

    public SequenceNumber getLastProcessedSequenceNum() {
        return this.lastProcessedSequenceNum;
    }

    public void setLastProcessedSequenceNum(SequenceNumber update) {
        this.lastProcessedSequenceNum = update;
    }

    public String toString() {
        return "KinesisStreamShardState{streamShardMetadata='" + this.streamShardMetadata.toString() + "', streamShardHandle='" + this.streamShardHandle.toString() + "', lastProcessedSequenceNumber='" + this.lastProcessedSequenceNum.toString() + "'}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KinesisStreamShardState)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        KinesisStreamShardState other = (KinesisStreamShardState)obj;
        return this.streamShardMetadata.equals(other.getStreamShardMetadata()) && this.streamShardHandle.equals(other.getStreamShardHandle()) && this.lastProcessedSequenceNum.equals(other.getLastProcessedSequenceNum());
    }

    public int hashCode() {
        return 37 * (this.streamShardMetadata.hashCode() + this.streamShardHandle.hashCode() + this.lastProcessedSequenceNum.hashCode());
    }
}

