/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.model;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import software.amazon.kinesis.connectors.flink.model.StreamShardMetadata;
import software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;

@Deprecated
@Internal
public class KinesisStreamShard
implements Serializable {
    private static final long serialVersionUID = -6004217801761077536L;
    private final String streamName;
    private final Shard shard;
    private final int cachedHash;

    public KinesisStreamShard(String streamName, Shard shard) {
        this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
        this.shard = (Shard)Preconditions.checkNotNull((Object)shard);
        int hash = 17;
        hash = 37 * hash + streamName.hashCode();
        this.cachedHash = hash = 37 * hash + shard.getShardId().hashCode();
    }

    public String getStreamName() {
        return this.streamName;
    }

    public boolean isClosed() {
        return this.shard.getSequenceNumberRange().getEndingSequenceNumber() != null;
    }

    public Shard getShard() {
        return this.shard;
    }

    public String toString() {
        return "KinesisStreamShard{streamName='" + this.streamName + "', shard='" + this.shard.toString() + "'}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KinesisStreamShard)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        KinesisStreamShard other = (KinesisStreamShard)obj;
        return this.streamName.equals(other.getStreamName()) && this.shard.equals(other.getShard());
    }

    public int hashCode() {
        return this.cachedHash;
    }

    public static StreamShardMetadata convertToStreamShardMetadata(KinesisStreamShard kinesisStreamShard) {
        StreamShardMetadata streamShardMetadata = new StreamShardMetadata();
        streamShardMetadata.setStreamName(kinesisStreamShard.getStreamName());
        streamShardMetadata.setShardId(kinesisStreamShard.getShard().getShardId());
        streamShardMetadata.setParentShardId(kinesisStreamShard.getShard().getParentShardId());
        streamShardMetadata.setAdjacentParentShardId(kinesisStreamShard.getShard().getAdjacentParentShardId());
        if (kinesisStreamShard.getShard().getHashKeyRange() != null) {
            streamShardMetadata.setStartingHashKey(kinesisStreamShard.getShard().getHashKeyRange().getStartingHashKey());
            streamShardMetadata.setEndingHashKey(kinesisStreamShard.getShard().getHashKeyRange().getEndingHashKey());
        }
        if (kinesisStreamShard.getShard().getSequenceNumberRange() != null) {
            streamShardMetadata.setStartingSequenceNumber(kinesisStreamShard.getShard().getSequenceNumberRange().getStartingSequenceNumber());
            streamShardMetadata.setEndingSequenceNumber(kinesisStreamShard.getShard().getSequenceNumberRange().getEndingSequenceNumber());
        }
        return streamShardMetadata;
    }
}

