/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.internals.publisher.fanout;

import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;
import software.amazon.kinesis.connectors.flink.internals.publisher.RecordPublisherFactory;
import software.amazon.kinesis.connectors.flink.internals.publisher.fanout.FanOutRecordPublisher;
import software.amazon.kinesis.connectors.flink.internals.publisher.fanout.FanOutRecordPublisherConfiguration;
import software.amazon.kinesis.connectors.flink.model.StartingPosition;
import software.amazon.kinesis.connectors.flink.model.StreamShardHandle;
import software.amazon.kinesis.connectors.flink.proxy.FullJitterBackoff;
import software.amazon.kinesis.connectors.flink.proxy.KinesisProxyV2Interface;

@Internal
public class FanOutRecordPublisherFactory
implements RecordPublisherFactory {
    private static final FullJitterBackoff BACKOFF = new FullJitterBackoff();
    private final KinesisProxyV2Interface kinesisProxy;

    public FanOutRecordPublisherFactory(KinesisProxyV2Interface kinesisProxy) {
        this.kinesisProxy = kinesisProxy;
    }

    @Override
    public FanOutRecordPublisher create(StartingPosition startingPosition, Properties consumerConfig, MetricGroup metricGroup, StreamShardHandle streamShardHandle) {
        Preconditions.checkNotNull((Object)startingPosition);
        Preconditions.checkNotNull((Object)consumerConfig);
        Preconditions.checkNotNull((Object)metricGroup);
        Preconditions.checkNotNull((Object)streamShardHandle);
        String stream = streamShardHandle.getStreamName();
        FanOutRecordPublisherConfiguration configuration = new FanOutRecordPublisherConfiguration(consumerConfig, Collections.singletonList(stream));
        Optional<String> streamConsumerArn = configuration.getStreamConsumerArn(stream);
        Preconditions.checkState((boolean)streamConsumerArn.isPresent());
        return new FanOutRecordPublisher(startingPosition, streamConsumerArn.get(), streamShardHandle, this.kinesisProxy, configuration, BACKOFF);
    }

    @Override
    public void close() {
        this.kinesisProxy.close();
    }
}

