/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.connectors.flink.internals.publisher.fanout;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.connectors.flink.internals.publisher.RecordBatch;
import software.amazon.kinesis.connectors.flink.internals.publisher.RecordPublisher;
import software.amazon.kinesis.connectors.flink.internals.publisher.fanout.FanOutRecordPublisherConfiguration;
import software.amazon.kinesis.connectors.flink.internals.publisher.fanout.FanOutShardSubscriber;
import software.amazon.kinesis.connectors.flink.model.SequenceNumber;
import software.amazon.kinesis.connectors.flink.model.StreamShardHandle;
import software.amazon.kinesis.connectors.flink.proxy.FullJitterBackoff;
import software.amazon.kinesis.connectors.flink.proxy.KinesisProxyV2Interface;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StartingPosition;
import software.amazon.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent;

@Internal
public class FanOutRecordPublisher
implements RecordPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(FanOutRecordPublisher.class);
    private final FullJitterBackoff backoff;
    private final String consumerArn;
    private final KinesisProxyV2Interface kinesisProxy;
    private final StreamShardHandle subscribedShard;
    private final FanOutRecordPublisherConfiguration configuration;
    private int attempt = 0;
    private software.amazon.kinesis.connectors.flink.model.StartingPosition nextStartingPosition;

    public FanOutRecordPublisher(software.amazon.kinesis.connectors.flink.model.StartingPosition startingPosition, String consumerArn, StreamShardHandle subscribedShard, KinesisProxyV2Interface kinesisProxy, FanOutRecordPublisherConfiguration configuration, FullJitterBackoff backoff) {
        this.nextStartingPosition = (software.amazon.kinesis.connectors.flink.model.StartingPosition)Preconditions.checkNotNull((Object)startingPosition);
        this.consumerArn = (String)Preconditions.checkNotNull((Object)consumerArn);
        this.subscribedShard = (StreamShardHandle)Preconditions.checkNotNull((Object)subscribedShard);
        this.kinesisProxy = (KinesisProxyV2Interface)Preconditions.checkNotNull((Object)kinesisProxy);
        this.configuration = (FanOutRecordPublisherConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.backoff = (FullJitterBackoff)Preconditions.checkNotNull((Object)backoff);
    }

    @Override
    public RecordPublisher.RecordPublisherRunResult run(RecordPublisher.RecordBatchConsumer recordConsumer) throws InterruptedException {
        LOG.info("Running fan out record publisher on {}::{} from {} - {}", new Object[]{this.subscribedShard.getStreamName(), this.subscribedShard.getShard().getShardId(), this.nextStartingPosition.getShardIteratorType(), this.nextStartingPosition.getStartingMarker()});
        Consumer<SubscribeToShardEvent> eventConsumer = event -> {
            RecordBatch recordBatch = new RecordBatch(this.toSdkV1Records(event.records()), this.subscribedShard, event.millisBehindLatest());
            SequenceNumber sequenceNumber = recordConsumer.accept(recordBatch);
            this.nextStartingPosition = software.amazon.kinesis.connectors.flink.model.StartingPosition.continueFromSequenceNumber(sequenceNumber);
        };
        RecordPublisher.RecordPublisherRunResult result = this.runWithBackoff(eventConsumer);
        LOG.info("Subscription expired {}::{}, with status {}", new Object[]{this.subscribedShard.getStreamName(), this.subscribedShard.getShard().getShardId(), result});
        return result;
    }

    private RecordPublisher.RecordPublisherRunResult runWithBackoff(Consumer<SubscribeToShardEvent> eventConsumer) throws InterruptedException {
        boolean complete;
        FanOutShardSubscriber fanOutShardSubscriber = new FanOutShardSubscriber(this.consumerArn, this.subscribedShard.getShard().getShardId(), this.kinesisProxy, this.configuration.getSubscribeToShardTimeout());
        try {
            complete = fanOutShardSubscriber.subscribeToShardAndConsumeRecords(this.toSdkV2StartingPosition(this.nextStartingPosition), eventConsumer);
            this.attempt = 0;
        }
        catch (FanOutShardSubscriber.FanOutSubscriberInterruptedException ex) {
            LOG.info("Thread interrupted, closing record publisher for shard {}.", (Object)this.subscribedShard.getShard().getShardId(), (Object)ex);
            return RecordPublisher.RecordPublisherRunResult.CANCELLED;
        }
        catch (FanOutShardSubscriber.RecoverableFanOutSubscriberException ex) {
            this.backoff(ex);
            return RecordPublisher.RecordPublisherRunResult.INCOMPLETE;
        }
        catch (FanOutShardSubscriber.FanOutSubscriberException ex) {
            if (ex.getCause() instanceof ResourceNotFoundException) {
                LOG.warn("Received ResourceNotFoundException. Either the shard does not exist, or the stream subscriber has been deregistered.Marking this shard as complete {} ({})", (Object)this.subscribedShard.getShard().getShardId(), (Object)this.consumerArn);
                return RecordPublisher.RecordPublisherRunResult.COMPLETE;
            }
            if (this.attempt == this.configuration.getSubscribeToShardMaxRetries()) {
                String errorMessage = "Maximum retries exceeded for SubscribeToShard. Failed " + this.configuration.getSubscribeToShardMaxRetries() + " times.";
                LOG.error(errorMessage, ex.getCause());
                throw new RuntimeException(errorMessage, ex.getCause());
            }
            ++this.attempt;
            this.backoff(ex);
            return RecordPublisher.RecordPublisherRunResult.INCOMPLETE;
        }
        return complete ? RecordPublisher.RecordPublisherRunResult.COMPLETE : RecordPublisher.RecordPublisherRunResult.INCOMPLETE;
    }

    private void backoff(Throwable ex) throws InterruptedException {
        long backoffMillis = this.backoff.calculateFullJitterBackoff(this.configuration.getSubscribeToShardBaseBackoffMillis(), this.configuration.getSubscribeToShardMaxBackoffMillis(), this.configuration.getSubscribeToShardExpConstant(), this.attempt);
        LOG.warn("Encountered recoverable error {}. Backing off for {} millis {} ({})", new Object[]{ex.getCause().getClass().getSimpleName(), backoffMillis, this.subscribedShard.getShard().getShardId(), this.consumerArn, ex});
        this.backoff.sleep(backoffMillis);
    }

    private List<software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Record> toSdkV1Records(List<Record> records) {
        ArrayList<software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Record> sdkV1Records = new ArrayList<software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Record>();
        for (Record record : records) {
            sdkV1Records.add(this.toSdkV1Record(record));
        }
        return sdkV1Records;
    }

    private software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Record toSdkV1Record(@Nonnull Record record) {
        software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Record recordV1 = new software.amazon.kinesis.shaded.com.amazonaws.services.kinesis.model.Record().withData(record.data().asByteBuffer()).withSequenceNumber(record.sequenceNumber()).withPartitionKey(record.partitionKey()).withApproximateArrivalTimestamp(new Date(record.approximateArrivalTimestamp().toEpochMilli()));
        EncryptionType encryptionType = record.encryptionType();
        if (encryptionType != null) {
            recordV1.withEncryptionType(encryptionType.name());
        }
        return recordV1;
    }

    private StartingPosition toSdkV2StartingPosition(software.amazon.kinesis.connectors.flink.model.StartingPosition startingPosition) {
        StartingPosition.Builder builder = StartingPosition.builder().type(startingPosition.getShardIteratorType().toString());
        Object marker = startingPosition.getStartingMarker();
        switch (startingPosition.getShardIteratorType()) {
            case AT_TIMESTAMP: {
                Preconditions.checkNotNull((Object)marker, (String)"StartingPosition AT_TIMESTAMP date marker is null.");
                builder.timestamp(((Date)marker).toInstant());
                break;
            }
            case AT_SEQUENCE_NUMBER: 
            case AFTER_SEQUENCE_NUMBER: {
                Preconditions.checkNotNull((Object)marker, (String)"StartingPosition *_SEQUENCE_NUMBER position is null.");
                builder.sequenceNumber(marker.toString());
            }
        }
        return (StartingPosition)builder.build();
    }
}

