/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import software.amazon.jsii.JsiiError;

final class Util {
    static final int PROPERTY_METHOD_PREFIX_LEN = 3;

    private Util() {
    }

    static String readString(InputStream is) {
        try (Scanner s = new Scanner(is, "UTF-8");){
            s.useDelimiter("\\A");
            if (s.hasNext()) {
                String string = s.next();
                return string;
            }
            String string = "";
            return string;
        }
    }

    static boolean isJavaPropertyMethod(Method method) {
        String methodName = method.getName();
        if (methodName.length() <= 3) {
            return false;
        }
        if (methodName.startsWith("get") && method.getParameterCount() == 0) {
            return !Character.isLowerCase(methodName.charAt(3));
        }
        if (methodName.startsWith("set") && method.getParameterCount() == 1) {
            return !Character.isLowerCase(methodName.charAt(3)) && Util.isMatchingGetterPresent(method.getName().replaceFirst("set", "get"), method.getParameterTypes()[0], method.getDeclaringClass());
        }
        return false;
    }

    private static boolean isMatchingGetterPresent(String getterName, Class<?> returnType, Class<?> declaring) {
        try {
            Method getter = declaring.getDeclaredMethod(getterName, new Class[0]);
            return getter.getReturnType().equals(returnType);
        }
        catch (NoSuchMethodException nsme) {
            return !declaring.equals(Object.class) && Util.isMatchingGetterPresent(getterName, returnType, declaring.getSuperclass());
        }
    }

    static String javaPropertyToJSProperty(Method method) {
        String getterSetterMethod = method.getName();
        if (!Util.isJavaPropertyMethod(method)) {
            throw new JsiiError("Invalid getter/setter method. Must start with get/set");
        }
        String camelCase = getterSetterMethod.substring(3, 4).toLowerCase();
        if (getterSetterMethod.length() > 4) {
            camelCase = camelCase + getterSetterMethod.substring(4);
        }
        return camelCase;
    }

    static String javaScriptPropertyToJavaPropertyName(String prefix, String jsPropertyName) {
        if (jsPropertyName.isEmpty()) {
            throw new JsiiError("jsPropertyName must not be empty");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(jsPropertyName.substring(0, 1).toUpperCase());
        if (jsPropertyName.length() > 1) {
            sb.append(jsPropertyName.substring(1));
        }
        return sb.toString();
    }

    static Path extractResource(Class<?> klass, String resourceName, Path outputDirectory) throws IOException {
        Path directory = outputDirectory;
        if (directory == null) {
            directory = Files.createTempDirectory("jsii-java-runtime-resource", new FileAttribute[0]);
        }
        Path target = directory.resolve(resourceName);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (InputStream inputStream = klass.getResourceAsStream(resourceName);){
            Files.copy(inputStream, target, new CopyOption[0]);
        }
        return target;
    }
}

