/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import software.amazon.jsii.JsiiException;

public final class JsiiObjectRef {
    static final String TOKEN_REF = "$jsii.byref";
    private JsonNode node;
    private String objId;
    private String fqn;

    private JsiiObjectRef(String objId, JsonNode node) {
        this.objId = objId;
        this.node = node;
        int fqnDelimiter = this.objId.lastIndexOf("@");
        this.fqn = this.objId.substring(0, fqnDelimiter);
    }

    public static JsiiObjectRef parse(JsonNode objRef) {
        if (!objRef.has(TOKEN_REF)) {
            throw new JsiiException("Malformed object reference. Expecting $jsii.byref");
        }
        return new JsiiObjectRef(objRef.get(TOKEN_REF).textValue(), objRef);
    }

    public static JsiiObjectRef fromObjId(String objId) {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.put(TOKEN_REF, objId);
        return new JsiiObjectRef(objId, (JsonNode)node);
    }

    public String getFqn() {
        return this.fqn;
    }

    public JsonNode toJson() {
        return this.node;
    }

    public String getObjId() {
        return this.objId;
    }

    public String toString() {
        return this.objId;
    }
}

