/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiCallbackHandler;
import software.amazon.jsii.JsiiClient;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiModule;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiRuntime;
import software.amazon.jsii.Util;
import software.amazon.jsii.api.Callback;
import software.amazon.jsii.api.GetRequest;
import software.amazon.jsii.api.InvokeRequest;
import software.amazon.jsii.api.JsiiOverride;
import software.amazon.jsii.api.SetRequest;

public final class JsiiEngine
implements JsiiCallbackHandler {
    private static final JsiiEngine INSTANCE = new JsiiEngine();
    private static final String INTERFACE_PROXY_CLASS_NAME = "Jsii$Proxy";
    private final Map<String, Object> objects = new HashMap<String, Object>();
    private final JsiiRuntime runtime = new JsiiRuntime();
    private static final JsiiObjectMapper OM = new JsiiObjectMapper();
    private Set<Class<? extends JsiiModule>> loadedModules = new HashSet<Class<? extends JsiiModule>>();

    public static JsiiEngine getInstance() {
        return INSTANCE;
    }

    public JsiiClient getClient() {
        return this.runtime.getClient();
    }

    private JsiiEngine() {
        this.runtime.setCallbackHandler(this);
    }

    public void loadModule(Class<? extends JsiiModule> moduleClass) {
        JsiiModule module;
        if (!JsiiModule.class.isAssignableFrom(moduleClass)) {
            throw new JsiiException("Invalid module class " + moduleClass.getName() + ". It must be derived from JsiiModule");
        }
        if (this.loadedModules.contains(moduleClass)) {
            return;
        }
        try {
            module = moduleClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JsiiException(e);
        }
        for (Class<? extends JsiiModule> dep : module.getDependencies()) {
            this.loadModule(dep);
        }
        this.getClient().loadModule(module);
        this.loadedModules.add(moduleClass);
    }

    public void registerObject(JsiiObjectRef objRef, Object obj) {
        if (obj instanceof JsiiObject) {
            ((JsiiObject)obj).setObjRef(objRef);
        }
        this.objects.put(objRef.getObjId(), obj);
    }

    public Object nativeFromObjRef(JsiiObjectRef objRef) {
        Object obj = this.objects.get(objRef.getObjId());
        if (obj == null) {
            obj = this.createNative(objRef.getFqn());
            this.registerObject(objRef, obj);
        }
        return obj;
    }

    public JsiiObjectRef nativeToObjRef(Object nativeObject) {
        if (nativeObject instanceof JsiiObject) {
            return ((JsiiObject)nativeObject).getObjRef();
        }
        for (String objid : this.objects.keySet()) {
            Object obj = this.objects.get(objid);
            if (obj != nativeObject) continue;
            return JsiiObjectRef.fromObjId(objid);
        }
        return this.createNewObject(nativeObject, new Object[0]);
    }

    public Object getObject(JsiiObjectRef objRef) {
        Object obj = this.objects.get(objRef.getObjId());
        if (obj == null) {
            throw new JsiiException("Cannot find jsii object: " + objRef.getObjId());
        }
        return obj;
    }

    public Object getObject(JsonNode objRefNode) {
        return this.getObject(JsiiObjectRef.parse(objRefNode));
    }

    private String resolveJavaClassName(String fqn) {
        String[] parts = fqn.split("\\.");
        if (parts.length < 2) {
            throw new JsiiException("Malformed FQN: " + fqn);
        }
        String moduleName = parts[0];
        String typeName = String.join((CharSequence)".", Arrays.stream(parts).skip(1L).collect(Collectors.toList()));
        JsonNode names = this.getClient().getModuleNames(moduleName);
        if (!names.has("java")) {
            throw new JsiiException("No java name for module " + moduleName);
        }
        return names.get("java").get("package").textValue() + "." + typeName;
    }

    private JsiiObject createNative(String fqn) {
        String nativeName = this.resolveJavaClassName(fqn);
        try {
            Class<?> klass = Class.forName(nativeName);
            if (klass.isInterface()) {
                klass = Class.forName(nativeName + "$" + INTERFACE_PROXY_CLASS_NAME);
            }
            try {
                Constructor<?> ctor = klass.getDeclaredConstructor(JsiiObject.InitializationMode.class);
                ctor.setAccessible(true);
                JsiiObject newObj = (JsiiObject)ctor.newInstance(new Object[]{JsiiObject.InitializationMode.Jsii});
                ctor.setAccessible(false);
                return newObj;
            }
            catch (NoSuchMethodException e) {
                throw new JsiiException("Cannot create native object of type " + klass.getName() + " without a constructor that accepts an InitializationMode argument");
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JsiiException("Unable to instantiate a new object for FQN " + fqn + ": " + e.getMessage());
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("WARNING: Cannot find the class: " + nativeName + ". Defaulting to JsiiObject");
            return new JsiiObject(JsiiObject.InitializationMode.Jsii);
        }
    }

    public Enum<?> findEnumValue(String enumRef) {
        int sep = enumRef.lastIndexOf(47);
        if (sep == -1) {
            throw new JsiiException("Malformed enum reference: " + enumRef);
        }
        String typeName = enumRef.substring(0, sep);
        String valueName = enumRef.substring(sep + 1);
        String enumClass = this.resolveJavaClassName(typeName);
        try {
            Class<?> klass = Class.forName(enumClass);
            return Enum.valueOf(klass, valueName);
        }
        catch (ClassNotFoundException e) {
            throw new JsiiException("Cannot resolve enum type: " + enumClass);
        }
    }

    public void processAllPendingCallbacks() {
        List<Callback> callbacks;
        while ((callbacks = this.getClient().pendingCallbacks()).size() != 0) {
            callbacks.forEach(this::processCallback);
        }
    }

    @Override
    public JsonNode handleCallback(Callback callback) {
        if (callback.getInvoke() != null) {
            return this.invokeCallbackMethod(callback.getInvoke(), callback.getCookie());
        }
        if (callback.getGet() != null) {
            return this.invokeCallbackGet(callback.getGet());
        }
        if (callback.getSet() != null) {
            return this.invokeCallbackSet(callback.getSet());
        }
        throw new JsiiException("Unrecognized callback type: get/set/invoke");
    }

    private JsonNode invokeCallbackGet(GetRequest req) {
        Object obj = this.getObject((JsonNode)req.getObjref());
        String methodName = Util.javaScriptPropertyToJavaPropertyName("get", req.getProperty());
        try {
            Method getter = obj.getClass().getMethod(methodName, new Class[0]);
            return OM.valueToTree(this.invokeMethod(obj, getter, new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new JsiiException(e);
        }
    }

    private JsonNode invokeCallbackSet(SetRequest req) {
        Object obj = this.getObject(req.getObjref());
        String setterMethodName = Util.javaScriptPropertyToJavaPropertyName("set", req.getProperty());
        Method setter = null;
        for (Method method : obj.getClass().getMethods()) {
            if (!method.getName().equals(setterMethodName)) continue;
            setter = method;
            break;
        }
        if (setter == null) {
            throw new JsiiException("Unable to find property setter " + setterMethodName);
        }
        return OM.valueToTree(this.invokeMethod(obj, setter, req.getValue()));
    }

    private JsonNode invokeCallbackMethod(InvokeRequest req, String cookie) {
        Object obj = this.getObject((JsonNode)req.getObjref());
        Method method = this.findCallbackMethod(obj.getClass(), cookie);
        return OM.valueToTree(this.invokeMethod(obj, method, req.getArgs().toArray()));
    }

    private Object invokeMethod(Object obj, Method method, Object ... args) {
        boolean accessibility = method.isAccessible();
        method.setAccessible(true);
        try {
            Object object = method.invoke(obj, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw new JsiiException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new JsiiException(e);
        }
        finally {
            method.setAccessible(accessibility);
        }
    }

    private void processCallback(Callback callback) {
        try {
            JsonNode result = this.handleCallback(callback);
            this.getClient().completeCallback(callback, null, result);
        }
        catch (JsiiException e) {
            this.getClient().completeCallback(callback, e.getMessage(), null);
        }
    }

    private Method findCallbackMethod(Class<?> klass, String signature) {
        for (Method method : klass.getMethods()) {
            if (!method.toString().equals(signature)) continue;
            return method;
        }
        throw new JsiiException("Unable to find callback method with signature: " + signature);
    }

    public JsiiObjectRef createNewObject(Object uninitializedNativeObject, Object ... args) {
        Class<?> klass = uninitializedNativeObject.getClass();
        Jsii jsii = JsiiEngine.tryGetJsiiAnnotation(klass, true);
        String fqn = "Object";
        if (jsii != null) {
            fqn = jsii.fqn();
            this.loadModule(jsii.module());
        }
        Collection<JsiiOverride> overrides = JsiiEngine.discoverOverrides(klass);
        JsiiObjectRef objRef = this.getClient().createObject(fqn, Arrays.asList(args), overrides);
        this.registerObject(objRef, uninitializedNativeObject);
        return objRef;
    }

    private static Collection<JsiiOverride> discoverOverrides(Class<?> classToInspect) {
        HashMap<String, JsiiOverride> overrides = new HashMap<String, JsiiOverride>();
        for (Class<?> klass = classToInspect; klass != null && ((Jsii[])klass.getDeclaredAnnotationsByType(Jsii.class)).length == 0 && klass != Object.class; klass = klass.getSuperclass()) {
            for (Method method : klass.getDeclaredMethods()) {
                String methodName = method.getName();
                if (Util.isJavaPropertyMethod(methodName)) {
                    String propertyName = Util.javaPropertyToJSProperty(methodName);
                    if (overrides.containsKey(propertyName)) continue;
                    JsiiOverride override = new JsiiOverride();
                    override.setProperty(propertyName);
                    overrides.put(propertyName, override);
                    continue;
                }
                if (overrides.containsKey(methodName)) continue;
                JsiiOverride override = new JsiiOverride();
                override.setMethod(methodName);
                override.setCookie(method.toString());
                overrides.put(methodName, override);
            }
        }
        return overrides.values();
    }

    static Jsii tryGetJsiiAnnotation(Class<?> type, boolean inherited) {
        Jsii[] ann = inherited ? (Jsii[])type.getAnnotationsByType(Jsii.class) : (Jsii[])type.getDeclaredAnnotationsByType(Jsii.class);
        if (ann.length == 0) {
            return null;
        }
        return ann[0];
    }

    String loadModuleForClass(Class<?> nativeClass) {
        Jsii jsii = JsiiEngine.tryGetJsiiAnnotation(nativeClass, true);
        if (jsii == null) {
            throw new JsiiException("Unable to find @Jsii annotation for class");
        }
        this.loadModule(jsii.module());
        return jsii.fqn();
    }
}

