/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiModule;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiPromise;
import software.amazon.jsii.JsiiRuntime;
import software.amazon.jsii.Util;
import software.amazon.jsii.api.Callback;
import software.amazon.jsii.api.CreateRequest;
import software.amazon.jsii.api.JsiiOverride;

public final class JsiiClient {
    private static final JsonNodeFactory JSON = JsonNodeFactory.instance;
    private static final ObjectMapper STD_OM = new ObjectMapper();
    private static final JsiiObjectMapper JSII_OM = new JsiiObjectMapper();
    private final JsiiRuntime runtime;

    public JsiiClient(JsiiRuntime runtime) {
        this.runtime = runtime;
    }

    public void loadModule(JsiiModule module) {
        try {
            String tarball = Util.extractResource(module.getModuleClass(), module.getBundleResourceName(), null);
            ObjectNode req = this.makeRequest("load");
            req.put("tarball", tarball);
            req.put("name", module.getModuleName());
            req.put("version", module.getModuleVersion());
            this.runtime.requestResponse((JsonNode)req);
        }
        catch (IOException e) {
            throw new JsiiException("Unable to extract resource " + module.getBundleResourceName(), e);
        }
    }

    public JsiiObjectRef createObject(String fqn, List<Object> initializerArgs) {
        return this.createObject(fqn, initializerArgs, Collections.emptyList());
    }

    public JsiiObjectRef createObject(String fqn, Collection<Object> initializerArgs, Collection<JsiiOverride> overrides) {
        CreateRequest request = new CreateRequest();
        request.setFqn(fqn);
        request.setArgs(initializerArgs);
        request.setOverrides(overrides);
        ObjectNode req = (ObjectNode)JSII_OM.valueToTree(request);
        req.put("api", "create");
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return JsiiObjectRef.parse(resp);
    }

    public void deleteObject(JsiiObjectRef objRef) {
        ObjectNode req = this.makeRequest("del", objRef);
        this.runtime.requestResponse((JsonNode)req);
    }

    public JsonNode getPropertyValue(JsiiObjectRef objRef, String property) {
        ObjectNode req = this.makeRequest("get", objRef);
        req.put("property", property);
        return this.runtime.requestResponse((JsonNode)req).get("value");
    }

    public void setPropertyValue(JsiiObjectRef objRef, String property, JsonNode value) {
        ObjectNode req = this.makeRequest("set", objRef);
        req.put("property", property);
        req.set("value", value);
        this.runtime.requestResponse((JsonNode)req);
    }

    public JsonNode getStaticPropertyValue(String fqn, String property) {
        ObjectNode req = this.makeRequest("sget");
        req.put("fqn", fqn);
        req.put("property", property);
        return this.runtime.requestResponse((JsonNode)req).get("value");
    }

    public void setStaticPropertyValue(String fqn, String property, JsonNode value) {
        ObjectNode req = this.makeRequest("sset");
        req.put("fqn", fqn);
        req.put("property", property);
        req.set("value", value);
        this.runtime.requestResponse((JsonNode)req);
    }

    public JsonNode callStaticMethod(String fqn, String method, ArrayNode args) {
        ObjectNode req = this.makeRequest("sinvoke");
        req.put("fqn", fqn);
        req.put("method", method);
        req.set("args", (JsonNode)args);
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return resp.get("result");
    }

    public JsonNode callMethod(JsiiObjectRef objRef, String method, ArrayNode args) {
        ObjectNode req = this.makeRequest("invoke", objRef);
        req.put("method", method);
        req.set("args", (JsonNode)args);
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return resp.get("result");
    }

    public JsiiPromise beginAsyncMethod(JsiiObjectRef objRef, String method, ArrayNode args) {
        ObjectNode req = this.makeRequest("begin", objRef);
        req.put("method", method);
        req.set("args", (JsonNode)args);
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return new JsiiPromise(resp.get("promiseid").asText());
    }

    public JsonNode endAsyncMethod(JsiiPromise promise) {
        ObjectNode req = this.makeRequest("end");
        req.put("promiseid", promise.getPromiseId());
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        if (resp == null) {
            return null;
        }
        return resp.get("result");
    }

    public List<Callback> pendingCallbacks() {
        ObjectNode req = this.makeRequest("callbacks");
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        JsonNode callbacksResp = resp.get("callbacks");
        if (callbacksResp == null || !callbacksResp.isArray()) {
            throw new JsiiException("Expecting a 'callbacks' key with an array in response");
        }
        ArrayNode callbacksArray = (ArrayNode)callbacksResp;
        ArrayList<Callback> result = new ArrayList<Callback>();
        callbacksArray.forEach(node -> {
            try {
                result.add((Callback)STD_OM.treeToValue((TreeNode)node, Callback.class));
            }
            catch (JsonProcessingException e) {
                throw new JsiiException(e);
            }
        });
        return result;
    }

    public void completeCallback(Callback callback, String error, JsonNode result) {
        ObjectNode req = this.makeRequest("complete");
        req.put("cbid", callback.getCbid());
        req.put("err", error);
        req.set("result", result);
        this.runtime.requestResponse((JsonNode)req);
    }

    public JsonNode getModuleNames(String moduleName) {
        ObjectNode req = this.makeRequest("naming");
        req.put("assembly", moduleName);
        JsonNode resp = this.runtime.requestResponse((JsonNode)req);
        return resp.get("naming");
    }

    private ObjectNode makeRequest(String api) {
        ObjectNode req = JSON.objectNode();
        req.put("api", api);
        return req;
    }

    private ObjectNode makeRequest(String api, JsiiObjectRef objRef) {
        ObjectNode req = this.makeRequest(api);
        req.set("objref", objRef.toJson());
        return req;
    }

    private static JsonNode readJsonResponse(HttpURLConnection conn) throws IOException {
        String responseText = "";
        try {
            responseText = Util.readString(conn.getInputStream());
            if (responseText.isEmpty()) {
                return null;
            }
            return STD_OM.readTree(responseText);
        }
        catch (JsonParseException e2) {
            throw new JsiiException("Unexpected response: \n" + responseText);
        }
        catch (IOException e) {
            responseText = Util.readString(conn.getErrorStream());
            JsonNode error = STD_OM.readTree(responseText);
            if (error.has("error")) {
                responseText = error.get("error").textValue();
            }
            if (responseText == null || responseText.isEmpty()) {
                responseText = e.getMessage();
            }
            throw new JsiiException(responseText);
        }
    }

    private static void writeJsonRequest(HttpURLConnection conn, JsonNode json) throws IOException {
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/json");
        try (OutputStream request = conn.getOutputStream();){
            request.write(json.toString().getBytes("UTF-8"));
        }
    }
}

