/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiCallbackHandler;
import software.amazon.jsii.JsiiClient;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiModule;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiRuntime;
import software.amazon.jsii.NativeType;
import software.amazon.jsii.Util;
import software.amazon.jsii.api.Callback;
import software.amazon.jsii.api.GetRequest;
import software.amazon.jsii.api.InvokeRequest;
import software.amazon.jsii.api.JsiiOverride;
import software.amazon.jsii.api.SetRequest;

public final class JsiiEngine
implements JsiiCallbackHandler {
    private static final JsiiEngine INSTANCE = new JsiiEngine();
    private static final String INTERFACE_PROXY_CLASS_NAME = "Jsii$Proxy";
    private final Map<String, Object> objects = new HashMap<String, Object>();
    private final JsiiRuntime runtime = new JsiiRuntime();
    private Map<String, JsiiModule> loadedModules = new HashMap<String, JsiiModule>();
    private boolean quietMode = true;

    public static JsiiEngine getInstance() {
        return INSTANCE;
    }

    public static void setQuietMode(boolean value) {
        JsiiEngine.getInstance().quietMode = value;
    }

    public JsiiClient getClient() {
        return this.runtime.getClient();
    }

    private JsiiEngine() {
        this.runtime.setCallbackHandler(this);
    }

    public void loadModule(Class<? extends JsiiModule> moduleClass) {
        JsiiModule module;
        if (!JsiiModule.class.isAssignableFrom(moduleClass)) {
            throw new JsiiException("Invalid module class " + moduleClass.getName() + ". It must be derived from JsiiModule");
        }
        try {
            module = moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JsiiException(e);
        }
        if (this.loadedModules.containsKey(module.getModuleName())) {
            return;
        }
        for (Class<? extends JsiiModule> dep : module.getDependencies()) {
            this.loadModule(dep);
        }
        this.getClient().loadModule(module);
        this.loadedModules.put(module.getModuleName(), module);
    }

    public void registerObject(JsiiObjectRef objRef, Object obj) {
        this.objects.put(objRef.getObjId(), obj);
    }

    public Object nativeFromObjRef(JsiiObjectRef objRef) {
        Object obj = this.objects.get(objRef.getObjId());
        if (obj == null) {
            obj = this.createNativeProxy(objRef.getFqn(), objRef);
            this.registerObject(objRef, obj);
        }
        return obj;
    }

    public JsiiObjectRef nativeToObjRef(Object nativeObject) {
        if (nativeObject instanceof JsiiObject) {
            return ((JsiiObject)nativeObject).getObjRef();
        }
        for (String objid : this.objects.keySet()) {
            Object obj = this.objects.get(objid);
            if (obj != nativeObject) continue;
            return JsiiObjectRef.fromObjId(objid);
        }
        return this.createNewObject(nativeObject, new Object[0]);
    }

    public Object getObject(JsiiObjectRef objRef) {
        Object obj = this.objects.get(objRef.getObjId());
        if (obj == null) {
            throw new JsiiException("Cannot find jsii object: " + objRef.getObjId());
        }
        return obj;
    }

    public Object getObject(JsonNode objRefNode) {
        return this.getObject(JsiiObjectRef.parse(objRefNode));
    }

    Class<?> resolveJavaClass(String fqn) {
        if ("Object".equals(fqn)) {
            return JsiiObject.class;
        }
        String[] parts = fqn.split("\\.");
        if (parts.length < 2) {
            throw new JsiiException("Malformed FQN: " + fqn);
        }
        String moduleName = parts[0];
        JsonNode names = this.getClient().getModuleNames(moduleName);
        if (!names.has("java")) {
            throw new JsiiException("No java name for module " + moduleName);
        }
        JsiiModule module = this.loadedModules.get(moduleName);
        if (module == null) {
            throw new JsiiException("No loaded module is named " + moduleName);
        }
        try {
            return module.resolveClass(fqn);
        }
        catch (ClassNotFoundException cfne) {
            throw new JsiiException(cfne);
        }
    }

    private JsiiObject createNativeProxy(String fqn, JsiiObjectRef objRef) {
        try {
            Class<?> klass = this.resolveJavaClass(fqn);
            if (klass.isInterface() || Modifier.isAbstract(klass.getModifiers())) {
                klass = Class.forName(klass.getCanonicalName() + "$" + INTERFACE_PROXY_CLASS_NAME);
            }
            try {
                Constructor<?> ctor = klass.getDeclaredConstructor(JsiiObjectRef.class);
                ctor.setAccessible(true);
                JsiiObject newObj = (JsiiObject)ctor.newInstance(objRef);
                ctor.setAccessible(false);
                return newObj;
            }
            catch (NoSuchMethodException e) {
                throw new JsiiException("Cannot create native object of type " + klass.getName() + " without a constructor that accepts an InitializationMode argument", e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JsiiException("Unable to instantiate a new object for FQN " + fqn + ": " + e.getMessage(), e);
            }
        }
        catch (ClassNotFoundException e) {
            this.log("WARNING: Cannot find the class: %s. Defaulting to JsiiObject", fqn);
            return new JsiiObject(objRef);
        }
    }

    public Enum<?> findEnumValue(String enumRef) {
        int sep = enumRef.lastIndexOf(47);
        if (sep == -1) {
            throw new JsiiException("Malformed enum reference: " + enumRef);
        }
        String typeName = enumRef.substring(0, sep);
        String valueName = enumRef.substring(sep + 1);
        Class<?> klass = this.resolveJavaClass(typeName);
        return Enum.valueOf(klass, valueName);
    }

    public void processAllPendingCallbacks() {
        List<Callback> callbacks;
        while ((callbacks = this.getClient().pendingCallbacks()).size() != 0) {
            callbacks.forEach(this::processCallback);
        }
    }

    @Override
    public JsonNode handleCallback(Callback callback) {
        if (callback.getInvoke() != null) {
            return this.invokeCallbackMethod(callback.getInvoke(), callback.getCookie());
        }
        if (callback.getGet() != null) {
            return this.invokeCallbackGet(callback.getGet());
        }
        if (callback.getSet() != null) {
            return this.invokeCallbackSet(callback.getSet());
        }
        throw new JsiiException("Unrecognized callback type: get/set/invoke");
    }

    private JsonNode invokeCallbackGet(GetRequest req) {
        Object obj = this.getObject((JsonNode)req.getObjref());
        String methodName = Util.javaScriptPropertyToJavaPropertyName("get", req.getProperty());
        Method getter = this.findCallbackGetter(obj.getClass(), methodName);
        return JsiiObjectMapper.valueToTree(this.invokeMethod(obj, getter, new Object[0]));
    }

    private JsonNode invokeCallbackSet(SetRequest req) {
        Object obj = this.getObject(req.getObjref());
        String getterMethodName = Util.javaScriptPropertyToJavaPropertyName("get", req.getProperty());
        Method getter = this.findCallbackGetter(obj.getClass(), getterMethodName);
        String setterMethodName = getterMethodName.replaceFirst("g", "s");
        Method setter = this.findCallbackSetter(obj.getClass(), setterMethodName, getter.getReturnType());
        Object arg = JsiiObjectMapper.treeToValue(req.getValue(), NativeType.forType(setter.getGenericParameterTypes()[0]));
        return JsiiObjectMapper.valueToTree(this.invokeMethod(obj, setter, arg));
    }

    private JsonNode invokeCallbackMethod(InvokeRequest req, String cookie) {
        Object obj = this.getObject((JsonNode)req.getObjref());
        Method method = this.findCallbackMethod(obj.getClass(), cookie);
        Type[] argTypes = method.getGenericParameterTypes();
        Object[] args = new Object[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            args[i] = JsiiObjectMapper.treeToValue(req.getArgs().get(i), NativeType.forType(argTypes[i]));
        }
        return JsiiObjectMapper.valueToTree(this.invokeMethod(obj, method, args));
    }

    private Object invokeMethod(Object obj, Method method, Object ... args) {
        boolean accessibility = method.isAccessible();
        method.setAccessible(true);
        try {
            Object object = method.invoke(obj, args);
            return object;
        }
        catch (Exception e) {
            try {
                StringWriter sw = new StringWriter();
                try (PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                }
                this.log("Error while invoking %s with %s: %s", method, Arrays.toString(args), sw.toString());
                throw e;
            }
            catch (InvocationTargetException e2) {
                throw new JsiiException(e2.getTargetException());
            }
            catch (IllegalAccessException e3) {
                throw new JsiiException(e3);
            }
        }
        finally {
            method.setAccessible(accessibility);
        }
    }

    private void processCallback(Callback callback) {
        try {
            JsonNode result = this.handleCallback(callback);
            this.getClient().completeCallback(callback, null, result);
        }
        catch (JsiiException e) {
            this.getClient().completeCallback(callback, e.getMessage(), null);
        }
    }

    private Method findCallbackMethod(Class<?> klass, String signature) {
        for (Method method : klass.getDeclaredMethods()) {
            if (!method.toString().equals(signature)) continue;
            return method;
        }
        if (klass.getSuperclass() != null) {
            return this.findCallbackMethod(klass.getSuperclass(), signature);
        }
        throw new JsiiException("Unable to find callback method with signature: " + signature);
    }

    private Method findCallbackGetter(Class<?> klass, String methodName) {
        try {
            return klass.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            if (klass.getSuperclass() != null) {
                try {
                    return this.findCallbackGetter(klass.getSuperclass(), methodName);
                }
                catch (JsiiException jsiiException) {
                    // empty catch block
                }
            }
            throw new JsiiException(nsme);
        }
    }

    private Method findCallbackSetter(Class<?> klass, String methodName, Class<?> valueType) {
        try {
            return klass.getDeclaredMethod(methodName, valueType);
        }
        catch (NoSuchMethodException nsme) {
            if (klass.getSuperclass() != null) {
                try {
                    return this.findCallbackSetter(klass.getSuperclass(), methodName, valueType);
                }
                catch (JsiiException jsiiException) {
                    // empty catch block
                }
            }
            throw new JsiiException(nsme);
        }
    }

    public JsiiObjectRef createNewObject(Object uninitializedNativeObject, Object ... args) {
        Class<?> klass = uninitializedNativeObject.getClass();
        Jsii jsii = JsiiEngine.tryGetJsiiAnnotation(klass, true);
        String fqn = "Object";
        if (jsii != null) {
            fqn = jsii.fqn();
            this.loadModule(jsii.module());
        }
        Collection<JsiiOverride> overrides = JsiiEngine.discoverOverrides(klass);
        Collection<String> interfaces = this.discoverInterfaces(klass);
        JsiiObjectRef objRef = this.getClient().createObject(fqn, Arrays.asList(args), overrides, interfaces);
        this.registerObject(objRef, uninitializedNativeObject);
        if (uninitializedNativeObject instanceof JsiiObject) {
            ((JsiiObject)uninitializedNativeObject).setObjRef(objRef);
        }
        return objRef;
    }

    private static Collection<JsiiOverride> discoverOverrides(Class<?> classToInspect) {
        HashMap<String, JsiiOverride> overrides = new HashMap<String, JsiiOverride>();
        for (Class<?> klass = classToInspect; klass != null && ((Jsii[])klass.getDeclaredAnnotationsByType(Jsii.class)).length == 0 && klass != Object.class && klass != JsiiObject.class; klass = klass.getSuperclass()) {
            for (Method method : klass.getDeclaredMethods()) {
                if (Modifier.isPrivate(method.getModifiers())) continue;
                String methodName = method.getName();
                if (Util.isJavaPropertyMethod(method)) {
                    String propertyName = Util.javaPropertyToJSProperty(method);
                    if (overrides.containsKey(propertyName)) continue;
                    JsiiOverride override = new JsiiOverride();
                    override.setProperty(propertyName);
                    overrides.put(propertyName, override);
                    continue;
                }
                if (overrides.containsKey(methodName)) continue;
                JsiiOverride override = new JsiiOverride();
                override.setMethod(methodName);
                override.setCookie(method.toString());
                overrides.put(methodName, override);
            }
        }
        return overrides.values();
    }

    private Collection<String> discoverInterfaces(Class<?> classToInspect) {
        HashSet<String> interfaces = new HashSet<String>();
        if (classToInspect.isAnnotationPresent(Jsii.class)) {
            if (classToInspect.isInterface()) {
                Jsii jsii = classToInspect.getAnnotation(Jsii.class);
                interfaces.add(jsii.fqn());
            }
            return interfaces;
        }
        for (Class<?> iface : classToInspect.getInterfaces()) {
            interfaces.addAll(this.discoverInterfaces(iface));
        }
        return interfaces;
    }

    private void log(String format, Object ... args) {
        if (!this.quietMode) {
            System.err.println(String.format(format, args));
        }
    }

    static Jsii tryGetJsiiAnnotation(Class<?> type, boolean inherited) {
        Jsii[] ann = inherited ? (Jsii[])type.getAnnotationsByType(Jsii.class) : (Jsii[])type.getDeclaredAnnotationsByType(Jsii.class);
        if (ann.length == 0) {
            return null;
        }
        return ann[0];
    }

    String loadModuleForClass(Class<?> nativeClass) {
        Jsii jsii = JsiiEngine.tryGetJsiiAnnotation(nativeClass, true);
        if (jsii == null) {
            throw new JsiiException("Unable to find @Jsii annotation for class");
        }
        this.loadModule(jsii.module());
        return jsii.fqn();
    }
}

