/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ionpathextraction;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import software.amazon.ion.IonReader;
import software.amazon.ionpathextraction.PathComponentParser;
import software.amazon.ionpathextraction.PathExtractor;
import software.amazon.ionpathextraction.PathExtractorConfig;
import software.amazon.ionpathextraction.PathExtractorImpl;
import software.amazon.ionpathextraction.SearchPath;
import software.amazon.ionpathextraction.pathcomponents.PathComponent;
import software.amazon.ionpathextraction.utils.Preconditions;

public final class PathExtractorBuilder<T> {
    private static final boolean DEFAULT_MATCH_RELATIVE_PATHS = false;
    private static final boolean DEFAULT_CASE_INSENSITIVE = false;
    private final List<SearchPath<T>> searchPaths = new ArrayList<SearchPath<T>>();
    private boolean matchRelativePaths;
    private boolean matchCaseInsensitive;

    private PathExtractorBuilder() {
    }

    public static <T> PathExtractorBuilder<T> standard() {
        PathExtractorBuilder<T> builder = new PathExtractorBuilder<T>();
        builder.matchCaseInsensitive = false;
        builder.matchRelativePaths = false;
        return builder;
    }

    public PathExtractor<T> build() {
        return new PathExtractorImpl<T>(this.searchPaths, new PathExtractorConfig(this.matchRelativePaths, this.matchCaseInsensitive));
    }

    public PathExtractorBuilder<T> withMatchRelativePaths(boolean matchRelativePaths) {
        this.matchRelativePaths = matchRelativePaths;
        return this;
    }

    public PathExtractorBuilder<T> withMatchCaseInsensitive(boolean matchCaseInsensitive) {
        this.matchCaseInsensitive = matchCaseInsensitive;
        return this;
    }

    public PathExtractorBuilder<T> withSearchPath(String searchPathAsIon, Function<IonReader, Integer> callback) {
        Preconditions.checkArgument(callback != null, "callback cannot be null");
        this.withSearchPath(searchPathAsIon, (IonReader reader, T t) -> (Integer)callback.apply((IonReader)reader));
        return this;
    }

    public PathExtractorBuilder<T> withSearchPath(String searchPathAsIon, BiFunction<IonReader, T, Integer> callback) {
        Preconditions.checkArgument(searchPathAsIon != null, "searchPathAsIon cannot be null");
        List<PathComponent> pathComponents = PathComponentParser.parse(searchPathAsIon);
        this.withSearchPath(pathComponents, callback);
        return this;
    }

    public PathExtractorBuilder<T> withSearchPath(List<PathComponent> pathComponents, Function<IonReader, Integer> callback) {
        Preconditions.checkArgument(callback != null, "callback cannot be null");
        this.withSearchPath(pathComponents, (IonReader reader, T t) -> (Integer)callback.apply((IonReader)reader));
        return this;
    }

    public PathExtractorBuilder<T> withSearchPath(List<PathComponent> pathComponents, BiFunction<IonReader, T, Integer> callback) {
        Preconditions.checkArgument(pathComponents != null, "pathComponents cannot be null");
        Preconditions.checkArgument(callback != null, "callback cannot be null");
        this.searchPaths.add(new SearchPath<T>(pathComponents, callback));
        return this;
    }
}

