/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ionpathextraction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.system.IonReaderBuilder;
import software.amazon.ion.system.IonTextWriterBuilder;
import software.amazon.ionpathextraction.exceptions.PathExtractionException;
import software.amazon.ionpathextraction.pathcomponents.Index;
import software.amazon.ionpathextraction.pathcomponents.PathComponent;
import software.amazon.ionpathextraction.pathcomponents.Text;
import software.amazon.ionpathextraction.pathcomponents.Wildcard;
import software.amazon.ionpathextraction.utils.Preconditions;

class PathComponentParser {
    private static final IonReaderBuilder READER_BUILDER = IonReaderBuilder.standard();
    private static final IonTextWriterBuilder WRITER_BUILDER = IonTextWriterBuilder.standard();
    private static final String WILDCARD_ESCAPE_ANNOTATION = "$ion_extractor_field";

    private PathComponentParser() {
    }

    static List<PathComponent> parse(String ionPathExpression) {
        List<PathComponent> pathComponents;
        try (IonReader reader = PathComponentParser.newIonReader(ionPathExpression);){
            Preconditions.checkArgument(reader.next() != null, "ionPathExpression cannot be empty");
            Preconditions.checkArgument(reader.getType() == IonType.SEXP || reader.getType() == IonType.LIST, "ionPathExpression must be a s-expression or list");
            reader.stepIn();
            pathComponents = PathComponentParser.readStates(reader);
        }
        catch (IOException e) {
            throw new PathExtractionException(e);
        }
        return pathComponents;
    }

    private static List<PathComponent> readStates(IonReader reader) {
        ArrayList<PathComponent> pathComponents = new ArrayList<PathComponent>();
        block4: while (reader.next() != null) {
            switch (reader.getType()) {
                case INT: {
                    pathComponents.add(new Index(reader.intValue()));
                    continue block4;
                }
                case STRING: 
                case SYMBOL: {
                    if (PathComponentParser.isWildcard(reader)) {
                        pathComponents.add(Wildcard.INSTANCE);
                        continue block4;
                    }
                    pathComponents.add(new Text(reader.stringValue()));
                    continue block4;
                }
            }
            throw new PathExtractionException("Invalid path component type: " + PathComponentParser.readIonText(reader));
        }
        return pathComponents;
    }

    private static String readIonText(IonReader reader) {
        StringBuilder out = new StringBuilder();
        try (IonWriter writer = PathComponentParser.newIonTextWriter(out);){
            writer.writeValue(reader);
        }
        catch (IOException e) {
            throw new PathExtractionException(e);
        }
        return out.toString();
    }

    private static boolean isWildcard(IonReader reader) {
        if (reader.stringValue().equals("*")) {
            String[] annotations = reader.getTypeAnnotations();
            return annotations.length == 0 || !WILDCARD_ESCAPE_ANNOTATION.equals(annotations[0]);
        }
        return false;
    }

    private static IonReader newIonReader(String ionText) {
        return READER_BUILDER.build(ionText);
    }

    private static IonWriter newIonTextWriter(StringBuilder out) {
        return WRITER_BUILDER.build((Appendable)out);
    }
}

