/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class AESDecryptOutput {
    private final ByteBuffer plaintext;

    protected AESDecryptOutput(BuilderImpl builder) {
        this.plaintext = builder.plaintext();
    }

    public ByteBuffer plaintext() {
        return this.plaintext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer plaintext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AESDecryptOutput model) {
            this.plaintext = model.plaintext();
        }

        @Override
        public Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = plaintext;
            return this;
        }

        @Override
        public ByteBuffer plaintext() {
            return this.plaintext;
        }

        @Override
        public AESDecryptOutput build() {
            if (Objects.isNull(this.plaintext())) {
                throw new IllegalArgumentException("Missing value for required field `plaintext`");
            }
            return new AESDecryptOutput(this);
        }
    }

    public static interface Builder {
        public Builder plaintext(ByteBuffer var1);

        public ByteBuffer plaintext();

        public AESDecryptOutput build();
    }
}

