/*
 * Decompiled with CFR 0.152.
 */
package Materials_Compile;

import BoundedInts_Compile.uint8;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.InitializeDecryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.InitializeEncryptionMaterialsInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.None;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm_ECDSA;
import software.amazon.cryptography.materialproviders.internaldafny.types.SignatureAlgorithm_None;

public class __default {
    public static Result<EncryptionMaterials, Error> InitializeEncryptionMaterials(InitializeEncryptionMaterialsInput input) {
        InitializeEncryptionMaterialsInput _pat_let_tv0 = input;
        InitializeEncryptionMaterialsInput _pat_let_tv1 = input;
        InitializeEncryptionMaterialsInput _pat_let_tv2 = input;
        Outcome<Error> _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !input.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption Context ")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _1_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<InitializeEncryptionMaterialsInput, Boolean>)_2_input -> Helpers.Quantifier((Iterable)_2_input.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0 = _forall_var_0_boxed0;
            DafnySequence _3_key = _forall_var_0;
            if (ValidUTF8Bytes._Is((DafnySequence<? extends Byte>)_3_key)) {
                return !_2_input.dtor_requiredEncryptionContextKeys().contains((Object)_3_key) || _2_input.dtor_encryptionContext().contains((Object)_3_key);
            }
            return true;
        })).apply(input), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Required encryption context keys do not exist in provided encryption context.")));
        if (_1_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _1_valueOrError1.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        AlgorithmSuiteInfo _4_suite = AlgorithmSuites_Compile.__default.GetSuite(input.dtor_algorithmSuiteId());
        Outcome<Error> _5_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _4_suite.dtor_signature().is_ECDSA() == (input.dtor_signingKey().is_Some() && input.dtor_verificationKey().is_Some()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Missing signature key for signed suite.")));
        if (_5_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _5_valueOrError2.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _6_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _4_suite.dtor_signature().is_None() == (input.dtor_signingKey().is_None() && input.dtor_verificationKey().is_None()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Signature key not allowed for non-signed suites.")));
        if (_6_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _6_valueOrError3.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Result _7_valueOrError4 = ((Function<SignatureAlgorithm, Result>)_source0_boxed0 -> {
            SignatureAlgorithm _source0 = _source0_boxed0;
            if (_source0.is_ECDSA()) {
                ECDSA _8___mcc_h0;
                ECDSA _9_curve = _8___mcc_h0 = ((SignatureAlgorithm_ECDSA)_source0)._ECDSA;
                Result<DafnySequence<? extends Byte>, Error> _10_valueOrError5 = UTF8.__default.Encode(Base64_Compile.__default.Encode(_pat_let_tv0.dtor_verificationKey().dtor_value())).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _11_e_boxed0 -> {
                    DafnySequence _11_e = _11_e_boxed0;
                    return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_11_e);
                });
                if (_10_valueOrError5.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
                    return _10_valueOrError5.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
                }
                DafnySequence<? extends Byte> _12_enc__vk = _10_valueOrError5.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
                return Result.create_Success(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor(), DafnyMap.update(_pat_let_tv1.dtor_encryptionContext(), __default.EC__PUBLIC__KEY__FIELD(), _12_enc__vk));
            }
            None _13___mcc_h2 = ((SignatureAlgorithm_None)_source0)._None;
            SignatureAlgorithm _14_None = _4_suite.dtor_signature();
            return Result.create_Success(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor(), _pat_let_tv2.dtor_encryptionContext());
        }).apply(_4_suite.dtor_signature());
        if (_7_valueOrError4.IsFailure(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor())) {
            return _7_valueOrError4.PropagateFailure(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        DafnyMap _15_encryptionContext = (DafnyMap)_7_valueOrError4.Extract(DafnyMap._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor());
        return Result.create_Success(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), EncryptionMaterials.create(_4_suite, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_15_encryptionContext, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.empty(EncryptedDataKey._typeDescriptor()), input.dtor_requiredEncryptionContextKeys(), Option.create_None(DafnySequence._typeDescriptor(uint8._typeDescriptor())), input.dtor_signingKey(), _4_suite.dtor_symmetricSignature().is_None() ? Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()))) : Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), DafnySequence.empty((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())))));
    }

    public static Result<DecryptionMaterials, Error> InitializeDecryptionMaterials(InitializeDecryptionMaterialsInput input) {
        Outcome<Error> _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<InitializeDecryptionMaterialsInput, Boolean>)_1_input -> Helpers.Quantifier((Iterable)_1_input.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0 = _forall_var_0_boxed0;
            DafnySequence _2_key = _forall_var_0;
            if (ValidUTF8Bytes._Is((DafnySequence<? extends Byte>)_2_key)) {
                return !_1_input.dtor_requiredEncryptionContextKeys().contains((Object)_2_key) || _1_input.dtor_encryptionContext().contains((Object)_2_key);
            }
            return true;
        })).apply(input), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Reporoduced encryption context key did not exist in provided encryption context.")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        AlgorithmSuiteInfo _3_suite = AlgorithmSuites_Compile.__default.GetSuite(input.dtor_algorithmSuiteId());
        Outcome<Error> _4_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _3_suite.dtor_signature().is_ECDSA() == input.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption Context missing verification key.")));
        if (_4_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _4_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _5_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _3_suite.dtor_signature().is_None() == !input.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Verification key can not exist in non-signed Algorithm Suites.")));
        if (_5_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _5_valueOrError2.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Result<Option<DafnySequence<? extends Byte>>, Error> _6_valueOrError3 = __default.DecodeVerificationKey(input.dtor_encryptionContext());
        if (_6_valueOrError3.IsFailure(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor())) {
            return _6_valueOrError3.PropagateFailure(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Option<DafnySequence<? extends Byte>> _7_verificationKey = _6_valueOrError3.Extract(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor());
        return Result.create_Success(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), DecryptionMaterials.create(_3_suite, input.dtor_encryptionContext(), input.dtor_requiredEncryptionContextKeys(), Option.create_None(DafnySequence._typeDescriptor(uint8._typeDescriptor())), _7_verificationKey, Option.create_None(DafnySequence._typeDescriptor(uint8._typeDescriptor()))));
    }

    public static Result<Option<DafnySequence<? extends Byte>>, Error> DecodeVerificationKey(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext) {
        if (encryptionContext.contains(__default.EC__PUBLIC__KEY__FIELD())) {
            DafnySequence _0_utf8Key = (DafnySequence)encryptionContext.get(__default.EC__PUBLIC__KEY__FIELD());
            Result<DafnySequence<? extends Character>, Error> _1_valueOrError0 = UTF8.__default.Decode((DafnySequence<? extends Byte>)_0_utf8Key).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _2_e_boxed0 -> {
                DafnySequence _2_e = _2_e_boxed0;
                return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_2_e);
            });
            if (_1_valueOrError0.IsFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                return _1_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())));
            }
            DafnySequence<? extends Character> _3_base64Key = _1_valueOrError0.Extract((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            Result<DafnySequence<? extends Byte>, Error> _4_valueOrError1 = Base64_Compile.__default.Decode(_3_base64Key).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _5_e_boxed0 -> {
                DafnySequence _5_e = _5_e_boxed0;
                return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_5_e);
            });
            if (_4_valueOrError1.IsFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
                return _4_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())));
            }
            DafnySequence<? extends Byte> _6_key = _4_valueOrError1.Extract((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
            return Result.create_Success(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor(), Option.create_Some(DafnySequence._typeDescriptor(uint8._typeDescriptor()), _6_key));
        }
        return Result.create_Success(Option._typeDescriptor(DafnySequence._typeDescriptor(uint8._typeDescriptor())), Error._typeDescriptor(), Option.create_None(DafnySequence._typeDescriptor(uint8._typeDescriptor())));
    }

    public static boolean ValidEncryptionMaterialsTransition(EncryptionMaterials oldMat, EncryptionMaterials newMat) {
        return Objects.equals(newMat.dtor_algorithmSuite(), oldMat.dtor_algorithmSuite()) && newMat.dtor_encryptionContext().equals(oldMat.dtor_encryptionContext()) && newMat.dtor_requiredEncryptionContextKeys().equals(oldMat.dtor_requiredEncryptionContextKeys()) && Objects.equals(newMat.dtor_signingKey(), oldMat.dtor_signingKey()) && (oldMat.dtor_plaintextDataKey().is_None() && newMat.dtor_plaintextDataKey().is_Some() || Objects.equals(oldMat.dtor_plaintextDataKey(), newMat.dtor_plaintextDataKey())) && newMat.dtor_plaintextDataKey().is_Some() && BigInteger.valueOf(oldMat.dtor_encryptedDataKeys().length()).compareTo(BigInteger.valueOf(newMat.dtor_encryptedDataKeys().length())) <= 0 && oldMat.dtor_encryptedDataKeys().asDafnyMultiset().isSubsetOf(newMat.dtor_encryptedDataKeys().asDafnyMultiset()) && (oldMat.dtor_algorithmSuite().dtor_symmetricSignature().is_None() || newMat.dtor_symmetricSigningKeys().is_Some() && (oldMat.dtor_symmetricSigningKeys().is_Some() || oldMat.dtor_symmetricSigningKeys().is_None() && BigInteger.valueOf(oldMat.dtor_encryptedDataKeys().length()).signum() == 0) && oldMat.dtor_symmetricSigningKeys().UnwrapOr((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Byte>>>)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), (DafnySequence<? extends DafnySequence<? extends Byte>>)DafnySequence.empty((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()))).asDafnyMultiset().isSubsetOf(newMat.dtor_symmetricSigningKeys().dtor_value().asDafnyMultiset())) && __default.ValidEncryptionMaterials(oldMat) && __default.ValidEncryptionMaterials(newMat);
    }

    public static boolean ValidEncryptionMaterials(EncryptionMaterials encryptionMaterials) {
        EncryptionMaterials _pat_let_tv0 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv1 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv2 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv3 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv4 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv5 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv6 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv7 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv8 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv9 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv10 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv11 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv12 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv13 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv14 = encryptionMaterials;
        EncryptionMaterials _pat_let_tv15 = encryptionMaterials;
        return AlgorithmSuites_Compile.__default.AlgorithmSuite_q(encryptionMaterials.dtor_algorithmSuite()) && (Boolean)Helpers.Let((Object)encryptionMaterials.dtor_algorithmSuite(), boxed4 -> {
            AlgorithmSuiteInfo _pat_let2_0 = boxed4;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let2_0, boxed5 -> {
                AlgorithmSuiteInfo _0_suite = boxed5;
                return !(_0_suite.dtor_signature().is_None() != _pat_let_tv0.dtor_signingKey().is_None() || _pat_let_tv1.dtor_plaintextDataKey().is_Some() && !Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_0_suite)), BigInteger.valueOf(_pat_let_tv2.dtor_plaintextDataKey().dtor_value().length())) || _pat_let_tv3.dtor_plaintextDataKey().is_None() && BigInteger.valueOf(_pat_let_tv4.dtor_encryptedDataKeys().length()).signum() != 0 || !_0_suite.dtor_signature().is_None() != _pat_let_tv5.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || _0_suite.dtor_signature().is_ECDSA() != _pat_let_tv6.dtor_signingKey().is_Some() || !_0_suite.dtor_signature().is_None() != _pat_let_tv7.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || _0_suite.dtor_symmetricSignature().is_HMAC() && _pat_let_tv8.dtor_symmetricSigningKeys().is_Some() && !Objects.equals(BigInteger.valueOf(_pat_let_tv9.dtor_symmetricSigningKeys().dtor_value().length()), BigInteger.valueOf(_pat_let_tv10.dtor_encryptedDataKeys().length())) || _0_suite.dtor_symmetricSignature().is_HMAC() && !_pat_let_tv11.dtor_symmetricSigningKeys().is_Some() && (BigInteger.valueOf(_pat_let_tv12.dtor_encryptedDataKeys().length()).signum() != 0 || !_pat_let_tv13.dtor_symmetricSigningKeys().is_None()) || _0_suite.dtor_symmetricSignature().is_None() && !_pat_let_tv14.dtor_symmetricSigningKeys().is_None() || ((Function<EncryptionMaterials, Boolean>)_1_encryptionMaterials -> Helpers.Quantifier((Iterable)_1_encryptionMaterials.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
                    DafnySequence _forall_var_0 = _forall_var_0_boxed0;
                    DafnySequence _2_key = _forall_var_0;
                    if (ValidUTF8Bytes._Is((DafnySequence<? extends Byte>)_2_key)) {
                        return !_1_encryptionMaterials.dtor_requiredEncryptionContextKeys().contains((Object)_2_key) || _1_encryptionMaterials.dtor_encryptionContext().contains((Object)_2_key);
                    }
                    return true;
                })).apply(_pat_let_tv15) == false);
            }));
        }) != false;
    }

    public static boolean EncryptionMaterialsHasPlaintextDataKey(EncryptionMaterials encryptionMaterials) {
        return encryptionMaterials.dtor_plaintextDataKey().is_Some() && BigInteger.valueOf(encryptionMaterials.dtor_encryptedDataKeys().length()).signum() == 1 && __default.ValidEncryptionMaterials(encryptionMaterials);
    }

    public static Result<EncryptionMaterials, Error> EncryptionMaterialAddEncryptedDataKeys(EncryptionMaterials encryptionMaterials, DafnySequence<? extends EncryptedDataKey> encryptedDataKeysToAdd, Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeysToAdd) {
        Outcome<Error> _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidEncryptionMaterials(encryptionMaterials), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify invalid encryption material.")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _1_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), encryptionMaterials.dtor_plaintextDataKey().is_Some(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys without a plaintext data key is not allowed.")));
        if (_1_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _1_valueOrError1.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _2_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !symmetricSigningKeysToAdd.is_None() || encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys without a symmetric signing key when using symmetric signing is not allowed.")));
        if (_2_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _2_valueOrError2.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _3_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), !symmetricSigningKeysToAdd.is_Some() || !encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys with a symmetric signing key when not using symmetric signing is not allowed.")));
        if (_3_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _3_valueOrError3.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _4_symmetricSigningKeys = symmetricSigningKeysToAdd.is_None() ? encryptionMaterials.dtor_symmetricSigningKeys() : Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), DafnySequence.concatenate(encryptionMaterials.dtor_symmetricSigningKeys().UnwrapOr((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Byte>>>)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), (DafnySequence<? extends DafnySequence<? extends Byte>>)DafnySequence.empty((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()))), symmetricSigningKeysToAdd.dtor_value()));
        return Result.create_Success(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), EncryptionMaterials.create(encryptionMaterials.dtor_algorithmSuite(), encryptionMaterials.dtor_encryptionContext(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.concatenate(encryptionMaterials.dtor_encryptedDataKeys(), encryptedDataKeysToAdd), encryptionMaterials.dtor_requiredEncryptionContextKeys(), encryptionMaterials.dtor_plaintextDataKey(), encryptionMaterials.dtor_signingKey(), _4_symmetricSigningKeys));
    }

    public static Result<EncryptionMaterials, Error> EncryptionMaterialAddDataKey(EncryptionMaterials encryptionMaterials, DafnySequence<? extends Byte> plaintextDataKey, DafnySequence<? extends EncryptedDataKey> encryptedDataKeysToAdd, Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeysToAdd) {
        AlgorithmSuiteInfo _0_suite = encryptionMaterials.dtor_algorithmSuite();
        Outcome<Error> _1_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidEncryptionMaterials(encryptionMaterials), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify invalid encryption material.")));
        if (_1_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _2_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), encryptionMaterials.dtor_plaintextDataKey().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify plaintextDataKey.")));
        if (_2_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _3_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_0_suite)), BigInteger.valueOf(plaintextDataKey.length())), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"plaintextDataKey does not match Algorithm Suite specification.")));
        if (_3_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _3_valueOrError2.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _4_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKeysToAdd.is_None() == encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys without a symmetric signing key when using symmetric signing is not allowed.")));
        if (_4_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _4_valueOrError3.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _5_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKeysToAdd.is_Some() == !encryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidEncryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Adding encrypted data keys with a symmetric signing key when not using symmetric signing is not allowed.")));
        if (_5_valueOrError4.IsFailure(Error._typeDescriptor())) {
            return _5_valueOrError4.PropagateFailure(Error._typeDescriptor(), EncryptionMaterials._typeDescriptor());
        }
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _6_symmetricSigningKeys = symmetricSigningKeysToAdd.is_None() ? encryptionMaterials.dtor_symmetricSigningKeys() : Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), DafnySequence.concatenate(encryptionMaterials.dtor_symmetricSigningKeys().UnwrapOr((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Byte>>>)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor())), (DafnySequence<? extends DafnySequence<? extends Byte>>)DafnySequence.empty((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()))), symmetricSigningKeysToAdd.dtor_value()));
        return Result.create_Success(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), EncryptionMaterials.create(encryptionMaterials.dtor_algorithmSuite(), encryptionMaterials.dtor_encryptionContext(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.concatenate(encryptionMaterials.dtor_encryptedDataKeys(), encryptedDataKeysToAdd), encryptionMaterials.dtor_requiredEncryptionContextKeys(), Option.create_Some(DafnySequence._typeDescriptor(uint8._typeDescriptor()), plaintextDataKey), encryptionMaterials.dtor_signingKey(), _6_symmetricSigningKeys));
    }

    public static boolean DecryptionMaterialsTransitionIsValid(DecryptionMaterials oldMat, DecryptionMaterials newMat) {
        return Objects.equals(newMat.dtor_algorithmSuite(), oldMat.dtor_algorithmSuite()) && newMat.dtor_encryptionContext().equals(oldMat.dtor_encryptionContext()) && newMat.dtor_requiredEncryptionContextKeys().equals(oldMat.dtor_requiredEncryptionContextKeys()) && Objects.equals(newMat.dtor_verificationKey(), oldMat.dtor_verificationKey()) && oldMat.dtor_plaintextDataKey().is_None() && newMat.dtor_plaintextDataKey().is_Some() && oldMat.dtor_symmetricSigningKey().is_None() && __default.ValidDecryptionMaterials(oldMat) && __default.ValidDecryptionMaterials(newMat);
    }

    public static boolean ValidDecryptionMaterials(DecryptionMaterials decryptionMaterials) {
        DecryptionMaterials _pat_let_tv0 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv1 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv2 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv3 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv4 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv5 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv6 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv7 = decryptionMaterials;
        DecryptionMaterials _pat_let_tv8 = decryptionMaterials;
        return AlgorithmSuites_Compile.__default.AlgorithmSuite_q(decryptionMaterials.dtor_algorithmSuite()) && (Boolean)Helpers.Let((Object)decryptionMaterials.dtor_algorithmSuite(), boxed6 -> {
            AlgorithmSuiteInfo _pat_let3_0 = boxed6;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let3_0, boxed7 -> {
                AlgorithmSuiteInfo _0_suite = boxed7;
                return !(_pat_let_tv0.dtor_plaintextDataKey().is_Some() && !Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_0_suite)), BigInteger.valueOf(_pat_let_tv1.dtor_plaintextDataKey().dtor_value().length())) || !_0_suite.dtor_signature().is_None() != _pat_let_tv2.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || _0_suite.dtor_signature().is_ECDSA() != _pat_let_tv3.dtor_verificationKey().is_Some() || !_0_suite.dtor_signature().is_None() != _pat_let_tv4.dtor_encryptionContext().contains(__default.EC__PUBLIC__KEY__FIELD()) || !_0_suite.dtor_symmetricSignature().is_None() && _pat_let_tv5.dtor_plaintextDataKey().is_Some() != _pat_let_tv6.dtor_symmetricSigningKey().is_Some() || _0_suite.dtor_symmetricSignature().is_None() && !_pat_let_tv7.dtor_symmetricSigningKey().is_None() || ((Function<DecryptionMaterials, Boolean>)_1_decryptionMaterials -> Helpers.Quantifier((Iterable)_1_decryptionMaterials.dtor_requiredEncryptionContextKeys().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
                    DafnySequence _forall_var_0 = _forall_var_0_boxed0;
                    DafnySequence _2_k = _forall_var_0;
                    if (ValidUTF8Bytes._Is((DafnySequence<? extends Byte>)_2_k)) {
                        return !_1_decryptionMaterials.dtor_requiredEncryptionContextKeys().contains((Object)_2_k) || _1_decryptionMaterials.dtor_encryptionContext().contains((Object)_2_k);
                    }
                    return true;
                })).apply(_pat_let_tv8) == false);
            }));
        }) != false;
    }

    public static Result<DecryptionMaterials, Error> DecryptionMaterialsAddDataKey(DecryptionMaterials decryptionMaterials, DafnySequence<? extends Byte> plaintextDataKey, Option<DafnySequence<? extends Byte>> symmetricSigningKey) {
        AlgorithmSuiteInfo _0_suite = decryptionMaterials.dtor_algorithmSuite();
        Outcome<Error> _1_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.ValidDecryptionMaterials(decryptionMaterials), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify invalid decryption material.")));
        if (_1_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _2_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), decryptionMaterials.dtor_plaintextDataKey().is_None(), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"Attempt to modify plaintextDataKey.")));
        if (_2_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _3_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_0_suite)), BigInteger.valueOf(plaintextDataKey.length())), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"plaintextDataKey does not match Algorithm Suite specification.")));
        if (_3_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _3_valueOrError2.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _4_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKey.is_Some() == !decryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"symmetric signature key must be added with plaintextDataKey if using an algorithm suite with symmetric signing.")));
        if (_4_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _4_valueOrError3.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        Outcome<Error> _5_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), symmetricSigningKey.is_None() == decryptionMaterials.dtor_algorithmSuite().dtor_symmetricSignature().is_None(), Error.create_InvalidDecryptionMaterialsTransition((DafnySequence<? extends Character>)DafnySequence.asString((String)"symmetric signature key cannot be added with plaintextDataKey if using an algorithm suite without symmetric signing.")));
        if (_5_valueOrError4.IsFailure(Error._typeDescriptor())) {
            return _5_valueOrError4.PropagateFailure(Error._typeDescriptor(), DecryptionMaterials._typeDescriptor());
        }
        return Result.create_Success(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), DecryptionMaterials.create(decryptionMaterials.dtor_algorithmSuite(), decryptionMaterials.dtor_encryptionContext(), decryptionMaterials.dtor_requiredEncryptionContextKeys(), Option.create_Some(DafnySequence._typeDescriptor(uint8._typeDescriptor()), plaintextDataKey), decryptionMaterials.dtor_verificationKey(), symmetricSigningKey));
    }

    public static boolean DecryptionMaterialsWithoutPlaintextDataKey(DecryptionMaterials decryptionMaterials) {
        return decryptionMaterials.dtor_plaintextDataKey().is_None() && __default.ValidDecryptionMaterials(decryptionMaterials);
    }

    public static boolean DecryptionMaterialsWithPlaintextDataKey(DecryptionMaterials decryptionMaterials) {
        return decryptionMaterials.dtor_plaintextDataKey().is_Some() && __default.ValidDecryptionMaterials(decryptionMaterials);
    }

    public static DafnySequence<? extends Byte> EC__PUBLIC__KEY__FIELD() {
        DafnySequence _0_s = DafnySequence.of((byte[])new byte[]{97, 119, 115, 45, 99, 114, 121, 112, 116, 111, 45, 112, 117, 98, 108, 105, 99, 45, 107, 101, 121});
        return _0_s;
    }

    public static DafnySet<? extends DafnySequence<? extends Byte>> RESERVED__KEY__VALUES() {
        return DafnySet.of((Object[])new DafnySequence[]{__default.EC__PUBLIC__KEY__FIELD()});
    }

    public String toString() {
        return "Materials._default";
    }
}

