/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.sinks;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.sinks.Endpoint;
import software.amazon.cloudwatchlogs.emf.sinks.SocketClient;

public class TCPClient
implements SocketClient {
    private static final Logger log = LoggerFactory.getLogger(TCPClient.class);
    private final Endpoint endpoint;
    private Socket socket;
    private boolean shouldConnect = true;

    public TCPClient(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    private void connect() {
        try {
            this.socket = this.createSocket();
            this.socket.connect(new InetSocketAddress(this.endpoint.getHost(), this.endpoint.getPort()));
            this.shouldConnect = false;
        }
        catch (Exception e) {
            this.shouldConnect = true;
            throw new RuntimeException("Failed to connect to the socket.", e);
        }
    }

    protected Socket createSocket() {
        return new Socket();
    }

    @Override
    public synchronized void sendMessage(String message) {
        OutputStream os;
        if (this.socket == null || this.socket.isClosed() || this.shouldConnect) {
            this.connect();
        }
        try {
            os = this.socket.getOutputStream();
        }
        catch (IOException e) {
            this.shouldConnect = true;
            throw new RuntimeException("Failed to write message to the socket. Failed to open output stream.", e);
        }
        try {
            os.write(message.getBytes());
        }
        catch (Exception e) {
            this.shouldConnect = true;
            throw new RuntimeException("Failed to write message to the socket.", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

