/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ClientPropertiesListCopier;
import software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClientPropertiesResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, DescribeClientPropertiesResponse> {
    private static final SdkField<List<ClientPropertiesResult>> CLIENT_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientPropertiesList").getter(DescribeClientPropertiesResponse.getter(DescribeClientPropertiesResponse::clientPropertiesList)).setter(DescribeClientPropertiesResponse.setter(Builder::clientPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClientPropertiesResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_PROPERTIES_LIST_FIELD));
    private final List<ClientPropertiesResult> clientPropertiesList;

    private DescribeClientPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.clientPropertiesList = builder.clientPropertiesList;
    }

    public final boolean hasClientPropertiesList() {
        return this.clientPropertiesList != null && !(this.clientPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<ClientPropertiesResult> clientPropertiesList() {
        return this.clientPropertiesList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientPropertiesList() ? this.clientPropertiesList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientPropertiesResponse)) {
            return false;
        }
        DescribeClientPropertiesResponse other = (DescribeClientPropertiesResponse)((Object)obj);
        return this.hasClientPropertiesList() == other.hasClientPropertiesList() && Objects.equals(this.clientPropertiesList(), other.clientPropertiesList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClientPropertiesResponse").add("ClientPropertiesList", this.hasClientPropertiesList() ? this.clientPropertiesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.clientPropertiesList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientPropertiesResponse, T> g) {
        return obj -> g.apply((DescribeClientPropertiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private List<ClientPropertiesResult> clientPropertiesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientPropertiesResponse model) {
            super(model);
            this.clientPropertiesList(model.clientPropertiesList);
        }

        public final List<ClientPropertiesResult.Builder> getClientPropertiesList() {
            List<ClientPropertiesResult.Builder> result = ClientPropertiesListCopier.copyToBuilder(this.clientPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientPropertiesList(Collection<ClientPropertiesResult.BuilderImpl> clientPropertiesList) {
            this.clientPropertiesList = ClientPropertiesListCopier.copyFromBuilder(clientPropertiesList);
        }

        @Override
        public final Builder clientPropertiesList(Collection<ClientPropertiesResult> clientPropertiesList) {
            this.clientPropertiesList = ClientPropertiesListCopier.copy(clientPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientPropertiesList(ClientPropertiesResult ... clientPropertiesList) {
            this.clientPropertiesList(Arrays.asList(clientPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientPropertiesList(Consumer<ClientPropertiesResult.Builder> ... clientPropertiesList) {
            this.clientPropertiesList(Stream.of(clientPropertiesList).map(c -> (ClientPropertiesResult)((ClientPropertiesResult.Builder)ClientPropertiesResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClientPropertiesResponse build() {
            return new DescribeClientPropertiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClientPropertiesResponse> {
        public Builder clientPropertiesList(Collection<ClientPropertiesResult> var1);

        public Builder clientPropertiesList(ClientPropertiesResult ... var1);

        public Builder clientPropertiesList(Consumer<ClientPropertiesResult.Builder> ... var1);
    }
}

