/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the user volume for a WorkSpace bundle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserStorage implements SdkPojo, Serializable, ToCopyableBuilder<UserStorage.Builder, UserStorage> {
    private static final SdkField<String> CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Capacity").getter(getter(UserStorage::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String capacity;

    private UserStorage(BuilderImpl builder) {
        this.capacity = builder.capacity;
    }

    /**
     * <p>
     * The size of the user volume.
     * </p>
     * 
     * @return The size of the user volume.
     */
    public final String capacity() {
        return capacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserStorage)) {
            return false;
        }
        UserStorage other = (UserStorage) obj;
        return Objects.equals(capacity(), other.capacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserStorage").add("Capacity", capacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserStorage, T> g) {
        return obj -> g.apply((UserStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserStorage> {
        /**
         * <p>
         * The size of the user volume.
         * </p>
         * 
         * @param capacity
         *        The size of the user volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(String capacity);
    }

    static final class BuilderImpl implements Builder {
        private String capacity;

        private BuilderImpl() {
        }

        private BuilderImpl(UserStorage model) {
            capacity(model.capacity);
        }

        public final String getCapacity() {
            return capacity;
        }

        public final void setCapacity(String capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(String capacity) {
            this.capacity = capacity;
            return this;
        }

        @Override
        public UserStorage build() {
            return new UserStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
