/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of the certificate-based authentication you want to use with your WorkSpaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateBasedAuthProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CertificateBasedAuthProperties.Builder, CertificateBasedAuthProperties> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CertificateBasedAuthProperties::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityArn").getter(getter(CertificateBasedAuthProperties::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CERTIFICATE_AUTHORITY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String certificateAuthorityArn;

    private CertificateBasedAuthProperties(BuilderImpl builder) {
        this.status = builder.status;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
    }

    /**
     * <p>
     * The status of the certificate-based authentication properties.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateBasedAuthStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the certificate-based authentication properties.
     * @see CertificateBasedAuthStatusEnum
     */
    public final CertificateBasedAuthStatusEnum status() {
        return CertificateBasedAuthStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * The status of the certificate-based authentication properties.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateBasedAuthStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the certificate-based authentication properties.
     * @see CertificateBasedAuthStatusEnum
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager Private CA resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager Private CA resource.
     */
    public final String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateBasedAuthProperties)) {
            return false;
        }
        CertificateBasedAuthProperties other = (CertificateBasedAuthProperties) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CertificateBasedAuthProperties").add("Status", statusAsString())
                .add("CertificateAuthorityArn", certificateAuthorityArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateBasedAuthProperties, T> g) {
        return obj -> g.apply((CertificateBasedAuthProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateBasedAuthProperties> {
        /**
         * <p>
         * The status of the certificate-based authentication properties.
         * </p>
         * 
         * @param status
         *        The status of the certificate-based authentication properties.
         * @see CertificateBasedAuthStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateBasedAuthStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the certificate-based authentication properties.
         * </p>
         * 
         * @param status
         *        The status of the certificate-based authentication properties.
         * @see CertificateBasedAuthStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateBasedAuthStatusEnum
         */
        Builder status(CertificateBasedAuthStatusEnum status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager Private CA resource.
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager Private CA resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String certificateAuthorityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateBasedAuthProperties model) {
            status(model.status);
            certificateAuthorityArn(model.certificateAuthorityArn);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateBasedAuthStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        @Override
        public CertificateBasedAuthProperties build() {
            return new CertificateBasedAuthProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
