/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum WorkspaceState {
    PENDING("PENDING"),
    AVAILABLE("AVAILABLE"),
    IMPAIRED("IMPAIRED"),
    UNHEALTHY("UNHEALTHY"),
    REBOOTING("REBOOTING"),
    STARTING("STARTING"),
    REBUILDING("REBUILDING"),
    RESTORING("RESTORING"),
    MAINTENANCE("MAINTENANCE"),
    ADMIN_MAINTENANCE("ADMIN_MAINTENANCE"),
    TERMINATING("TERMINATING"),
    TERMINATED("TERMINATED"),
    SUSPENDED("SUSPENDED"),
    UPDATING("UPDATING"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private WorkspaceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkspaceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(WorkspaceState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkspaceState> knownValues() {
        return Stream.of(WorkspaceState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

