/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.DefaultWorkspaceCreationProperties;
import software.amazon.awssdk.services.workspaces.model.DnsIpAddressesCopier;
import software.amazon.awssdk.services.workspaces.model.IpGroupIdListCopier;
import software.amazon.awssdk.services.workspaces.model.SelfservicePermissions;
import software.amazon.awssdk.services.workspaces.model.SubnetIdsCopier;
import software.amazon.awssdk.services.workspaces.model.Tenancy;
import software.amazon.awssdk.services.workspaces.model.WorkspaceAccessProperties;
import software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryState;
import software.amazon.awssdk.services.workspaces.model.WorkspaceDirectoryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceDirectory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceDirectory> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(WorkspaceDirectory.getter(WorkspaceDirectory::directoryId)).setter(WorkspaceDirectory.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(WorkspaceDirectory.getter(WorkspaceDirectory::alias)).setter(WorkspaceDirectory.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<String> DIRECTORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryName").getter(WorkspaceDirectory.getter(WorkspaceDirectory::directoryName)).setter(WorkspaceDirectory.setter(Builder::directoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryName").build()}).build();
    private static final SdkField<String> REGISTRATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationCode").getter(WorkspaceDirectory.getter(WorkspaceDirectory::registrationCode)).setter(WorkspaceDirectory.setter(Builder::registrationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationCode").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(WorkspaceDirectory.getter(WorkspaceDirectory::subnetIds)).setter(WorkspaceDirectory.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DNS_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIpAddresses").getter(WorkspaceDirectory.getter(WorkspaceDirectory::dnsIpAddresses)).setter(WorkspaceDirectory.setter(Builder::dnsIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOMER_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerUserName").getter(WorkspaceDirectory.getter(WorkspaceDirectory::customerUserName)).setter(WorkspaceDirectory.setter(Builder::customerUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUserName").build()}).build();
    private static final SdkField<String> IAM_ROLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleId").getter(WorkspaceDirectory.getter(WorkspaceDirectory::iamRoleId)).setter(WorkspaceDirectory.setter(Builder::iamRoleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleId").build()}).build();
    private static final SdkField<String> DIRECTORY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryType").getter(WorkspaceDirectory.getter(WorkspaceDirectory::directoryTypeAsString)).setter(WorkspaceDirectory.setter(Builder::directoryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryType").build()}).build();
    private static final SdkField<String> WORKSPACE_SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceSecurityGroupId").getter(WorkspaceDirectory.getter(WorkspaceDirectory::workspaceSecurityGroupId)).setter(WorkspaceDirectory.setter(Builder::workspaceSecurityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceSecurityGroupId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(WorkspaceDirectory.getter(WorkspaceDirectory::stateAsString)).setter(WorkspaceDirectory.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<DefaultWorkspaceCreationProperties> WORKSPACE_CREATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkspaceCreationProperties").getter(WorkspaceDirectory.getter(WorkspaceDirectory::workspaceCreationProperties)).setter(WorkspaceDirectory.setter(Builder::workspaceCreationProperties)).constructor(DefaultWorkspaceCreationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceCreationProperties").build()}).build();
    private static final SdkField<List<String>> IP_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipGroupIds").getter(WorkspaceDirectory.getter(WorkspaceDirectory::ipGroupIds)).setter(WorkspaceDirectory.setter(Builder::ipGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WorkspaceAccessProperties> WORKSPACE_ACCESS_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkspaceAccessProperties").getter(WorkspaceDirectory.getter(WorkspaceDirectory::workspaceAccessProperties)).setter(WorkspaceDirectory.setter(Builder::workspaceAccessProperties)).constructor(WorkspaceAccessProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceAccessProperties").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(WorkspaceDirectory.getter(WorkspaceDirectory::tenancyAsString)).setter(WorkspaceDirectory.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()}).build();
    private static final SdkField<SelfservicePermissions> SELFSERVICE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfservicePermissions").getter(WorkspaceDirectory.getter(WorkspaceDirectory::selfservicePermissions)).setter(WorkspaceDirectory.setter(Builder::selfservicePermissions)).constructor(SelfservicePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfservicePermissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, ALIAS_FIELD, DIRECTORY_NAME_FIELD, REGISTRATION_CODE_FIELD, SUBNET_IDS_FIELD, DNS_IP_ADDRESSES_FIELD, CUSTOMER_USER_NAME_FIELD, IAM_ROLE_ID_FIELD, DIRECTORY_TYPE_FIELD, WORKSPACE_SECURITY_GROUP_ID_FIELD, STATE_FIELD, WORKSPACE_CREATION_PROPERTIES_FIELD, IP_GROUP_IDS_FIELD, WORKSPACE_ACCESS_PROPERTIES_FIELD, TENANCY_FIELD, SELFSERVICE_PERMISSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String alias;
    private final String directoryName;
    private final String registrationCode;
    private final List<String> subnetIds;
    private final List<String> dnsIpAddresses;
    private final String customerUserName;
    private final String iamRoleId;
    private final String directoryType;
    private final String workspaceSecurityGroupId;
    private final String state;
    private final DefaultWorkspaceCreationProperties workspaceCreationProperties;
    private final List<String> ipGroupIds;
    private final WorkspaceAccessProperties workspaceAccessProperties;
    private final String tenancy;
    private final SelfservicePermissions selfservicePermissions;

    private WorkspaceDirectory(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.alias = builder.alias;
        this.directoryName = builder.directoryName;
        this.registrationCode = builder.registrationCode;
        this.subnetIds = builder.subnetIds;
        this.dnsIpAddresses = builder.dnsIpAddresses;
        this.customerUserName = builder.customerUserName;
        this.iamRoleId = builder.iamRoleId;
        this.directoryType = builder.directoryType;
        this.workspaceSecurityGroupId = builder.workspaceSecurityGroupId;
        this.state = builder.state;
        this.workspaceCreationProperties = builder.workspaceCreationProperties;
        this.ipGroupIds = builder.ipGroupIds;
        this.workspaceAccessProperties = builder.workspaceAccessProperties;
        this.tenancy = builder.tenancy;
        this.selfservicePermissions = builder.selfservicePermissions;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String alias() {
        return this.alias;
    }

    public final String directoryName() {
        return this.directoryName;
    }

    public final String registrationCode() {
        return this.registrationCode;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasDnsIpAddresses() {
        return this.dnsIpAddresses != null && !(this.dnsIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIpAddresses() {
        return this.dnsIpAddresses;
    }

    public final String customerUserName() {
        return this.customerUserName;
    }

    public final String iamRoleId() {
        return this.iamRoleId;
    }

    public final WorkspaceDirectoryType directoryType() {
        return WorkspaceDirectoryType.fromValue(this.directoryType);
    }

    public final String directoryTypeAsString() {
        return this.directoryType;
    }

    public final String workspaceSecurityGroupId() {
        return this.workspaceSecurityGroupId;
    }

    public final WorkspaceDirectoryState state() {
        return WorkspaceDirectoryState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final DefaultWorkspaceCreationProperties workspaceCreationProperties() {
        return this.workspaceCreationProperties;
    }

    public final boolean hasIpGroupIds() {
        return this.ipGroupIds != null && !(this.ipGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> ipGroupIds() {
        return this.ipGroupIds;
    }

    public final WorkspaceAccessProperties workspaceAccessProperties() {
        return this.workspaceAccessProperties;
    }

    public final Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final SelfservicePermissions selfservicePermissions() {
        return this.selfservicePermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIpAddresses() ? this.dnsIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customerUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceCreationProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpGroupIds() ? this.ipGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceAccessProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfservicePermissions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceDirectory)) {
            return false;
        }
        WorkspaceDirectory other = (WorkspaceDirectory)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.directoryName(), other.directoryName()) && Objects.equals(this.registrationCode(), other.registrationCode()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasDnsIpAddresses() == other.hasDnsIpAddresses() && Objects.equals(this.dnsIpAddresses(), other.dnsIpAddresses()) && Objects.equals(this.customerUserName(), other.customerUserName()) && Objects.equals(this.iamRoleId(), other.iamRoleId()) && Objects.equals(this.directoryTypeAsString(), other.directoryTypeAsString()) && Objects.equals(this.workspaceSecurityGroupId(), other.workspaceSecurityGroupId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.workspaceCreationProperties(), other.workspaceCreationProperties()) && this.hasIpGroupIds() == other.hasIpGroupIds() && Objects.equals(this.ipGroupIds(), other.ipGroupIds()) && Objects.equals(this.workspaceAccessProperties(), other.workspaceAccessProperties()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.selfservicePermissions(), other.selfservicePermissions());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceDirectory").add("DirectoryId", (Object)this.directoryId()).add("Alias", (Object)this.alias()).add("DirectoryName", (Object)this.directoryName()).add("RegistrationCode", (Object)this.registrationCode()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("DnsIpAddresses", this.hasDnsIpAddresses() ? this.dnsIpAddresses() : null).add("CustomerUserName", (Object)this.customerUserName()).add("IamRoleId", (Object)this.iamRoleId()).add("DirectoryType", (Object)this.directoryTypeAsString()).add("WorkspaceSecurityGroupId", (Object)this.workspaceSecurityGroupId()).add("State", (Object)this.stateAsString()).add("WorkspaceCreationProperties", (Object)this.workspaceCreationProperties()).add("IpGroupIds", this.hasIpGroupIds() ? this.ipGroupIds() : null).add("WorkspaceAccessProperties", (Object)this.workspaceAccessProperties()).add("Tenancy", (Object)this.tenancyAsString()).add("SelfservicePermissions", (Object)this.selfservicePermissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "DirectoryName": {
                return Optional.ofNullable(clazz.cast(this.directoryName()));
            }
            case "RegistrationCode": {
                return Optional.ofNullable(clazz.cast(this.registrationCode()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "DnsIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.dnsIpAddresses()));
            }
            case "CustomerUserName": {
                return Optional.ofNullable(clazz.cast(this.customerUserName()));
            }
            case "IamRoleId": {
                return Optional.ofNullable(clazz.cast(this.iamRoleId()));
            }
            case "DirectoryType": {
                return Optional.ofNullable(clazz.cast(this.directoryTypeAsString()));
            }
            case "WorkspaceSecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.workspaceSecurityGroupId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "WorkspaceCreationProperties": {
                return Optional.ofNullable(clazz.cast(this.workspaceCreationProperties()));
            }
            case "ipGroupIds": {
                return Optional.ofNullable(clazz.cast(this.ipGroupIds()));
            }
            case "WorkspaceAccessProperties": {
                return Optional.ofNullable(clazz.cast(this.workspaceAccessProperties()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "SelfservicePermissions": {
                return Optional.ofNullable(clazz.cast(this.selfservicePermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceDirectory, T> g) {
        return obj -> g.apply((WorkspaceDirectory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String alias;
        private String directoryName;
        private String registrationCode;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> dnsIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private String customerUserName;
        private String iamRoleId;
        private String directoryType;
        private String workspaceSecurityGroupId;
        private String state;
        private DefaultWorkspaceCreationProperties workspaceCreationProperties;
        private List<String> ipGroupIds = DefaultSdkAutoConstructList.getInstance();
        private WorkspaceAccessProperties workspaceAccessProperties;
        private String tenancy;
        private SelfservicePermissions selfservicePermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceDirectory model) {
            this.directoryId(model.directoryId);
            this.alias(model.alias);
            this.directoryName(model.directoryName);
            this.registrationCode(model.registrationCode);
            this.subnetIds(model.subnetIds);
            this.dnsIpAddresses(model.dnsIpAddresses);
            this.customerUserName(model.customerUserName);
            this.iamRoleId(model.iamRoleId);
            this.directoryType(model.directoryType);
            this.workspaceSecurityGroupId(model.workspaceSecurityGroupId);
            this.state(model.state);
            this.workspaceCreationProperties(model.workspaceCreationProperties);
            this.ipGroupIds(model.ipGroupIds);
            this.workspaceAccessProperties(model.workspaceAccessProperties);
            this.tenancy(model.tenancy);
            this.selfservicePermissions(model.selfservicePermissions);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getAlias() {
            return this.alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final String getDirectoryName() {
            return this.directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        public final String getRegistrationCode() {
            return this.registrationCode;
        }

        @Override
        public final Builder registrationCode(String registrationCode) {
            this.registrationCode = registrationCode;
            return this;
        }

        public final void setRegistrationCode(String registrationCode) {
            this.registrationCode = registrationCode;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final Collection<String> getDnsIpAddresses() {
            if (this.dnsIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIpAddresses;
        }

        @Override
        public final Builder dnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = DnsIpAddressesCopier.copy(dnsIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpAddresses(String ... dnsIpAddresses) {
            this.dnsIpAddresses(Arrays.asList(dnsIpAddresses));
            return this;
        }

        public final void setDnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = DnsIpAddressesCopier.copy(dnsIpAddresses);
        }

        public final String getCustomerUserName() {
            return this.customerUserName;
        }

        @Override
        public final Builder customerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
            return this;
        }

        public final void setCustomerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
        }

        public final String getIamRoleId() {
            return this.iamRoleId;
        }

        @Override
        public final Builder iamRoleId(String iamRoleId) {
            this.iamRoleId = iamRoleId;
            return this;
        }

        public final void setIamRoleId(String iamRoleId) {
            this.iamRoleId = iamRoleId;
        }

        public final String getDirectoryType() {
            return this.directoryType;
        }

        @Override
        public final Builder directoryType(String directoryType) {
            this.directoryType = directoryType;
            return this;
        }

        @Override
        public final Builder directoryType(WorkspaceDirectoryType directoryType) {
            this.directoryType(directoryType == null ? null : directoryType.toString());
            return this;
        }

        public final void setDirectoryType(String directoryType) {
            this.directoryType = directoryType;
        }

        public final String getWorkspaceSecurityGroupId() {
            return this.workspaceSecurityGroupId;
        }

        @Override
        public final Builder workspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
            return this;
        }

        public final void setWorkspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceDirectoryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final DefaultWorkspaceCreationProperties.Builder getWorkspaceCreationProperties() {
            return this.workspaceCreationProperties != null ? this.workspaceCreationProperties.toBuilder() : null;
        }

        @Override
        public final Builder workspaceCreationProperties(DefaultWorkspaceCreationProperties workspaceCreationProperties) {
            this.workspaceCreationProperties = workspaceCreationProperties;
            return this;
        }

        public final void setWorkspaceCreationProperties(DefaultWorkspaceCreationProperties.BuilderImpl workspaceCreationProperties) {
            this.workspaceCreationProperties = workspaceCreationProperties != null ? workspaceCreationProperties.build() : null;
        }

        public final Collection<String> getIpGroupIds() {
            if (this.ipGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipGroupIds;
        }

        @Override
        public final Builder ipGroupIds(Collection<String> ipGroupIds) {
            this.ipGroupIds = IpGroupIdListCopier.copy(ipGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipGroupIds(String ... ipGroupIds) {
            this.ipGroupIds(Arrays.asList(ipGroupIds));
            return this;
        }

        public final void setIpGroupIds(Collection<String> ipGroupIds) {
            this.ipGroupIds = IpGroupIdListCopier.copy(ipGroupIds);
        }

        public final WorkspaceAccessProperties.Builder getWorkspaceAccessProperties() {
            return this.workspaceAccessProperties != null ? this.workspaceAccessProperties.toBuilder() : null;
        }

        @Override
        public final Builder workspaceAccessProperties(WorkspaceAccessProperties workspaceAccessProperties) {
            this.workspaceAccessProperties = workspaceAccessProperties;
            return this;
        }

        public final void setWorkspaceAccessProperties(WorkspaceAccessProperties.BuilderImpl workspaceAccessProperties) {
            this.workspaceAccessProperties = workspaceAccessProperties != null ? workspaceAccessProperties.build() : null;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final SelfservicePermissions.Builder getSelfservicePermissions() {
            return this.selfservicePermissions != null ? this.selfservicePermissions.toBuilder() : null;
        }

        @Override
        public final Builder selfservicePermissions(SelfservicePermissions selfservicePermissions) {
            this.selfservicePermissions = selfservicePermissions;
            return this;
        }

        public final void setSelfservicePermissions(SelfservicePermissions.BuilderImpl selfservicePermissions) {
            this.selfservicePermissions = selfservicePermissions != null ? selfservicePermissions.build() : null;
        }

        public WorkspaceDirectory build() {
            return new WorkspaceDirectory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceDirectory> {
        public Builder directoryId(String var1);

        public Builder alias(String var1);

        public Builder directoryName(String var1);

        public Builder registrationCode(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder dnsIpAddresses(Collection<String> var1);

        public Builder dnsIpAddresses(String ... var1);

        public Builder customerUserName(String var1);

        public Builder iamRoleId(String var1);

        public Builder directoryType(String var1);

        public Builder directoryType(WorkspaceDirectoryType var1);

        public Builder workspaceSecurityGroupId(String var1);

        public Builder state(String var1);

        public Builder state(WorkspaceDirectoryState var1);

        public Builder workspaceCreationProperties(DefaultWorkspaceCreationProperties var1);

        default public Builder workspaceCreationProperties(Consumer<DefaultWorkspaceCreationProperties.Builder> workspaceCreationProperties) {
            return this.workspaceCreationProperties((DefaultWorkspaceCreationProperties)((DefaultWorkspaceCreationProperties.Builder)DefaultWorkspaceCreationProperties.builder().applyMutation(workspaceCreationProperties)).build());
        }

        public Builder ipGroupIds(Collection<String> var1);

        public Builder ipGroupIds(String ... var1);

        public Builder workspaceAccessProperties(WorkspaceAccessProperties var1);

        default public Builder workspaceAccessProperties(Consumer<WorkspaceAccessProperties.Builder> workspaceAccessProperties) {
            return this.workspaceAccessProperties((WorkspaceAccessProperties)((WorkspaceAccessProperties.Builder)WorkspaceAccessProperties.builder().applyMutation(workspaceAccessProperties)).build());
        }

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);

        public Builder selfservicePermissions(SelfservicePermissions var1);

        default public Builder selfservicePermissions(Consumer<SelfservicePermissions.Builder> selfservicePermissions) {
            return this.selfservicePermissions((SelfservicePermissions)((SelfservicePermissions.Builder)SelfservicePermissions.builder().applyMutation(selfservicePermissions)).build());
        }
    }
}

