/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspaceBundlesRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeWorkspaceBundlesRequest.Builder, DescribeWorkspaceBundlesRequest> {
    private static final SdkField<List<String>> BUNDLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BundleIds")
            .getter(getter(DescribeWorkspaceBundlesRequest::bundleIds))
            .setter(setter(Builder::bundleIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(DescribeWorkspaceBundlesRequest::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspaceBundlesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_IDS_FIELD, OWNER_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> bundleIds;

    private final String owner;

    private final String nextToken;

    private DescribeWorkspaceBundlesRequest(BuilderImpl builder) {
        super(builder);
        this.bundleIds = builder.bundleIds;
        this.owner = builder.owner;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BundleIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBundleIds() {
        return bundleIds != null && !(bundleIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the bundles. You cannot combine this parameter with any other filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBundleIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of the bundles. You cannot combine this parameter with any other filter.
     */
    public final List<String> bundleIds() {
        return bundleIds;
    }

    /**
     * <p>
     * The owner of the bundles. You cannot combine this parameter with any other filter.
     * </p>
     * <p>
     * Specify <code>AMAZON</code> to describe the bundles provided by AWS or null to describe the bundles that belong
     * to your account.
     * </p>
     * 
     * @return The owner of the bundles. You cannot combine this parameter with any other filter.</p>
     *         <p>
     *         Specify <code>AMAZON</code> to describe the bundles provided by AWS or null to describe the bundles that
     *         belong to your account.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The token for the next set of results. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of results. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBundleIds() ? bundleIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceBundlesRequest)) {
            return false;
        }
        DescribeWorkspaceBundlesRequest other = (DescribeWorkspaceBundlesRequest) obj;
        return hasBundleIds() == other.hasBundleIds() && Objects.equals(bundleIds(), other.bundleIds())
                && Objects.equals(owner(), other.owner()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspaceBundlesRequest").add("BundleIds", hasBundleIds() ? bundleIds() : null)
                .add("Owner", owner()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleIds":
            return Optional.ofNullable(clazz.cast(bundleIds()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceBundlesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspaceBundlesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkspaceBundlesRequest> {
        /**
         * <p>
         * The identifiers of the bundles. You cannot combine this parameter with any other filter.
         * </p>
         * 
         * @param bundleIds
         *        The identifiers of the bundles. You cannot combine this parameter with any other filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleIds(Collection<String> bundleIds);

        /**
         * <p>
         * The identifiers of the bundles. You cannot combine this parameter with any other filter.
         * </p>
         * 
         * @param bundleIds
         *        The identifiers of the bundles. You cannot combine this parameter with any other filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleIds(String... bundleIds);

        /**
         * <p>
         * The owner of the bundles. You cannot combine this parameter with any other filter.
         * </p>
         * <p>
         * Specify <code>AMAZON</code> to describe the bundles provided by AWS or null to describe the bundles that
         * belong to your account.
         * </p>
         * 
         * @param owner
         *        The owner of the bundles. You cannot combine this parameter with any other filter.</p>
         *        <p>
         *        Specify <code>AMAZON</code> to describe the bundles provided by AWS or null to describe the bundles
         *        that belong to your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The token for the next set of results. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> bundleIds = DefaultSdkAutoConstructList.getInstance();

        private String owner;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceBundlesRequest model) {
            super(model);
            bundleIds(model.bundleIds);
            owner(model.owner);
            nextToken(model.nextToken);
        }

        public final Collection<String> getBundleIds() {
            if (bundleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return bundleIds;
        }

        @Override
        public final Builder bundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdListCopier.copy(bundleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleIds(String... bundleIds) {
            bundleIds(Arrays.asList(bundleIds));
            return this;
        }

        public final void setBundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdListCopier.copy(bundleIds);
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspaceBundlesRequest build() {
            return new DescribeWorkspaceBundlesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
