/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a connection alias association that is used for cross-Region redirection. For more information, see <a
 * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
 * Redirection for Amazon WorkSpaces</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionAliasAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionAliasAssociation.Builder, ConnectionAliasAssociation> {
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationStatus").getter(getter(ConnectionAliasAssociation::associationStatusAsString))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()).build();

    private static final SdkField<String> ASSOCIATED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedAccountId").getter(getter(ConnectionAliasAssociation::associatedAccountId))
            .setter(setter(Builder::associatedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedAccountId").build())
            .build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ConnectionAliasAssociation::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> CONNECTION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionIdentifier").getter(getter(ConnectionAliasAssociation::connectionIdentifier))
            .setter(setter(Builder::connectionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_STATUS_FIELD,
            ASSOCIATED_ACCOUNT_ID_FIELD, RESOURCE_ID_FIELD, CONNECTION_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associationStatus;

    private final String associatedAccountId;

    private final String resourceId;

    private final String connectionIdentifier;

    private ConnectionAliasAssociation(BuilderImpl builder) {
        this.associationStatus = builder.associationStatus;
        this.associatedAccountId = builder.associatedAccountId;
        this.resourceId = builder.resourceId;
        this.connectionIdentifier = builder.connectionIdentifier;
    }

    /**
     * <p>
     * The association status of the connection alias.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link AssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The association status of the connection alias.
     * @see AssociationStatus
     */
    public final AssociationStatus associationStatus() {
        return AssociationStatus.fromValue(associationStatus);
    }

    /**
     * <p>
     * The association status of the connection alias.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link AssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return The association status of the connection alias.
     * @see AssociationStatus
     */
    public final String associationStatusAsString() {
        return associationStatus;
    }

    /**
     * <p>
     * The identifier of the AWS account that associated the connection alias with a directory.
     * </p>
     * 
     * @return The identifier of the AWS account that associated the connection alias with a directory.
     */
    public final String associatedAccountId() {
        return associatedAccountId;
    }

    /**
     * <p>
     * The identifier of the directory associated with a connection alias.
     * </p>
     * 
     * @return The identifier of the directory associated with a connection alias.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The identifier of the connection alias association. You use the connection identifier in the DNS TXT record when
     * you're configuring your DNS routing policies.
     * </p>
     * 
     * @return The identifier of the connection alias association. You use the connection identifier in the DNS TXT
     *         record when you're configuring your DNS routing policies.
     */
    public final String connectionIdentifier() {
        return connectionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associatedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionAliasAssociation)) {
            return false;
        }
        ConnectionAliasAssociation other = (ConnectionAliasAssociation) obj;
        return Objects.equals(associationStatusAsString(), other.associationStatusAsString())
                && Objects.equals(associatedAccountId(), other.associatedAccountId())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(connectionIdentifier(), other.connectionIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionAliasAssociation").add("AssociationStatus", associationStatusAsString())
                .add("AssociatedAccountId", associatedAccountId()).add("ResourceId", resourceId())
                .add("ConnectionIdentifier", connectionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationStatus":
            return Optional.ofNullable(clazz.cast(associationStatusAsString()));
        case "AssociatedAccountId":
            return Optional.ofNullable(clazz.cast(associatedAccountId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ConnectionIdentifier":
            return Optional.ofNullable(clazz.cast(connectionIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionAliasAssociation, T> g) {
        return obj -> g.apply((ConnectionAliasAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionAliasAssociation> {
        /**
         * <p>
         * The association status of the connection alias.
         * </p>
         * 
         * @param associationStatus
         *        The association status of the connection alias.
         * @see AssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatus
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * The association status of the connection alias.
         * </p>
         * 
         * @param associationStatus
         *        The association status of the connection alias.
         * @see AssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatus
         */
        Builder associationStatus(AssociationStatus associationStatus);

        /**
         * <p>
         * The identifier of the AWS account that associated the connection alias with a directory.
         * </p>
         * 
         * @param associatedAccountId
         *        The identifier of the AWS account that associated the connection alias with a directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAccountId(String associatedAccountId);

        /**
         * <p>
         * The identifier of the directory associated with a connection alias.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the directory associated with a connection alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The identifier of the connection alias association. You use the connection identifier in the DNS TXT record
         * when you're configuring your DNS routing policies.
         * </p>
         * 
         * @param connectionIdentifier
         *        The identifier of the connection alias association. You use the connection identifier in the DNS TXT
         *        record when you're configuring your DNS routing policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionIdentifier(String connectionIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String associationStatus;

        private String associatedAccountId;

        private String resourceId;

        private String connectionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionAliasAssociation model) {
            associationStatus(model.associationStatus);
            associatedAccountId(model.associatedAccountId);
            resourceId(model.resourceId);
            connectionIdentifier(model.connectionIdentifier);
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        public final String getAssociatedAccountId() {
            return associatedAccountId;
        }

        @Override
        public final Builder associatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
            return this;
        }

        public final void setAssociatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getConnectionIdentifier() {
            return connectionIdentifier;
        }

        @Override
        public final Builder connectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
            return this;
        }

        public final void setConnectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
        }

        @Override
        public ConnectionAliasAssociation build() {
            return new ConnectionAliasAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
