/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.IpRuleItem;
import software.amazon.awssdk.services.workspaces.model.IpRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspacesIpGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspacesIpGroup> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspacesIpGroup.getter(WorkspacesIpGroup::groupId)).setter(WorkspacesIpGroup.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspacesIpGroup.getter(WorkspacesIpGroup::groupName)).setter(WorkspacesIpGroup.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()}).build();
    private static final SdkField<String> GROUP_DESC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspacesIpGroup.getter(WorkspacesIpGroup::groupDesc)).setter(WorkspacesIpGroup.setter(Builder::groupDesc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupDesc").build()}).build();
    private static final SdkField<List<IpRuleItem>> USER_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(WorkspacesIpGroup.getter(WorkspacesIpGroup::userRules)).setter(WorkspacesIpGroup.setter(Builder::userRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpRuleItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, GROUP_NAME_FIELD, GROUP_DESC_FIELD, USER_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final String groupName;
    private final String groupDesc;
    private final List<IpRuleItem> userRules;

    private WorkspacesIpGroup(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.groupDesc = builder.groupDesc;
        this.userRules = builder.userRules;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupName() {
        return this.groupName;
    }

    public String groupDesc() {
        return this.groupDesc;
    }

    public boolean hasUserRules() {
        return this.userRules != null && !(this.userRules instanceof SdkAutoConstructList);
    }

    public List<IpRuleItem> userRules() {
        return this.userRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupDesc());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspacesIpGroup)) {
            return false;
        }
        WorkspacesIpGroup other = (WorkspacesIpGroup)obj;
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.groupDesc(), other.groupDesc()) && Objects.equals(this.userRules(), other.userRules());
    }

    public String toString() {
        return ToString.builder((String)"WorkspacesIpGroup").add("GroupId", (Object)this.groupId()).add("GroupName", (Object)this.groupName()).add("GroupDesc", (Object)this.groupDesc()).add("UserRules", this.userRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "groupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "groupDesc": {
                return Optional.ofNullable(clazz.cast(this.groupDesc()));
            }
            case "userRules": {
                return Optional.ofNullable(clazz.cast(this.userRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspacesIpGroup, T> g) {
        return obj -> g.apply((WorkspacesIpGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private String groupName;
        private String groupDesc;
        private List<IpRuleItem> userRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspacesIpGroup model) {
            this.groupId(model.groupId);
            this.groupName(model.groupName);
            this.groupDesc(model.groupDesc);
            this.userRules(model.userRules);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupDesc() {
            return this.groupDesc;
        }

        @Override
        public final Builder groupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
            return this;
        }

        public final void setGroupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
        }

        public final Collection<IpRuleItem.Builder> getUserRules() {
            return this.userRules != null ? (Collection)this.userRules.stream().map(IpRuleItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userRules(Collection<IpRuleItem> userRules) {
            this.userRules = IpRuleListCopier.copy(userRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(IpRuleItem ... userRules) {
            this.userRules(Arrays.asList(userRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(Consumer<IpRuleItem.Builder> ... userRules) {
            this.userRules(Stream.of(userRules).map(c -> (IpRuleItem)((IpRuleItem.Builder)IpRuleItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserRules(Collection<IpRuleItem.BuilderImpl> userRules) {
            this.userRules = IpRuleListCopier.copyFromBuilder(userRules);
        }

        public WorkspacesIpGroup build() {
            return new WorkspacesIpGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspacesIpGroup> {
        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder groupDesc(String var1);

        public Builder userRules(Collection<IpRuleItem> var1);

        public Builder userRules(IpRuleItem ... var1);

        public Builder userRules(Consumer<IpRuleItem.Builder> ... var1);
    }
}

