/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.OperatingSystem;
import software.amazon.awssdk.services.workspaces.model.WorkspaceImageRequiredTenancy;
import software.amazon.awssdk.services.workspaces.model.WorkspaceImageState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceImage> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceImage.getter(WorkspaceImage::imageId)).setter(WorkspaceImage.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceImage.getter(WorkspaceImage::name)).setter(WorkspaceImage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceImage.getter(WorkspaceImage::description)).setter(WorkspaceImage.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<OperatingSystem> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkspaceImage.getter(WorkspaceImage::operatingSystem)).setter(WorkspaceImage.setter(Builder::operatingSystem)).constructor(OperatingSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceImage.getter(WorkspaceImage::stateAsString)).setter(WorkspaceImage.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> REQUIRED_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceImage.getter(WorkspaceImage::requiredTenancyAsString)).setter(WorkspaceImage.setter(Builder::requiredTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredTenancy").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceImage.getter(WorkspaceImage::errorCode)).setter(WorkspaceImage.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceImage.getter(WorkspaceImage::errorMessage)).setter(WorkspaceImage.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(WorkspaceImage.getter(WorkspaceImage::created)).setter(WorkspaceImage.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkspaceImage.getter(WorkspaceImage::ownerAccountId)).setter(WorkspaceImage.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, OPERATING_SYSTEM_FIELD, STATE_FIELD, REQUIRED_TENANCY_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, CREATED_FIELD, OWNER_ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String imageId;
    private final String name;
    private final String description;
    private final OperatingSystem operatingSystem;
    private final String state;
    private final String requiredTenancy;
    private final String errorCode;
    private final String errorMessage;
    private final Instant created;
    private final String ownerAccountId;

    private WorkspaceImage(BuilderImpl builder) {
        this.imageId = builder.imageId;
        this.name = builder.name;
        this.description = builder.description;
        this.operatingSystem = builder.operatingSystem;
        this.state = builder.state;
        this.requiredTenancy = builder.requiredTenancy;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.created = builder.created;
        this.ownerAccountId = builder.ownerAccountId;
    }

    public String imageId() {
        return this.imageId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public OperatingSystem operatingSystem() {
        return this.operatingSystem;
    }

    public WorkspaceImageState state() {
        return WorkspaceImageState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public WorkspaceImageRequiredTenancy requiredTenancy() {
        return WorkspaceImageRequiredTenancy.fromValue(this.requiredTenancy);
    }

    public String requiredTenancyAsString() {
        return this.requiredTenancy;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Instant created() {
        return this.created;
    }

    public String ownerAccountId() {
        return this.ownerAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiredTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceImage)) {
            return false;
        }
        WorkspaceImage other = (WorkspaceImage)obj;
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.operatingSystem(), other.operatingSystem()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.requiredTenancyAsString(), other.requiredTenancyAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId());
    }

    public String toString() {
        return ToString.builder((String)"WorkspaceImage").add("ImageId", (Object)this.imageId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("OperatingSystem", (Object)this.operatingSystem()).add("State", (Object)this.stateAsString()).add("RequiredTenancy", (Object)this.requiredTenancyAsString()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).add("Created", (Object)this.created()).add("OwnerAccountId", (Object)this.ownerAccountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystem()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "RequiredTenancy": {
                return Optional.ofNullable(clazz.cast(this.requiredTenancyAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceImage, T> g) {
        return obj -> g.apply((WorkspaceImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageId;
        private String name;
        private String description;
        private OperatingSystem operatingSystem;
        private String state;
        private String requiredTenancy;
        private String errorCode;
        private String errorMessage;
        private Instant created;
        private String ownerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceImage model) {
            this.imageId(model.imageId);
            this.name(model.name);
            this.description(model.description);
            this.operatingSystem(model.operatingSystem);
            this.state(model.state);
            this.requiredTenancy(model.requiredTenancy);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.created(model.created);
            this.ownerAccountId(model.ownerAccountId);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final OperatingSystem.Builder getOperatingSystem() {
            return this.operatingSystem != null ? this.operatingSystem.toBuilder() : null;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final void setOperatingSystem(OperatingSystem.BuilderImpl operatingSystem) {
            this.operatingSystem = operatingSystem != null ? operatingSystem.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getRequiredTenancy() {
            return this.requiredTenancy;
        }

        @Override
        public final Builder requiredTenancy(String requiredTenancy) {
            this.requiredTenancy = requiredTenancy;
            return this;
        }

        @Override
        public final Builder requiredTenancy(WorkspaceImageRequiredTenancy requiredTenancy) {
            this.requiredTenancy(requiredTenancy == null ? null : requiredTenancy.toString());
            return this;
        }

        public final void setRequiredTenancy(String requiredTenancy) {
            this.requiredTenancy = requiredTenancy;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        public WorkspaceImage build() {
            return new WorkspaceImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceImage> {
        public Builder imageId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        default public Builder operatingSystem(Consumer<OperatingSystem.Builder> operatingSystem) {
            return this.operatingSystem((OperatingSystem)((OperatingSystem.Builder)OperatingSystem.builder().applyMutation(operatingSystem)).build());
        }

        public Builder state(String var1);

        public Builder state(WorkspaceImageState var1);

        public Builder requiredTenancy(String var1);

        public Builder requiredTenancy(WorkspaceImageRequiredTenancy var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);

        public Builder created(Instant var1);

        public Builder ownerAccountId(String var1);
    }
}

