/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.ImageType;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspaceImageIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceImagesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspaceImagesRequest> {
    private static final SdkField<List<String>> IMAGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeWorkspaceImagesRequest.getter(DescribeWorkspaceImagesRequest::imageIds)).setter(DescribeWorkspaceImagesRequest.setter(Builder::imageIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWorkspaceImagesRequest.getter(DescribeWorkspaceImagesRequest::imageTypeAsString)).setter(DescribeWorkspaceImagesRequest.setter(Builder::imageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeWorkspaceImagesRequest.getter(DescribeWorkspaceImagesRequest::nextToken)).setter(DescribeWorkspaceImagesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeWorkspaceImagesRequest.getter(DescribeWorkspaceImagesRequest::maxResults)).setter(DescribeWorkspaceImagesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDS_FIELD, IMAGE_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> imageIds;
    private final String imageType;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeWorkspaceImagesRequest(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.imageType = builder.imageType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public boolean hasImageIds() {
        return this.imageIds != null && !(this.imageIds instanceof SdkAutoConstructList);
    }

    public List<String> imageIds() {
        return this.imageIds;
    }

    public ImageType imageType() {
        return ImageType.fromValue(this.imageType);
    }

    public String imageTypeAsString() {
        return this.imageType;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceImagesRequest)) {
            return false;
        }
        DescribeWorkspaceImagesRequest other = (DescribeWorkspaceImagesRequest)((Object)obj);
        return Objects.equals(this.imageIds(), other.imageIds()) && Objects.equals(this.imageTypeAsString(), other.imageTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeWorkspaceImagesRequest").add("ImageIds", this.imageIds()).add("ImageType", (Object)this.imageTypeAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageIds": {
                return Optional.ofNullable(clazz.cast(this.imageIds()));
            }
            case "ImageType": {
                return Optional.ofNullable(clazz.cast(this.imageTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceImagesRequest, T> g) {
        return obj -> g.apply((DescribeWorkspaceImagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> imageIds = DefaultSdkAutoConstructList.getInstance();
        private String imageType;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceImagesRequest model) {
            super(model);
            this.imageIds(model.imageIds);
            this.imageType(model.imageType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getImageIds() {
            return this.imageIds;
        }

        @Override
        public final Builder imageIds(Collection<String> imageIds) {
            this.imageIds = WorkspaceImageIdListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(String ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final void setImageIds(Collection<String> imageIds) {
            this.imageIds = WorkspaceImageIdListCopier.copy(imageIds);
        }

        public final String getImageType() {
            return this.imageType;
        }

        @Override
        public final Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        @Override
        public final Builder imageType(ImageType imageType) {
            this.imageType(imageType == null ? null : imageType.toString());
            return this;
        }

        public final void setImageType(String imageType) {
            this.imageType = imageType;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspaceImagesRequest build() {
            return new DescribeWorkspaceImagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceImagesRequest> {
        public Builder imageIds(Collection<String> var1);

        public Builder imageIds(String ... var1);

        public Builder imageType(String var1);

        public Builder imageType(ImageType var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

