/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsForEntityResponse;

public class ListGroupsForEntityIterable
implements SdkIterable<ListGroupsForEntityResponse> {
    private final WorkMailClient client;
    private final ListGroupsForEntityRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupsForEntityIterable(WorkMailClient client, ListGroupsForEntityRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGroupsForEntityResponseFetcher();
    }

    public Iterator<ListGroupsForEntityResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListGroupsForEntityResponseFetcher
    implements SyncPageFetcher<ListGroupsForEntityResponse> {
        private ListGroupsForEntityResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsForEntityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupsForEntityResponse nextPage(ListGroupsForEntityResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsForEntityIterable.this.client.listGroupsForEntity(ListGroupsForEntityIterable.this.firstRequest);
            }
            return ListGroupsForEntityIterable.this.client.listGroupsForEntity((ListGroupsForEntityRequest)((Object)ListGroupsForEntityIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

