/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.UserRole;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(UpdateUserRequest.getter(UpdateUserRequest::organizationId)).setter(UpdateUserRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UpdateUserRequest.getter(UpdateUserRequest::userId)).setter(UpdateUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(UpdateUserRequest.getter(UpdateUserRequest::roleAsString)).setter(UpdateUserRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateUserRequest.getter(UpdateUserRequest::displayName)).setter(UpdateUserRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstName").getter(UpdateUserRequest.getter(UpdateUserRequest::firstName)).setter(UpdateUserRequest.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastName").getter(UpdateUserRequest.getter(UpdateUserRequest::lastName)).setter(UpdateUserRequest.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HiddenFromGlobalAddressList").getter(UpdateUserRequest.getter(UpdateUserRequest::hiddenFromGlobalAddressList)).setter(UpdateUserRequest.setter(Builder::hiddenFromGlobalAddressList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList").build()}).build();
    private static final SdkField<String> INITIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Initials").getter(UpdateUserRequest.getter(UpdateUserRequest::initials)).setter(UpdateUserRequest.setter(Builder::initials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initials").build()}).build();
    private static final SdkField<String> TELEPHONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Telephone").getter(UpdateUserRequest.getter(UpdateUserRequest::telephone)).setter(UpdateUserRequest.setter(Builder::telephone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Telephone").build()}).build();
    private static final SdkField<String> STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Street").getter(UpdateUserRequest.getter(UpdateUserRequest::street)).setter(UpdateUserRequest.setter(Builder::street)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build()}).build();
    private static final SdkField<String> JOB_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTitle").getter(UpdateUserRequest.getter(UpdateUserRequest::jobTitle)).setter(UpdateUserRequest.setter(Builder::jobTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTitle").build()}).build();
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("City").getter(UpdateUserRequest.getter(UpdateUserRequest::city)).setter(UpdateUserRequest.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()}).build();
    private static final SdkField<String> COMPANY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Company").getter(UpdateUserRequest.getter(UpdateUserRequest::company)).setter(UpdateUserRequest.setter(Builder::company)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Company").build()}).build();
    private static final SdkField<String> ZIP_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZipCode").getter(UpdateUserRequest.getter(UpdateUserRequest::zipCode)).setter(UpdateUserRequest.setter(Builder::zipCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipCode").build()}).build();
    private static final SdkField<String> DEPARTMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Department").getter(UpdateUserRequest.getter(UpdateUserRequest::department)).setter(UpdateUserRequest.setter(Builder::department)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Department").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(UpdateUserRequest.getter(UpdateUserRequest::country)).setter(UpdateUserRequest.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> OFFICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Office").getter(UpdateUserRequest.getter(UpdateUserRequest::office)).setter(UpdateUserRequest.setter(Builder::office)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Office").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderUserId").getter(UpdateUserRequest.getter(UpdateUserRequest::identityProviderUserId)).setter(UpdateUserRequest.setter(Builder::identityProviderUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderUserId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, USER_ID_FIELD, ROLE_FIELD, DISPLAY_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD, INITIALS_FIELD, TELEPHONE_FIELD, STREET_FIELD, JOB_TITLE_FIELD, CITY_FIELD, COMPANY_FIELD, ZIP_CODE_FIELD, DEPARTMENT_FIELD, COUNTRY_FIELD, OFFICE_FIELD, IDENTITY_PROVIDER_USER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrganizationId", ORGANIZATION_ID_FIELD);
            this.put("UserId", USER_ID_FIELD);
            this.put("Role", ROLE_FIELD);
            this.put("DisplayName", DISPLAY_NAME_FIELD);
            this.put("FirstName", FIRST_NAME_FIELD);
            this.put("LastName", LAST_NAME_FIELD);
            this.put("HiddenFromGlobalAddressList", HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD);
            this.put("Initials", INITIALS_FIELD);
            this.put("Telephone", TELEPHONE_FIELD);
            this.put("Street", STREET_FIELD);
            this.put("JobTitle", JOB_TITLE_FIELD);
            this.put("City", CITY_FIELD);
            this.put("Company", COMPANY_FIELD);
            this.put("ZipCode", ZIP_CODE_FIELD);
            this.put("Department", DEPARTMENT_FIELD);
            this.put("Country", COUNTRY_FIELD);
            this.put("Office", OFFICE_FIELD);
            this.put("IdentityProviderUserId", IDENTITY_PROVIDER_USER_ID_FIELD);
        }
    });
    private final String organizationId;
    private final String userId;
    private final String role;
    private final String displayName;
    private final String firstName;
    private final String lastName;
    private final Boolean hiddenFromGlobalAddressList;
    private final String initials;
    private final String telephone;
    private final String street;
    private final String jobTitle;
    private final String city;
    private final String company;
    private final String zipCode;
    private final String department;
    private final String country;
    private final String office;
    private final String identityProviderUserId;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.userId = builder.userId;
        this.role = builder.role;
        this.displayName = builder.displayName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
        this.initials = builder.initials;
        this.telephone = builder.telephone;
        this.street = builder.street;
        this.jobTitle = builder.jobTitle;
        this.city = builder.city;
        this.company = builder.company;
        this.zipCode = builder.zipCode;
        this.department = builder.department;
        this.country = builder.country;
        this.office = builder.office;
        this.identityProviderUserId = builder.identityProviderUserId;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String userId() {
        return this.userId;
    }

    public final UserRole role() {
        return UserRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final Boolean hiddenFromGlobalAddressList() {
        return this.hiddenFromGlobalAddressList;
    }

    public final String initials() {
        return this.initials;
    }

    public final String telephone() {
        return this.telephone;
    }

    public final String street() {
        return this.street;
    }

    public final String jobTitle() {
        return this.jobTitle;
    }

    public final String city() {
        return this.city;
    }

    public final String company() {
        return this.company;
    }

    public final String zipCode() {
        return this.zipCode;
    }

    public final String department() {
        return this.department;
    }

    public final String country() {
        return this.country;
    }

    public final String office() {
        return this.office;
    }

    public final String identityProviderUserId() {
        return this.identityProviderUserId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hiddenFromGlobalAddressList());
        hashCode = 31 * hashCode + Objects.hashCode(this.initials());
        hashCode = 31 * hashCode + Objects.hashCode(this.telephone());
        hashCode = 31 * hashCode + Objects.hashCode(this.street());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.company());
        hashCode = 31 * hashCode + Objects.hashCode(this.zipCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.department());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.office());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderUserId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList()) && Objects.equals(this.initials(), other.initials()) && Objects.equals(this.telephone(), other.telephone()) && Objects.equals(this.street(), other.street()) && Objects.equals(this.jobTitle(), other.jobTitle()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.company(), other.company()) && Objects.equals(this.zipCode(), other.zipCode()) && Objects.equals(this.department(), other.department()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.office(), other.office()) && Objects.equals(this.identityProviderUserId(), other.identityProviderUserId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserRequest").add("OrganizationId", (Object)this.organizationId()).add("UserId", (Object)this.userId()).add("Role", (Object)this.roleAsString()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("HiddenFromGlobalAddressList", (Object)this.hiddenFromGlobalAddressList()).add("Initials", (Object)(this.initials() == null ? null : "*** Sensitive Data Redacted ***")).add("Telephone", (Object)(this.telephone() == null ? null : "*** Sensitive Data Redacted ***")).add("Street", (Object)(this.street() == null ? null : "*** Sensitive Data Redacted ***")).add("JobTitle", (Object)(this.jobTitle() == null ? null : "*** Sensitive Data Redacted ***")).add("City", (Object)(this.city() == null ? null : "*** Sensitive Data Redacted ***")).add("Company", (Object)(this.company() == null ? null : "*** Sensitive Data Redacted ***")).add("ZipCode", (Object)(this.zipCode() == null ? null : "*** Sensitive Data Redacted ***")).add("Department", (Object)(this.department() == null ? null : "*** Sensitive Data Redacted ***")).add("Country", (Object)(this.country() == null ? null : "*** Sensitive Data Redacted ***")).add("Office", (Object)(this.office() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityProviderUserId", (Object)this.identityProviderUserId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "HiddenFromGlobalAddressList": {
                return Optional.ofNullable(clazz.cast(this.hiddenFromGlobalAddressList()));
            }
            case "Initials": {
                return Optional.ofNullable(clazz.cast(this.initials()));
            }
            case "Telephone": {
                return Optional.ofNullable(clazz.cast(this.telephone()));
            }
            case "Street": {
                return Optional.ofNullable(clazz.cast(this.street()));
            }
            case "JobTitle": {
                return Optional.ofNullable(clazz.cast(this.jobTitle()));
            }
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "Company": {
                return Optional.ofNullable(clazz.cast(this.company()));
            }
            case "ZipCode": {
                return Optional.ofNullable(clazz.cast(this.zipCode()));
            }
            case "Department": {
                return Optional.ofNullable(clazz.cast(this.department()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Office": {
                return Optional.ofNullable(clazz.cast(this.office()));
            }
            case "IdentityProviderUserId": {
                return Optional.ofNullable(clazz.cast(this.identityProviderUserId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String userId;
        private String role;
        private String displayName;
        private String firstName;
        private String lastName;
        private Boolean hiddenFromGlobalAddressList;
        private String initials;
        private String telephone;
        private String street;
        private String jobTitle;
        private String city;
        private String company;
        private String zipCode;
        private String department;
        private String country;
        private String office;
        private String identityProviderUserId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.userId(model.userId);
            this.role(model.role);
            this.displayName(model.displayName);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
            this.initials(model.initials);
            this.telephone(model.telephone);
            this.street(model.street);
            this.jobTitle(model.jobTitle);
            this.city(model.city);
            this.company(model.company);
            this.zipCode(model.zipCode);
            this.department(model.department);
            this.country(model.country);
            this.office(model.office);
            this.identityProviderUserId(model.identityProviderUserId);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(UserRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return this.hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        public final String getInitials() {
            return this.initials;
        }

        public final void setInitials(String initials) {
            this.initials = initials;
        }

        @Override
        public final Builder initials(String initials) {
            this.initials = initials;
            return this;
        }

        public final String getTelephone() {
            return this.telephone;
        }

        public final void setTelephone(String telephone) {
            this.telephone = telephone;
        }

        @Override
        public final Builder telephone(String telephone) {
            this.telephone = telephone;
            return this;
        }

        public final String getStreet() {
            return this.street;
        }

        public final void setStreet(String street) {
            this.street = street;
        }

        @Override
        public final Builder street(String street) {
            this.street = street;
            return this;
        }

        public final String getJobTitle() {
            return this.jobTitle;
        }

        public final void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
        }

        @Override
        public final Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCompany() {
            return this.company;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final String getZipCode() {
            return this.zipCode;
        }

        public final void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        @Override
        public final Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public final String getDepartment() {
            return this.department;
        }

        public final void setDepartment(String department) {
            this.department = department;
        }

        @Override
        public final Builder department(String department) {
            this.department = department;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getOffice() {
            return this.office;
        }

        public final void setOffice(String office) {
            this.office = office;
        }

        @Override
        public final Builder office(String office) {
            this.office = office;
            return this;
        }

        public final String getIdentityProviderUserId() {
            return this.identityProviderUserId;
        }

        public final void setIdentityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
        }

        @Override
        public final Builder identityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder organizationId(String var1);

        public Builder userId(String var1);

        public Builder role(String var1);

        public Builder role(UserRole var1);

        public Builder displayName(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder hiddenFromGlobalAddressList(Boolean var1);

        public Builder initials(String var1);

        public Builder telephone(String var1);

        public Builder street(String var1);

        public Builder jobTitle(String var1);

        public Builder city(String var1);

        public Builder company(String var1);

        public Builder zipCode(String var1);

        public Builder department(String var1);

        public Builder country(String var1);

        public Builder office(String var1);

        public Builder identityProviderUserId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

