/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.MailboxExportJobState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MailboxExportJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MailboxExportJob> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(MailboxExportJob.getter(MailboxExportJob::jobId)).setter(MailboxExportJob.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityId").getter(MailboxExportJob.getter(MailboxExportJob::entityId)).setter(MailboxExportJob.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(MailboxExportJob.getter(MailboxExportJob::description)).setter(MailboxExportJob.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(MailboxExportJob.getter(MailboxExportJob::s3BucketName)).setter(MailboxExportJob.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Path").getter(MailboxExportJob.getter(MailboxExportJob::s3Path)).setter(MailboxExportJob.setter(Builder::s3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()}).build();
    private static final SdkField<Integer> ESTIMATED_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EstimatedProgress").getter(MailboxExportJob.getter(MailboxExportJob::estimatedProgress)).setter(MailboxExportJob.setter(Builder::estimatedProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedProgress").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(MailboxExportJob.getter(MailboxExportJob::stateAsString)).setter(MailboxExportJob.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MailboxExportJob.getter(MailboxExportJob::startTime)).setter(MailboxExportJob.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(MailboxExportJob.getter(MailboxExportJob::endTime)).setter(MailboxExportJob.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, ENTITY_ID_FIELD, DESCRIPTION_FIELD, S3_BUCKET_NAME_FIELD, S3_PATH_FIELD, ESTIMATED_PROGRESS_FIELD, STATE_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JobId", JOB_ID_FIELD);
            this.put("EntityId", ENTITY_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("S3BucketName", S3_BUCKET_NAME_FIELD);
            this.put("S3Path", S3_PATH_FIELD);
            this.put("EstimatedProgress", ESTIMATED_PROGRESS_FIELD);
            this.put("State", STATE_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String entityId;
    private final String description;
    private final String s3BucketName;
    private final String s3Path;
    private final Integer estimatedProgress;
    private final String state;
    private final Instant startTime;
    private final Instant endTime;

    private MailboxExportJob(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.entityId = builder.entityId;
        this.description = builder.description;
        this.s3BucketName = builder.s3BucketName;
        this.s3Path = builder.s3Path;
        this.estimatedProgress = builder.estimatedProgress;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String description() {
        return this.description;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3Path() {
        return this.s3Path;
    }

    public final Integer estimatedProgress() {
        return this.estimatedProgress;
    }

    public final MailboxExportJobState state() {
        return MailboxExportJobState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MailboxExportJob)) {
            return false;
        }
        MailboxExportJob other = (MailboxExportJob)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3Path(), other.s3Path()) && Objects.equals(this.estimatedProgress(), other.estimatedProgress()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"MailboxExportJob").add("JobId", (Object)this.jobId()).add("EntityId", (Object)this.entityId()).add("Description", (Object)this.description()).add("S3BucketName", (Object)this.s3BucketName()).add("S3Path", (Object)this.s3Path()).add("EstimatedProgress", (Object)this.estimatedProgress()).add("State", (Object)this.stateAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3Path": {
                return Optional.ofNullable(clazz.cast(this.s3Path()));
            }
            case "EstimatedProgress": {
                return Optional.ofNullable(clazz.cast(this.estimatedProgress()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MailboxExportJob, T> g) {
        return obj -> g.apply((MailboxExportJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String entityId;
        private String description;
        private String s3BucketName;
        private String s3Path;
        private Integer estimatedProgress;
        private String state;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MailboxExportJob model) {
            this.jobId(model.jobId);
            this.entityId(model.entityId);
            this.description(model.description);
            this.s3BucketName(model.s3BucketName);
            this.s3Path(model.s3Path);
            this.estimatedProgress(model.estimatedProgress);
            this.state(model.state);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3Path() {
            return this.s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final Integer getEstimatedProgress() {
            return this.estimatedProgress;
        }

        public final void setEstimatedProgress(Integer estimatedProgress) {
            this.estimatedProgress = estimatedProgress;
        }

        @Override
        public final Builder estimatedProgress(Integer estimatedProgress) {
            this.estimatedProgress = estimatedProgress;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MailboxExportJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public MailboxExportJob build() {
            return new MailboxExportJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MailboxExportJob> {
        public Builder jobId(String var1);

        public Builder entityId(String var1);

        public Builder description(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3Path(String var1);

        public Builder estimatedProgress(Integer var1);

        public Builder state(String var1);

        public Builder state(MailboxExportJobState var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

