/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessOverride;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessOverridesListCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMobileDeviceAccessOverridesResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListMobileDeviceAccessOverridesResponse> {
    private static final SdkField<List<MobileDeviceAccessOverride>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Overrides").getter(ListMobileDeviceAccessOverridesResponse.getter(ListMobileDeviceAccessOverridesResponse::overrides)).setter(ListMobileDeviceAccessOverridesResponse.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MobileDeviceAccessOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMobileDeviceAccessOverridesResponse.getter(ListMobileDeviceAccessOverridesResponse::nextToken)).setter(ListMobileDeviceAccessOverridesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Overrides", OVERRIDES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<MobileDeviceAccessOverride> overrides;
    private final String nextToken;

    private ListMobileDeviceAccessOverridesResponse(BuilderImpl builder) {
        super(builder);
        this.overrides = builder.overrides;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructList);
    }

    public final List<MobileDeviceAccessOverride> overrides() {
        return this.overrides;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMobileDeviceAccessOverridesResponse)) {
            return false;
        }
        ListMobileDeviceAccessOverridesResponse other = (ListMobileDeviceAccessOverridesResponse)((Object)obj);
        return this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMobileDeviceAccessOverridesResponse").add("Overrides", this.hasOverrides() ? this.overrides() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMobileDeviceAccessOverridesResponse, T> g) {
        return obj -> g.apply((ListMobileDeviceAccessOverridesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<MobileDeviceAccessOverride> overrides = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMobileDeviceAccessOverridesResponse model) {
            super(model);
            this.overrides(model.overrides);
            this.nextToken(model.nextToken);
        }

        public final List<MobileDeviceAccessOverride.Builder> getOverrides() {
            List<MobileDeviceAccessOverride.Builder> result = MobileDeviceAccessOverridesListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<MobileDeviceAccessOverride.BuilderImpl> overrides) {
            this.overrides = MobileDeviceAccessOverridesListCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<MobileDeviceAccessOverride> overrides) {
            this.overrides = MobileDeviceAccessOverridesListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(MobileDeviceAccessOverride ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<MobileDeviceAccessOverride.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (MobileDeviceAccessOverride)((MobileDeviceAccessOverride.Builder)MobileDeviceAccessOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMobileDeviceAccessOverridesResponse build() {
            return new ListMobileDeviceAccessOverridesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMobileDeviceAccessOverridesResponse> {
        public Builder overrides(Collection<MobileDeviceAccessOverride> var1);

        public Builder overrides(MobileDeviceAccessOverride ... var1);

        public Builder overrides(Consumer<MobileDeviceAccessOverride.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

