/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceRequest;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceResponse;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupRequest;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupResponse;
import software.amazon.awssdk.services.workmail.model.AssumeImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.AssumeImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.CancelMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.CancelMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.CreateAliasRequest;
import software.amazon.awssdk.services.workmail.model.CreateAliasResponse;
import software.amazon.awssdk.services.workmail.model.CreateAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.CreateAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.CreateGroupRequest;
import software.amazon.awssdk.services.workmail.model.CreateGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.CreateImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.CreateMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.CreateMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.CreateOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.CreateOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.CreateResourceRequest;
import software.amazon.awssdk.services.workmail.model.CreateResourceResponse;
import software.amazon.awssdk.services.workmail.model.CreateUserRequest;
import software.amazon.awssdk.services.workmail.model.CreateUserResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAliasRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAliasResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteEmailMonitoringConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteEmailMonitoringConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteGroupRequest;
import software.amazon.awssdk.services.workmail.model.DeleteGroupResponse;
import software.amazon.awssdk.services.workmail.model.DeleteImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteResourceRequest;
import software.amazon.awssdk.services.workmail.model.DeleteResourceResponse;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.DeleteUserRequest;
import software.amazon.awssdk.services.workmail.model.DeleteUserResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.DescribeEmailMonitoringConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeEmailMonitoringConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeEntityRequest;
import software.amazon.awssdk.services.workmail.model.DescribeEntityResponse;
import software.amazon.awssdk.services.workmail.model.DescribeGroupRequest;
import software.amazon.awssdk.services.workmail.model.DescribeGroupResponse;
import software.amazon.awssdk.services.workmail.model.DescribeInboundDmarcSettingsRequest;
import software.amazon.awssdk.services.workmail.model.DescribeInboundDmarcSettingsResponse;
import software.amazon.awssdk.services.workmail.model.DescribeMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.DescribeMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeResourceRequest;
import software.amazon.awssdk.services.workmail.model.DescribeResourceResponse;
import software.amazon.awssdk.services.workmail.model.DescribeUserRequest;
import software.amazon.awssdk.services.workmail.model.DescribeUserResponse;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceResponse;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupResponse;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.GetImpersonationRoleEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetImpersonationRoleEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.GetImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.GetMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.GetMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsRequest;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsResponse;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesRequest;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesResponse;
import software.amazon.awssdk.services.workmail.model.ListAliasesRequest;
import software.amazon.awssdk.services.workmail.model.ListAliasesResponse;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsForEntityResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupsRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsResponse;
import software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest;
import software.amazon.awssdk.services.workmail.model.ListImpersonationRolesResponse;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessRulesRequest;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessRulesResponse;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse;
import software.amazon.awssdk.services.workmail.model.ListResourcesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourcesResponse;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workmail.model.ListUsersRequest;
import software.amazon.awssdk.services.workmail.model.ListUsersResponse;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.PutEmailMonitoringConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.PutEmailMonitoringConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.PutInboundDmarcSettingsRequest;
import software.amazon.awssdk.services.workmail.model.PutInboundDmarcSettingsResponse;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.PutMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.PutMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.RegisterMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.RegisterMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.ResetPasswordRequest;
import software.amazon.awssdk.services.workmail.model.ResetPasswordResponse;
import software.amazon.awssdk.services.workmail.model.StartMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.StartMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.TagResourceRequest;
import software.amazon.awssdk.services.workmail.model.TagResourceResponse;
import software.amazon.awssdk.services.workmail.model.TestAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.TestAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.UntagResourceRequest;
import software.amazon.awssdk.services.workmail.model.UntagResourceResponse;
import software.amazon.awssdk.services.workmail.model.UpdateAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.UpdateAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.UpdateDefaultMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.UpdateDefaultMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.UpdateGroupRequest;
import software.amazon.awssdk.services.workmail.model.UpdateGroupResponse;
import software.amazon.awssdk.services.workmail.model.UpdateImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.UpdateImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaResponse;
import software.amazon.awssdk.services.workmail.model.UpdateMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressRequest;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressResponse;
import software.amazon.awssdk.services.workmail.model.UpdateResourceRequest;
import software.amazon.awssdk.services.workmail.model.UpdateResourceResponse;
import software.amazon.awssdk.services.workmail.model.UpdateUserRequest;
import software.amazon.awssdk.services.workmail.model.UpdateUserResponse;
import software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListGroupsForEntityPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListImpersonationRolesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListMailDomainsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher;

/**
 * Service client for accessing Amazon WorkMail asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * WorkMail is a secure, managed business email and calendaring service with support for existing desktop and mobile
 * email clients. You can access your email, contacts, and calendars using Microsoft Outlook, your browser, or other
 * native iOS and Android email applications. You can integrate WorkMail with your existing corporate directory and
 * control both the keys that encrypt your data and the location in which your data is stored.
 * </p>
 * <p>
 * The WorkMail API is designed for the following scenarios:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Listing and describing organizations
 * </p>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * Managing users
 * </p>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * Managing groups
 * </p>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * Managing resources
 * </p>
 * </li>
 * </ul>
 * <p>
 * All WorkMail API operations are Amazon-authenticated and certificate-signed. They not only require the use of the AWS
 * SDK, but also allow for the exclusive use of AWS Identity and Access Management users and roles to help facilitate
 * access, trust, and permission policies. By creating a role and allowing an IAM user to access the WorkMail site, the
 * IAM user gains full administrative visibility into the entire WorkMail organization (or as set in the IAM policy).
 * This includes, but is not limited to, the ability to create, update, and delete users, groups, and resources. This
 * allows developers to perform the scenarios listed above, as well as give users the ability to grant access on a
 * selective basis using the IAM model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkMailAsyncClient extends AwsClient {
    String SERVICE_NAME = "workmail";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workmail";

    /**
     * <p>
     * Adds a member (user or group) to the resource's set of delegates.
     * </p>
     *
     * @param associateDelegateToResourceRequest
     * @return A Java Future containing the result of the AssociateDelegateToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateDelegateToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDelegateToResourceResponse> associateDelegateToResource(
            AssociateDelegateToResourceRequest associateDelegateToResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a member (user or group) to the resource's set of delegates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDelegateToResourceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateDelegateToResourceRequest#builder()}
     * </p>
     *
     * @param associateDelegateToResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateDelegateToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateDelegateToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDelegateToResourceResponse> associateDelegateToResource(
            Consumer<AssociateDelegateToResourceRequest.Builder> associateDelegateToResourceRequest) {
        return associateDelegateToResource(AssociateDelegateToResourceRequest.builder()
                .applyMutation(associateDelegateToResourceRequest).build());
    }

    /**
     * <p>
     * Adds a member (user or group) to the group's set.
     * </p>
     *
     * @param associateMemberToGroupRequest
     * @return A Java Future containing the result of the AssociateMemberToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateMemberToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToGroupResponse> associateMemberToGroup(
            AssociateMemberToGroupRequest associateMemberToGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a member (user or group) to the group's set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToGroupRequest#builder()}
     * </p>
     *
     * @param associateMemberToGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateMemberToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateMemberToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateMemberToGroupResponse> associateMemberToGroup(
            Consumer<AssociateMemberToGroupRequest.Builder> associateMemberToGroupRequest) {
        return associateMemberToGroup(AssociateMemberToGroupRequest.builder().applyMutation(associateMemberToGroupRequest)
                .build());
    }

    /**
     * <p>
     * Assumes an impersonation role for the given WorkMail organization. This method returns an authentication token
     * you can use to make impersonated calls.
     * </p>
     *
     * @param assumeImpersonationRoleRequest
     * @return A Java Future containing the result of the AssumeImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssumeImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssumeImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeImpersonationRoleResponse> assumeImpersonationRole(
            AssumeImpersonationRoleRequest assumeImpersonationRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assumes an impersonation role for the given WorkMail organization. This method returns an authentication token
     * you can use to make impersonated calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeImpersonationRoleRequest.Builder} avoiding
     * the need to create one manually via {@link AssumeImpersonationRoleRequest#builder()}
     * </p>
     *
     * @param assumeImpersonationRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.AssumeImpersonationRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssumeImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssumeImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssumeImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeImpersonationRoleResponse> assumeImpersonationRole(
            Consumer<AssumeImpersonationRoleRequest.Builder> assumeImpersonationRoleRequest) {
        return assumeImpersonationRole(AssumeImpersonationRoleRequest.builder().applyMutation(assumeImpersonationRoleRequest)
                .build());
    }

    /**
     * <p>
     * Cancels a mailbox export job.
     * </p>
     * <note>
     * <p>
     * If the mailbox export job is near completion, it might not be possible to cancel it.
     * </p>
     * </note>
     *
     * @param cancelMailboxExportJobRequest
     * @return A Java Future containing the result of the CancelMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CancelMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CancelMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMailboxExportJobResponse> cancelMailboxExportJob(
            CancelMailboxExportJobRequest cancelMailboxExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a mailbox export job.
     * </p>
     * <note>
     * <p>
     * If the mailbox export job is near completion, it might not be possible to cancel it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMailboxExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelMailboxExportJobRequest#builder()}
     * </p>
     *
     * @param cancelMailboxExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.CancelMailboxExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CancelMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CancelMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMailboxExportJobResponse> cancelMailboxExportJob(
            Consumer<CancelMailboxExportJobRequest.Builder> cancelMailboxExportJobRequest) {
        return cancelMailboxExportJob(CancelMailboxExportJobRequest.builder().applyMutation(cancelMailboxExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Adds an alias to the set of a given member (user or group) of WorkMail.
     * </p>
     *
     * @param createAliasRequest
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an alias to the set of a given member (user or group) of WorkMail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAliasRequest#builder()}
     * </p>
     *
     * @param createAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.CreateAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest) {
        return createAlias(CreateAliasRequest.builder().applyMutation(createAliasRequest).build());
    }

    /**
     * <p>
     * Creates an <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     *
     * @param createAvailabilityConfigurationRequest
     * @return A Java Future containing the result of the CreateAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAvailabilityConfigurationResponse> createAvailabilityConfiguration(
            CreateAvailabilityConfigurationRequest createAvailabilityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAvailabilityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAvailabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param createAvailabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.CreateAvailabilityConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAvailabilityConfigurationResponse> createAvailabilityConfiguration(
            Consumer<CreateAvailabilityConfigurationRequest.Builder> createAvailabilityConfigurationRequest) {
        return createAvailabilityConfiguration(CreateAvailabilityConfigurationRequest.builder()
                .applyMutation(createAvailabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a group that can be used in WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group that can be used in WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.CreateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Creates an impersonation role for the given WorkMail organization.
     * </p>
     * <p>
     * <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent request, if
     * the original request completes successfully, any subsequent retries also complete successfully without performing
     * any further actions.
     * </p>
     *
     * @param createImpersonationRoleRequest
     * @return A Java Future containing the result of the CreateImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateImpersonationRoleResponse> createImpersonationRole(
            CreateImpersonationRoleRequest createImpersonationRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an impersonation role for the given WorkMail organization.
     * </p>
     * <p>
     * <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent request, if
     * the original request completes successfully, any subsequent retries also complete successfully without performing
     * any further actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImpersonationRoleRequest.Builder} avoiding
     * the need to create one manually via {@link CreateImpersonationRoleRequest#builder()}
     * </p>
     *
     * @param createImpersonationRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.CreateImpersonationRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateImpersonationRoleResponse> createImpersonationRole(
            Consumer<CreateImpersonationRoleRequest.Builder> createImpersonationRoleRequest) {
        return createImpersonationRole(CreateImpersonationRoleRequest.builder().applyMutation(createImpersonationRoleRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new mobile device access rule for the specified WorkMail organization.
     * </p>
     *
     * @param createMobileDeviceAccessRuleRequest
     * @return A Java Future containing the result of the CreateMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMobileDeviceAccessRuleResponse> createMobileDeviceAccessRule(
            CreateMobileDeviceAccessRuleRequest createMobileDeviceAccessRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new mobile device access rule for the specified WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMobileDeviceAccessRuleRequest.Builder}
     * avoiding the need to create one manually via {@link CreateMobileDeviceAccessRuleRequest#builder()}
     * </p>
     *
     * @param createMobileDeviceAccessRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.CreateMobileDeviceAccessRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMobileDeviceAccessRuleResponse> createMobileDeviceAccessRule(
            Consumer<CreateMobileDeviceAccessRuleRequest.Builder> createMobileDeviceAccessRuleRequest) {
        return createMobileDeviceAccessRule(CreateMobileDeviceAccessRuleRequest.builder()
                .applyMutation(createMobileDeviceAccessRuleRequest).build());
    }

    /**
     * <p>
     * Creates a new WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service
     * directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias
     * must match the directory alias. If you choose not to associate an existing directory with your organization, then
     * we create a new WorkMail directory for you. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an
     * organization</a> in the <i>WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * You can associate multiple email domains with an organization, then choose your default email domain from the
     * WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For
     * more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a
     * domain</a> and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the
     * default domain</a> in the <i>WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * Optionally, you can use a customer managed key from AWS Key Management Service (AWS KMS) to encrypt email for
     * your organization. If you don't associate an AWS KMS key, WorkMail creates a default, AWS managed key for you.
     * </p>
     *
     * @param createOrganizationRequest
     * @return A Java Future containing the result of the CreateOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>DirectoryInUseException The directory is already in use by another WorkMail organization in the same
     *         account and Region.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateOrganizationResponse> createOrganization(CreateOrganizationRequest createOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service
     * directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias
     * must match the directory alias. If you choose not to associate an existing directory with your organization, then
     * we create a new WorkMail directory for you. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an
     * organization</a> in the <i>WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * You can associate multiple email domains with an organization, then choose your default email domain from the
     * WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For
     * more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a
     * domain</a> and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the
     * default domain</a> in the <i>WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * Optionally, you can use a customer managed key from AWS Key Management Service (AWS KMS) to encrypt email for
     * your organization. If you don't associate an AWS KMS key, WorkMail creates a default, AWS managed key for you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOrganizationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOrganizationRequest#builder()}
     * </p>
     *
     * @param createOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.CreateOrganizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>DirectoryInUseException The directory is already in use by another WorkMail organization in the same
     *         account and Region.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateOrganizationResponse> createOrganization(
            Consumer<CreateOrganizationRequest.Builder> createOrganizationRequest) {
        return createOrganization(CreateOrganizationRequest.builder().applyMutation(createOrganizationRequest).build());
    }

    /**
     * <p>
     * Creates a new WorkMail resource.
     * </p>
     *
     * @param createResourceRequest
     * @return A Java Future containing the result of the CreateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResourceResponse> createResource(CreateResourceRequest createResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new WorkMail resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateResourceRequest#builder()}
     * </p>
     *
     * @param createResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.CreateResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResourceResponse> createResource(Consumer<CreateResourceRequest.Builder> createResourceRequest) {
        return createResource(CreateResourceRequest.builder().applyMutation(createResourceRequest).build());
    }

    /**
     * <p>
     * Creates a user who can be used in WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user who can be used in WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes an access control rule for the specified WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteAccessControlRuleRequest
     * @return A Java Future containing the result of the DeleteAccessControlRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAccessControlRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessControlRuleResponse> deleteAccessControlRule(
            DeleteAccessControlRuleRequest deleteAccessControlRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access control rule for the specified WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessControlRuleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccessControlRuleRequest#builder()}
     * </p>
     *
     * @param deleteAccessControlRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAccessControlRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAccessControlRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessControlRuleResponse> deleteAccessControlRule(
            Consumer<DeleteAccessControlRuleRequest.Builder> deleteAccessControlRuleRequest) {
        return deleteAccessControlRule(DeleteAccessControlRuleRequest.builder().applyMutation(deleteAccessControlRuleRequest)
                .build());
    }

    /**
     * <p>
     * Remove one or more specified aliases from a set of aliases for a given user.
     * </p>
     *
     * @param deleteAliasRequest
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more specified aliases from a set of aliases for a given user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAliasRequest#builder()}
     * </p>
     *
     * @param deleteAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAliasResponse> deleteAlias(Consumer<DeleteAliasRequest.Builder> deleteAliasRequest) {
        return deleteAlias(DeleteAliasRequest.builder().applyMutation(deleteAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     *
     * @param deleteAvailabilityConfigurationRequest
     * @return A Java Future containing the result of the DeleteAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAvailabilityConfigurationResponse> deleteAvailabilityConfiguration(
            DeleteAvailabilityConfigurationRequest deleteAvailabilityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAvailabilityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAvailabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteAvailabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteAvailabilityConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAvailabilityConfigurationResponse> deleteAvailabilityConfiguration(
            Consumer<DeleteAvailabilityConfigurationRequest.Builder> deleteAvailabilityConfigurationRequest) {
        return deleteAvailabilityConfiguration(DeleteAvailabilityConfigurationRequest.builder()
                .applyMutation(deleteAvailabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the email monitoring configuration for a specified organization.
     * </p>
     *
     * @param deleteEmailMonitoringConfigurationRequest
     * @return A Java Future containing the result of the DeleteEmailMonitoringConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEmailMonitoringConfigurationResponse> deleteEmailMonitoringConfiguration(
            DeleteEmailMonitoringConfigurationRequest deleteEmailMonitoringConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the email monitoring configuration for a specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailMonitoringConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEmailMonitoringConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEmailMonitoringConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteEmailMonitoringConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteEmailMonitoringConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEmailMonitoringConfigurationResponse> deleteEmailMonitoringConfiguration(
            Consumer<DeleteEmailMonitoringConfigurationRequest.Builder> deleteEmailMonitoringConfigurationRequest) {
        return deleteEmailMonitoringConfiguration(DeleteEmailMonitoringConfigurationRequest.builder()
                .applyMutation(deleteEmailMonitoringConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a group from WorkMail.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group from WorkMail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an impersonation role for the given WorkMail organization.
     * </p>
     *
     * @param deleteImpersonationRoleRequest
     * @return A Java Future containing the result of the DeleteImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteImpersonationRoleResponse> deleteImpersonationRole(
            DeleteImpersonationRoleRequest deleteImpersonationRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an impersonation role for the given WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImpersonationRoleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteImpersonationRoleRequest#builder()}
     * </p>
     *
     * @param deleteImpersonationRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteImpersonationRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteImpersonationRoleResponse> deleteImpersonationRole(
            Consumer<DeleteImpersonationRoleRequest.Builder> deleteImpersonationRoleRequest) {
        return deleteImpersonationRole(DeleteImpersonationRoleRequest.builder().applyMutation(deleteImpersonationRoleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes permissions granted to a member (user or group).
     * </p>
     *
     * @param deleteMailboxPermissionsRequest
     * @return A Java Future containing the result of the DeleteMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMailboxPermissionsResponse> deleteMailboxPermissions(
            DeleteMailboxPermissionsRequest deleteMailboxPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes permissions granted to a member (user or group).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMailboxPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMailboxPermissionsRequest#builder()}
     * </p>
     *
     * @param deleteMailboxPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMailboxPermissionsResponse> deleteMailboxPermissions(
            Consumer<DeleteMailboxPermissionsRequest.Builder> deleteMailboxPermissionsRequest) {
        return deleteMailboxPermissions(DeleteMailboxPermissionsRequest.builder().applyMutation(deleteMailboxPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends
     * back an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteMobileDeviceAccessOverrideRequest
     * @return A Java Future containing the result of the DeleteMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMobileDeviceAccessOverrideResponse> deleteMobileDeviceAccessOverride(
            DeleteMobileDeviceAccessOverrideRequest deleteMobileDeviceAccessOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends
     * back an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMobileDeviceAccessOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMobileDeviceAccessOverrideRequest#builder()}
     * </p>
     *
     * @param deleteMobileDeviceAccessOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessOverrideRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMobileDeviceAccessOverrideResponse> deleteMobileDeviceAccessOverride(
            Consumer<DeleteMobileDeviceAccessOverrideRequest.Builder> deleteMobileDeviceAccessOverrideRequest) {
        return deleteMobileDeviceAccessOverride(DeleteMobileDeviceAccessOverrideRequest.builder()
                .applyMutation(deleteMobileDeviceAccessOverrideRequest).build());
    }

    /**
     * <p>
     * Deletes a mobile device access rule for the specified WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteMobileDeviceAccessRuleRequest
     * @return A Java Future containing the result of the DeleteMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMobileDeviceAccessRuleResponse> deleteMobileDeviceAccessRule(
            DeleteMobileDeviceAccessRuleRequest deleteMobileDeviceAccessRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a mobile device access rule for the specified WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMobileDeviceAccessRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMobileDeviceAccessRuleRequest#builder()}
     * </p>
     *
     * @param deleteMobileDeviceAccessRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMobileDeviceAccessRuleResponse> deleteMobileDeviceAccessRule(
            Consumer<DeleteMobileDeviceAccessRuleRequest.Builder> deleteMobileDeviceAccessRuleRequest) {
        return deleteMobileDeviceAccessRule(DeleteMobileDeviceAccessRuleRequest.builder()
                .applyMutation(deleteMobileDeviceAccessRuleRequest).build());
    }

    /**
     * <p>
     * Deletes an WorkMail organization and all underlying AWS resources managed by WorkMail as part of the
     * organization. You can choose whether to delete the associated directory. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an
     * organization</a> in the <i>WorkMail Administrator Guide</i>.
     * </p>
     *
     * @param deleteOrganizationRequest
     * @return A Java Future containing the result of the DeleteOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationResponse> deleteOrganization(DeleteOrganizationRequest deleteOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an WorkMail organization and all underlying AWS resources managed by WorkMail as part of the
     * organization. You can choose whether to delete the associated directory. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an
     * organization</a> in the <i>WorkMail Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOrganizationRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteOrganizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteOrganizationResponse> deleteOrganization(
            Consumer<DeleteOrganizationRequest.Builder> deleteOrganizationRequest) {
        return deleteOrganization(DeleteOrganizationRequest.builder().applyMutation(deleteOrganizationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource.
     * </p>
     *
     * @param deleteResourceRequest
     * @return A Java Future containing the result of the DeleteResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourceResponse> deleteResource(DeleteResourceRequest deleteResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteResourceRequest#builder()}
     * </p>
     *
     * @param deleteResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourceResponse> deleteResource(Consumer<DeleteResourceRequest.Builder> deleteResourceRequest) {
        return deleteResource(DeleteResourceRequest.builder().applyMutation(deleteResourceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified retention policy from the specified organization.
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     * @return A Java Future containing the result of the DeleteRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRetentionPolicyResponse> deleteRetentionPolicy(
            DeleteRetentionPolicyRequest deleteRetentionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified retention policy from the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRetentionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRetentionPolicyRequest#builder()}
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRetentionPolicyResponse> deleteRetentionPolicy(
            Consumer<DeleteRetentionPolicyRequest.Builder> deleteRetentionPolicyRequest) {
        return deleteRetentionPolicy(DeleteRetentionPolicyRequest.builder().applyMutation(deleteRetentionPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a user from WorkMail and all subsequent systems. Before you can delete a user, the user state must be
     * <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.
     * </p>
     * <p>
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are
     * permanently removed.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user from WorkMail and all subsequent systems. Before you can delete a user, the user state must be
     * <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.
     * </p>
     * <p>
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are
     * permanently removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Mark a user, group, or resource as no longer used in WorkMail. This action disassociates the mailbox and
     * schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The
     * functionality in the console is <i>Disable</i>.
     * </p>
     *
     * @param deregisterFromWorkMailRequest
     * @return A Java Future containing the result of the DeregisterFromWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeregisterFromWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterFromWorkMailResponse> deregisterFromWorkMail(
            DeregisterFromWorkMailRequest deregisterFromWorkMailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Mark a user, group, or resource as no longer used in WorkMail. This action disassociates the mailbox and
     * schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The
     * functionality in the console is <i>Disable</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterFromWorkMailRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterFromWorkMailRequest#builder()}
     * </p>
     *
     * @param deregisterFromWorkMailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterFromWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeregisterFromWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterFromWorkMailResponse> deregisterFromWorkMail(
            Consumer<DeregisterFromWorkMailRequest.Builder> deregisterFromWorkMailRequest) {
        return deregisterFromWorkMail(DeregisterFromWorkMailRequest.builder().applyMutation(deregisterFromWorkMailRequest)
                .build());
    }

    /**
     * <p>
     * Removes a domain from WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail
     * use. SES keeps the domain because other applications may use it. You must first remove any email address used by
     * WorkMail entities before you remove the domain.
     * </p>
     *
     * @param deregisterMailDomainRequest
     * @return A Java Future containing the result of the DeregisterMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainInUseException The domain you're trying to change is in use by another user or organization
     *         in your account. See the error message for details.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidCustomSesConfigurationException You SES configuration has customizations that WorkMail cannot
     *         save. The error message lists the invalid setting. For examples of invalid settings, refer to <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html"
     *         >CreateReceiptRule</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeregisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterMailDomainResponse> deregisterMailDomain(
            DeregisterMailDomainRequest deregisterMailDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a domain from WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail
     * use. SES keeps the domain because other applications may use it. You must first remove any email address used by
     * WorkMail entities before you remove the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterMailDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterMailDomainRequest#builder()}
     * </p>
     *
     * @param deregisterMailDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DeregisterMailDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainInUseException The domain you're trying to change is in use by another user or organization
     *         in your account. See the error message for details.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidCustomSesConfigurationException You SES configuration has customizations that WorkMail cannot
     *         save. The error message lists the invalid setting. For examples of invalid settings, refer to <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html"
     *         >CreateReceiptRule</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeregisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterMailDomainResponse> deregisterMailDomain(
            Consumer<DeregisterMailDomainRequest.Builder> deregisterMailDomainRequest) {
        return deregisterMailDomain(DeregisterMailDomainRequest.builder().applyMutation(deregisterMailDomainRequest).build());
    }

    /**
     * <p>
     * Describes the current email monitoring configuration for a specified organization.
     * </p>
     *
     * @param describeEmailMonitoringConfigurationRequest
     * @return A Java Future containing the result of the DescribeEmailMonitoringConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEmailMonitoringConfigurationResponse> describeEmailMonitoringConfiguration(
            DescribeEmailMonitoringConfigurationRequest describeEmailMonitoringConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current email monitoring configuration for a specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEmailMonitoringConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEmailMonitoringConfigurationRequest#builder()}
     * </p>
     *
     * @param describeEmailMonitoringConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DescribeEmailMonitoringConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeEmailMonitoringConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEmailMonitoringConfigurationResponse> describeEmailMonitoringConfiguration(
            Consumer<DescribeEmailMonitoringConfigurationRequest.Builder> describeEmailMonitoringConfigurationRequest) {
        return describeEmailMonitoringConfiguration(DescribeEmailMonitoringConfigurationRequest.builder()
                .applyMutation(describeEmailMonitoringConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns basic details about an entity in WorkMail.
     * </p>
     *
     * @param describeEntityRequest
     * @return A Java Future containing the result of the DescribeEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEntityResponse> describeEntity(DescribeEntityRequest describeEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns basic details about an entity in WorkMail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntityRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEntityRequest#builder()}
     * </p>
     *
     * @param describeEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DescribeEntityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEntityResponse> describeEntity(Consumer<DescribeEntityRequest.Builder> describeEntityRequest) {
        return describeEntity(DescribeEntityRequest.builder().applyMutation(describeEntityRequest).build());
    }

    /**
     * <p>
     * Returns the data available for the group.
     * </p>
     *
     * @param describeGroupRequest
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(DescribeGroupRequest describeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data available for the group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupRequest#builder()}
     * </p>
     *
     * @param describeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DescribeGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(Consumer<DescribeGroupRequest.Builder> describeGroupRequest) {
        return describeGroup(DescribeGroupRequest.builder().applyMutation(describeGroupRequest).build());
    }

    /**
     * <p>
     * Lists the settings in a DMARC policy for a specified organization.
     * </p>
     *
     * @param describeInboundDmarcSettingsRequest
     * @return A Java Future containing the result of the DescribeInboundDmarcSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInboundDmarcSettingsResponse> describeInboundDmarcSettings(
            DescribeInboundDmarcSettingsRequest describeInboundDmarcSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the settings in a DMARC policy for a specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInboundDmarcSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInboundDmarcSettingsRequest#builder()}
     * </p>
     *
     * @param describeInboundDmarcSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DescribeInboundDmarcSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeInboundDmarcSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInboundDmarcSettingsResponse> describeInboundDmarcSettings(
            Consumer<DescribeInboundDmarcSettingsRequest.Builder> describeInboundDmarcSettingsRequest) {
        return describeInboundDmarcSettings(DescribeInboundDmarcSettingsRequest.builder()
                .applyMutation(describeInboundDmarcSettingsRequest).build());
    }

    /**
     * <p>
     * Describes the current status of a mailbox export job.
     * </p>
     *
     * @param describeMailboxExportJobRequest
     * @return A Java Future containing the result of the DescribeMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMailboxExportJobResponse> describeMailboxExportJob(
            DescribeMailboxExportJobRequest describeMailboxExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current status of a mailbox export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMailboxExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMailboxExportJobRequest#builder()}
     * </p>
     *
     * @param describeMailboxExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DescribeMailboxExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMailboxExportJobResponse> describeMailboxExportJob(
            Consumer<DescribeMailboxExportJobRequest.Builder> describeMailboxExportJobRequest) {
        return describeMailboxExportJob(DescribeMailboxExportJobRequest.builder().applyMutation(describeMailboxExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Provides more information regarding a given organization based on its identifier.
     * </p>
     *
     * @param describeOrganizationRequest
     * @return A Java Future containing the result of the DescribeOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationResponse> describeOrganization(
            DescribeOrganizationRequest describeOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more information regarding a given organization based on its identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOrganizationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DescribeOrganizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationResponse> describeOrganization(
            Consumer<DescribeOrganizationRequest.Builder> describeOrganizationRequest) {
        return describeOrganization(DescribeOrganizationRequest.builder().applyMutation(describeOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns the data available for the resource.
     * </p>
     *
     * @param describeResourceRequest
     * @return A Java Future containing the result of the DescribeResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeResourceResponse> describeResource(DescribeResourceRequest describeResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data available for the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeResourceRequest#builder()}
     * </p>
     *
     * @param describeResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DescribeResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeResourceResponse> describeResource(
            Consumer<DescribeResourceRequest.Builder> describeResourceRequest) {
        return describeResource(DescribeResourceRequest.builder().applyMutation(describeResourceRequest).build());
    }

    /**
     * <p>
     * Provides information regarding the user.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information regarding the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DescribeUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest) {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Removes a member from the resource's set of delegates.
     * </p>
     *
     * @param disassociateDelegateFromResourceRequest
     * @return A Java Future containing the result of the DisassociateDelegateFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateDelegateFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDelegateFromResourceResponse> disassociateDelegateFromResource(
            DisassociateDelegateFromResourceRequest disassociateDelegateFromResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a member from the resource's set of delegates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDelegateFromResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateDelegateFromResourceRequest#builder()}
     * </p>
     *
     * @param disassociateDelegateFromResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateDelegateFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateDelegateFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDelegateFromResourceResponse> disassociateDelegateFromResource(
            Consumer<DisassociateDelegateFromResourceRequest.Builder> disassociateDelegateFromResourceRequest) {
        return disassociateDelegateFromResource(DisassociateDelegateFromResourceRequest.builder()
                .applyMutation(disassociateDelegateFromResourceRequest).build());
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     *
     * @param disassociateMemberFromGroupRequest
     * @return A Java Future containing the result of the DisassociateMemberFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateMemberFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromGroupResponse> disassociateMemberFromGroup(
            DisassociateMemberFromGroupRequest disassociateMemberFromGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateMemberFromGroupRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateMemberFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateMemberFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateMemberFromGroupResponse> disassociateMemberFromGroup(
            Consumer<DisassociateMemberFromGroupRequest.Builder> disassociateMemberFromGroupRequest) {
        return disassociateMemberFromGroup(DisassociateMemberFromGroupRequest.builder()
                .applyMutation(disassociateMemberFromGroupRequest).build());
    }

    /**
     * <p>
     * Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access
     * protocol action, and user ID or impersonation role ID. You must provide either the user ID or impersonation role
     * ID. Impersonation role ID can only be used with Action EWS.
     * </p>
     *
     * @param getAccessControlEffectRequest
     * @return A Java Future containing the result of the GetAccessControlEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetAccessControlEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetAccessControlEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessControlEffectResponse> getAccessControlEffect(
            GetAccessControlEffectRequest getAccessControlEffectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access
     * protocol action, and user ID or impersonation role ID. You must provide either the user ID or impersonation role
     * ID. Impersonation role ID can only be used with Action EWS.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessControlEffectRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccessControlEffectRequest#builder()}
     * </p>
     *
     * @param getAccessControlEffectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.GetAccessControlEffectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccessControlEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetAccessControlEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetAccessControlEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessControlEffectResponse> getAccessControlEffect(
            Consumer<GetAccessControlEffectRequest.Builder> getAccessControlEffectRequest) {
        return getAccessControlEffect(GetAccessControlEffectRequest.builder().applyMutation(getAccessControlEffectRequest)
                .build());
    }

    /**
     * <p>
     * Gets the default retention policy details for the specified organization.
     * </p>
     *
     * @param getDefaultRetentionPolicyRequest
     * @return A Java Future containing the result of the GetDefaultRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetDefaultRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDefaultRetentionPolicyResponse> getDefaultRetentionPolicy(
            GetDefaultRetentionPolicyRequest getDefaultRetentionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the default retention policy details for the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDefaultRetentionPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetDefaultRetentionPolicyRequest#builder()}
     * </p>
     *
     * @param getDefaultRetentionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetDefaultRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetDefaultRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDefaultRetentionPolicyResponse> getDefaultRetentionPolicy(
            Consumer<GetDefaultRetentionPolicyRequest.Builder> getDefaultRetentionPolicyRequest) {
        return getDefaultRetentionPolicy(GetDefaultRetentionPolicyRequest.builder()
                .applyMutation(getDefaultRetentionPolicyRequest).build());
    }

    /**
     * <p>
     * Gets the impersonation role details for the given WorkMail organization.
     * </p>
     *
     * @param getImpersonationRoleRequest
     * @return A Java Future containing the result of the GetImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetImpersonationRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImpersonationRoleResponse> getImpersonationRole(
            GetImpersonationRoleRequest getImpersonationRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the impersonation role details for the given WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImpersonationRoleRequest.Builder} avoiding the
     * need to create one manually via {@link GetImpersonationRoleRequest#builder()}
     * </p>
     *
     * @param getImpersonationRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.GetImpersonationRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetImpersonationRole" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImpersonationRoleResponse> getImpersonationRole(
            Consumer<GetImpersonationRoleRequest.Builder> getImpersonationRoleRequest) {
        return getImpersonationRole(GetImpersonationRoleRequest.builder().applyMutation(getImpersonationRoleRequest).build());
    }

    /**
     * <p>
     * Tests whether the given impersonation role can impersonate a target user.
     * </p>
     *
     * @param getImpersonationRoleEffectRequest
     * @return A Java Future containing the result of the GetImpersonationRoleEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetImpersonationRoleEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetImpersonationRoleEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetImpersonationRoleEffectResponse> getImpersonationRoleEffect(
            GetImpersonationRoleEffectRequest getImpersonationRoleEffectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests whether the given impersonation role can impersonate a target user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImpersonationRoleEffectRequest.Builder} avoiding
     * the need to create one manually via {@link GetImpersonationRoleEffectRequest#builder()}
     * </p>
     *
     * @param getImpersonationRoleEffectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.GetImpersonationRoleEffectRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetImpersonationRoleEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetImpersonationRoleEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetImpersonationRoleEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetImpersonationRoleEffectResponse> getImpersonationRoleEffect(
            Consumer<GetImpersonationRoleEffectRequest.Builder> getImpersonationRoleEffectRequest) {
        return getImpersonationRoleEffect(GetImpersonationRoleEffectRequest.builder()
                .applyMutation(getImpersonationRoleEffectRequest).build());
    }

    /**
     * <p>
     * Gets details for a mail domain, including domain records required to configure your domain with recommended
     * security.
     * </p>
     *
     * @param getMailDomainRequest
     * @return A Java Future containing the result of the GetMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMailDomainResponse> getMailDomain(GetMailDomainRequest getMailDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details for a mail domain, including domain records required to configure your domain with recommended
     * security.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMailDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetMailDomainRequest#builder()}
     * </p>
     *
     * @param getMailDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.GetMailDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMailDomainResponse> getMailDomain(Consumer<GetMailDomainRequest.Builder> getMailDomainRequest) {
        return getMailDomain(GetMailDomainRequest.builder().applyMutation(getMailDomainRequest).build());
    }

    /**
     * <p>
     * Requests a user's mailbox details for a specified organization and user.
     * </p>
     *
     * @param getMailboxDetailsRequest
     * @return A Java Future containing the result of the GetMailboxDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMailboxDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMailboxDetailsResponse> getMailboxDetails(GetMailboxDetailsRequest getMailboxDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a user's mailbox details for a specified organization and user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMailboxDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link GetMailboxDetailsRequest#builder()}
     * </p>
     *
     * @param getMailboxDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.GetMailboxDetailsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMailboxDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMailboxDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMailboxDetailsResponse> getMailboxDetails(
            Consumer<GetMailboxDetailsRequest.Builder> getMailboxDetailsRequest) {
        return getMailboxDetails(GetMailboxDetailsRequest.builder().applyMutation(getMailboxDetailsRequest).build());
    }

    /**
     * <p>
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use
     * this method to test the effects of the current set of mobile device access rules for the WorkMail organization
     * for a particular user's attributes.
     * </p>
     *
     * @param getMobileDeviceAccessEffectRequest
     * @return A Java Future containing the result of the GetMobileDeviceAccessEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMobileDeviceAccessEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMobileDeviceAccessEffectResponse> getMobileDeviceAccessEffect(
            GetMobileDeviceAccessEffectRequest getMobileDeviceAccessEffectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use
     * this method to test the effects of the current set of mobile device access rules for the WorkMail organization
     * for a particular user's attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMobileDeviceAccessEffectRequest.Builder}
     * avoiding the need to create one manually via {@link GetMobileDeviceAccessEffectRequest#builder()}
     * </p>
     *
     * @param getMobileDeviceAccessEffectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessEffectRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetMobileDeviceAccessEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMobileDeviceAccessEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMobileDeviceAccessEffectResponse> getMobileDeviceAccessEffect(
            Consumer<GetMobileDeviceAccessEffectRequest.Builder> getMobileDeviceAccessEffectRequest) {
        return getMobileDeviceAccessEffect(GetMobileDeviceAccessEffectRequest.builder()
                .applyMutation(getMobileDeviceAccessEffectRequest).build());
    }

    /**
     * <p>
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     *
     * @param getMobileDeviceAccessOverrideRequest
     * @return A Java Future containing the result of the GetMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMobileDeviceAccessOverrideResponse> getMobileDeviceAccessOverride(
            GetMobileDeviceAccessOverrideRequest getMobileDeviceAccessOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMobileDeviceAccessOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link GetMobileDeviceAccessOverrideRequest#builder()}
     * </p>
     *
     * @param getMobileDeviceAccessOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessOverrideRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMobileDeviceAccessOverrideResponse> getMobileDeviceAccessOverride(
            Consumer<GetMobileDeviceAccessOverrideRequest.Builder> getMobileDeviceAccessOverrideRequest) {
        return getMobileDeviceAccessOverride(GetMobileDeviceAccessOverrideRequest.builder()
                .applyMutation(getMobileDeviceAccessOverrideRequest).build());
    }

    /**
     * <p>
     * Lists the access control rules for the specified organization.
     * </p>
     *
     * @param listAccessControlRulesRequest
     * @return A Java Future containing the result of the ListAccessControlRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAccessControlRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessControlRulesResponse> listAccessControlRules(
            ListAccessControlRulesRequest listAccessControlRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the access control rules for the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessControlRulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessControlRulesRequest#builder()}
     * </p>
     *
     * @param listAccessControlRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListAccessControlRulesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAccessControlRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAccessControlRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessControlRulesResponse> listAccessControlRules(
            Consumer<ListAccessControlRulesRequest.Builder> listAccessControlRulesRequest) {
        return listAccessControlRules(ListAccessControlRulesRequest.builder().applyMutation(listAccessControlRulesRequest)
                .build());
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     *
     * @param listAliasesRequest
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListAliasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAliasesResponse> listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest) {
        return listAliases(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesPublisher listAliasesPaginator(ListAliasesRequest listAliasesRequest) {
        return new ListAliasesPublisher(this, listAliasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListAliasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesPublisher listAliasesPaginator(Consumer<ListAliasesRequest.Builder> listAliasesRequest) {
        return listAliasesPaginator(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * List all the <code>AvailabilityConfiguration</code>'s for the given WorkMail organization.
     * </p>
     *
     * @param listAvailabilityConfigurationsRequest
     * @return A Java Future containing the result of the ListAvailabilityConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAvailabilityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAvailabilityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailabilityConfigurationsResponse> listAvailabilityConfigurations(
            ListAvailabilityConfigurationsRequest listAvailabilityConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the <code>AvailabilityConfiguration</code>'s for the given WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailabilityConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailabilityConfigurationsRequest#builder()}
     * </p>
     *
     * @param listAvailabilityConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAvailabilityConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAvailabilityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAvailabilityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailabilityConfigurationsResponse> listAvailabilityConfigurations(
            Consumer<ListAvailabilityConfigurationsRequest.Builder> listAvailabilityConfigurationsRequest) {
        return listAvailabilityConfigurations(ListAvailabilityConfigurationsRequest.builder()
                .applyMutation(listAvailabilityConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailabilityConfigurations(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsPublisher publisher = client.listAvailabilityConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsPublisher publisher = client.listAvailabilityConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailabilityConfigurations(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAvailabilityConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAvailabilityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAvailabilityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailabilityConfigurationsPublisher listAvailabilityConfigurationsPaginator(
            ListAvailabilityConfigurationsRequest listAvailabilityConfigurationsRequest) {
        return new ListAvailabilityConfigurationsPublisher(this, listAvailabilityConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailabilityConfigurations(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsPublisher publisher = client.listAvailabilityConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsPublisher publisher = client.listAvailabilityConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailabilityConfigurations(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailabilityConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailabilityConfigurationsRequest#builder()}
     * </p>
     *
     * @param listAvailabilityConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAvailabilityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAvailabilityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailabilityConfigurationsPublisher listAvailabilityConfigurationsPaginator(
            Consumer<ListAvailabilityConfigurationsRequest.Builder> listAvailabilityConfigurationsRequest) {
        return listAvailabilityConfigurationsPaginator(ListAvailabilityConfigurationsRequest.builder()
                .applyMutation(listAvailabilityConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A Java Future containing the result of the ListGroupMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupMembersResponse> listGroupMembers(ListGroupMembersRequest listGroupMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupMembersRequest#builder()}
     * </p>
     *
     * @param listGroupMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGroupMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupMembersResponse> listGroupMembers(
            Consumer<ListGroupMembersRequest.Builder> listGroupMembersRequest) {
        return listGroupMembers(ListGroupMembersRequest.builder().applyMutation(listGroupMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation.</b>
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupMembersPublisher listGroupMembersPaginator(ListGroupMembersRequest listGroupMembersRequest) {
        return new ListGroupMembersPublisher(this, listGroupMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupMembersRequest#builder()}
     * </p>
     *
     * @param listGroupMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupMembersPublisher listGroupMembersPaginator(Consumer<ListGroupMembersRequest.Builder> listGroupMembersRequest) {
        return listGroupMembersPaginator(ListGroupMembersRequest.builder().applyMutation(listGroupMembersRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Returns all the groups to which an entity belongs.
     * </p>
     *
     * @param listGroupsForEntityRequest
     * @return A Java Future containing the result of the ListGroupsForEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupsForEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupsForEntity" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGroupsForEntityResponse> listGroupsForEntity(
            ListGroupsForEntityRequest listGroupsForEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all the groups to which an entity belongs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsForEntityRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupsForEntityRequest#builder()}
     * </p>
     *
     * @param listGroupsForEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGroupsForEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupsForEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupsForEntity" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGroupsForEntityResponse> listGroupsForEntity(
            Consumer<ListGroupsForEntityRequest.Builder> listGroupsForEntityRequest) {
        return listGroupsForEntity(ListGroupsForEntityRequest.builder().applyMutation(listGroupsForEntityRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupsForEntity(software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsForEntityPublisher publisher = client.listGroupsForEntityPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsForEntityPublisher publisher = client.listGroupsForEntityPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupsForEntityResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupsForEntityResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsForEntity(software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroupsForEntityRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupsForEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupsForEntity" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGroupsForEntityPublisher listGroupsForEntityPaginator(ListGroupsForEntityRequest listGroupsForEntityRequest) {
        return new ListGroupsForEntityPublisher(this, listGroupsForEntityRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroupsForEntity(software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsForEntityPublisher publisher = client.listGroupsForEntityPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsForEntityPublisher publisher = client.listGroupsForEntityPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupsForEntityResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupsForEntityResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsForEntity(software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsForEntityRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupsForEntityRequest#builder()}
     * </p>
     *
     * @param listGroupsForEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupsForEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupsForEntity" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGroupsForEntityPublisher listGroupsForEntityPaginator(
            Consumer<ListGroupsForEntityRequest.Builder> listGroupsForEntityRequest) {
        return listGroupsForEntityPaginator(ListGroupsForEntityRequest.builder().applyMutation(listGroupsForEntityRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(ListGroupsRequest listGroupsRequest) {
        return new ListGroupsPublisher(this, listGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all the impersonation roles for the given WorkMail organization.
     * </p>
     *
     * @param listImpersonationRolesRequest
     * @return A Java Future containing the result of the ListImpersonationRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListImpersonationRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListImpersonationRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImpersonationRolesResponse> listImpersonationRoles(
            ListImpersonationRolesRequest listImpersonationRolesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the impersonation roles for the given WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImpersonationRolesRequest.Builder} avoiding the
     * need to create one manually via {@link ListImpersonationRolesRequest#builder()}
     * </p>
     *
     * @param listImpersonationRolesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListImpersonationRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListImpersonationRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListImpersonationRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListImpersonationRolesResponse> listImpersonationRoles(
            Consumer<ListImpersonationRolesRequest.Builder> listImpersonationRolesRequest) {
        return listImpersonationRoles(ListImpersonationRolesRequest.builder().applyMutation(listImpersonationRolesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImpersonationRoles(software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListImpersonationRolesPublisher publisher = client.listImpersonationRolesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListImpersonationRolesPublisher publisher = client.listImpersonationRolesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListImpersonationRolesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListImpersonationRolesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImpersonationRoles(software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImpersonationRolesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListImpersonationRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListImpersonationRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImpersonationRolesPublisher listImpersonationRolesPaginator(
            ListImpersonationRolesRequest listImpersonationRolesRequest) {
        return new ListImpersonationRolesPublisher(this, listImpersonationRolesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImpersonationRoles(software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListImpersonationRolesPublisher publisher = client.listImpersonationRolesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListImpersonationRolesPublisher publisher = client.listImpersonationRolesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListImpersonationRolesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListImpersonationRolesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImpersonationRoles(software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImpersonationRolesRequest.Builder} avoiding the
     * need to create one manually via {@link ListImpersonationRolesRequest#builder()}
     * </p>
     *
     * @param listImpersonationRolesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListImpersonationRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListImpersonationRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListImpersonationRolesPublisher listImpersonationRolesPaginator(
            Consumer<ListImpersonationRolesRequest.Builder> listImpersonationRolesRequest) {
        return listImpersonationRolesPaginator(ListImpersonationRolesRequest.builder()
                .applyMutation(listImpersonationRolesRequest).build());
    }

    /**
     * <p>
     * Lists the mail domains in a given WorkMail organization.
     * </p>
     *
     * @param listMailDomainsRequest
     * @return A Java Future containing the result of the ListMailDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMailDomainsResponse> listMailDomains(ListMailDomainsRequest listMailDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mail domains in a given WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailDomainsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMailDomainsRequest#builder()}
     * </p>
     *
     * @param listMailDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMailDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMailDomainsResponse> listMailDomains(
            Consumer<ListMailDomainsRequest.Builder> listMailDomainsRequest) {
        return listMailDomains(ListMailDomainsRequest.builder().applyMutation(listMailDomainsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsPublisher publisher = client.listMailDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsPublisher publisher = client.listMailDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listMailDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMailDomainsPublisher listMailDomainsPaginator(ListMailDomainsRequest listMailDomainsRequest) {
        return new ListMailDomainsPublisher(this, listMailDomainsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsPublisher publisher = client.listMailDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsPublisher publisher = client.listMailDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailDomainsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMailDomainsRequest#builder()}
     * </p>
     *
     * @param listMailDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMailDomainsPublisher listMailDomainsPaginator(Consumer<ListMailDomainsRequest.Builder> listMailDomainsRequest) {
        return listMailDomainsPaginator(ListMailDomainsRequest.builder().applyMutation(listMailDomainsRequest).build());
    }

    /**
     * <p>
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     * </p>
     *
     * @param listMailboxExportJobsRequest
     * @return A Java Future containing the result of the ListMailboxExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMailboxExportJobsResponse> listMailboxExportJobs(
            ListMailboxExportJobsRequest listMailboxExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailboxExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMailboxExportJobsRequest#builder()}
     * </p>
     *
     * @param listMailboxExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMailboxExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMailboxExportJobsResponse> listMailboxExportJobs(
            Consumer<ListMailboxExportJobsRequest.Builder> listMailboxExportJobsRequest) {
        return listMailboxExportJobs(ListMailboxExportJobsRequest.builder().applyMutation(listMailboxExportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsPublisher publisher = client.listMailboxExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsPublisher publisher = client.listMailboxExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMailboxExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxExportJobsPublisher listMailboxExportJobsPaginator(
            ListMailboxExportJobsRequest listMailboxExportJobsRequest) {
        return new ListMailboxExportJobsPublisher(this, listMailboxExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsPublisher publisher = client.listMailboxExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsPublisher publisher = client.listMailboxExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailboxExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMailboxExportJobsRequest#builder()}
     * </p>
     *
     * @param listMailboxExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxExportJobsPublisher listMailboxExportJobsPaginator(
            Consumer<ListMailboxExportJobsRequest.Builder> listMailboxExportJobsRequest) {
        return listMailboxExportJobsPaginator(ListMailboxExportJobsRequest.builder().applyMutation(listMailboxExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return A Java Future containing the result of the ListMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMailboxPermissionsResponse> listMailboxPermissions(
            ListMailboxPermissionsRequest listMailboxPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailboxPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMailboxPermissionsRequest#builder()}
     * </p>
     *
     * @param listMailboxPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMailboxPermissionsResponse> listMailboxPermissions(
            Consumer<ListMailboxPermissionsRequest.Builder> listMailboxPermissionsRequest) {
        return listMailboxPermissions(ListMailboxPermissionsRequest.builder().applyMutation(listMailboxPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher publisher = client.listMailboxPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher publisher = client.listMailboxPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxPermissionsPublisher listMailboxPermissionsPaginator(
            ListMailboxPermissionsRequest listMailboxPermissionsRequest) {
        return new ListMailboxPermissionsPublisher(this, listMailboxPermissionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher publisher = client.listMailboxPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher publisher = client.listMailboxPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailboxPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMailboxPermissionsRequest#builder()}
     * </p>
     *
     * @param listMailboxPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxPermissionsPublisher listMailboxPermissionsPaginator(
            Consumer<ListMailboxPermissionsRequest.Builder> listMailboxPermissionsRequest) {
        return listMailboxPermissionsPaginator(ListMailboxPermissionsRequest.builder()
                .applyMutation(listMailboxPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     * @return A Java Future containing the result of the ListMobileDeviceAccessOverrides operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMobileDeviceAccessOverridesResponse> listMobileDeviceAccessOverrides(
            ListMobileDeviceAccessOverridesRequest listMobileDeviceAccessOverridesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMobileDeviceAccessOverridesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMobileDeviceAccessOverridesRequest#builder()}
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMobileDeviceAccessOverrides operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMobileDeviceAccessOverridesResponse> listMobileDeviceAccessOverrides(
            Consumer<ListMobileDeviceAccessOverridesRequest.Builder> listMobileDeviceAccessOverridesRequest) {
        return listMobileDeviceAccessOverrides(ListMobileDeviceAccessOverridesRequest.builder()
                .applyMutation(listMobileDeviceAccessOverridesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesPublisher publisher = client.listMobileDeviceAccessOverridesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesPublisher publisher = client.listMobileDeviceAccessOverridesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMobileDeviceAccessOverridesPublisher listMobileDeviceAccessOverridesPaginator(
            ListMobileDeviceAccessOverridesRequest listMobileDeviceAccessOverridesRequest) {
        return new ListMobileDeviceAccessOverridesPublisher(this, listMobileDeviceAccessOverridesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesPublisher publisher = client.listMobileDeviceAccessOverridesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesPublisher publisher = client.listMobileDeviceAccessOverridesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMobileDeviceAccessOverridesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMobileDeviceAccessOverridesRequest#builder()}
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMobileDeviceAccessOverridesPublisher listMobileDeviceAccessOverridesPaginator(
            Consumer<ListMobileDeviceAccessOverridesRequest.Builder> listMobileDeviceAccessOverridesRequest) {
        return listMobileDeviceAccessOverridesPaginator(ListMobileDeviceAccessOverridesRequest.builder()
                .applyMutation(listMobileDeviceAccessOverridesRequest).build());
    }

    /**
     * <p>
     * Lists the mobile device access rules for the specified WorkMail organization.
     * </p>
     *
     * @param listMobileDeviceAccessRulesRequest
     * @return A Java Future containing the result of the ListMobileDeviceAccessRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMobileDeviceAccessRulesResponse> listMobileDeviceAccessRules(
            ListMobileDeviceAccessRulesRequest listMobileDeviceAccessRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mobile device access rules for the specified WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMobileDeviceAccessRulesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMobileDeviceAccessRulesRequest#builder()}
     * </p>
     *
     * @param listMobileDeviceAccessRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessRulesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMobileDeviceAccessRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMobileDeviceAccessRulesResponse> listMobileDeviceAccessRules(
            Consumer<ListMobileDeviceAccessRulesRequest.Builder> listMobileDeviceAccessRulesRequest) {
        return listMobileDeviceAccessRules(ListMobileDeviceAccessRulesRequest.builder()
                .applyMutation(listMobileDeviceAccessRulesRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     *
     * @param listOrganizationsRequest
     * @return A Java Future containing the result of the ListOrganizations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOrganizationsResponse> listOrganizations(ListOrganizationsRequest listOrganizationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListOrganizationsRequest#builder()}
     * </p>
     *
     * @param listOrganizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOrganizations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOrganizationsResponse> listOrganizations(
            Consumer<ListOrganizationsRequest.Builder> listOrganizationsRequest) {
        return listOrganizations(ListOrganizationsRequest.builder().applyMutation(listOrganizationsRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     *
     * @return A Java Future containing the result of the ListOrganizations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOrganizationsResponse> listOrganizations() {
        return listOrganizations(ListOrganizationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrganizationsPublisher listOrganizationsPaginator() {
        return listOrganizationsPaginator(ListOrganizationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrganizationsPublisher listOrganizationsPaginator(ListOrganizationsRequest listOrganizationsRequest) {
        return new ListOrganizationsPublisher(this, listOrganizationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListOrganizationsRequest#builder()}
     * </p>
     *
     * @param listOrganizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrganizationsPublisher listOrganizationsPaginator(
            Consumer<ListOrganizationsRequest.Builder> listOrganizationsRequest) {
        return listOrganizationsPaginator(ListOrganizationsRequest.builder().applyMutation(listOrganizationsRequest).build());
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return A Java Future containing the result of the ListResourceDelegates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceDelegatesResponse> listResourceDelegates(
            ListResourceDelegatesRequest listResourceDelegatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceDelegatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceDelegatesRequest#builder()}
     * </p>
     *
     * @param listResourceDelegatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResourceDelegates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceDelegatesResponse> listResourceDelegates(
            Consumer<ListResourceDelegatesRequest.Builder> listResourceDelegatesRequest) {
        return listResourceDelegates(ListResourceDelegatesRequest.builder().applyMutation(listResourceDelegatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher publisher = client.listResourceDelegatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher publisher = client.listResourceDelegatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDelegatesPublisher listResourceDelegatesPaginator(
            ListResourceDelegatesRequest listResourceDelegatesRequest) {
        return new ListResourceDelegatesPublisher(this, listResourceDelegatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher publisher = client.listResourceDelegatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher publisher = client.listResourceDelegatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceDelegatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceDelegatesRequest#builder()}
     * </p>
     *
     * @param listResourceDelegatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDelegatesPublisher listResourceDelegatesPaginator(
            Consumer<ListResourceDelegatesRequest.Builder> listResourceDelegatesRequest) {
        return listResourceDelegatesPaginator(ListResourceDelegatesRequest.builder().applyMutation(listResourceDelegatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     *
     * @param listResourcesRequest
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListResourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourcesResponse> listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest) {
        return listResources(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesPublisher listResourcesPaginator(ListResourcesRequest listResourcesRequest) {
        return new ListResourcesPublisher(this, listResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListResourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesPublisher listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest) {
        return listResourcesPaginator(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the tags applied to an WorkMail organization resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags applied to an WorkMail organization resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(ListUsersRequest listUsersRequest) {
        return new ListUsersPublisher(this, listUsersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ListUsersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Adds a new access control rule for the specified organization. The rule allows or denies access to the
     * organization for the specified IPv4 addresses, access protocol actions, user IDs and impersonation IDs. Adding a
     * new rule with the same name as an existing rule replaces the older rule.
     * </p>
     *
     * @param putAccessControlRuleRequest
     * @return A Java Future containing the result of the PutAccessControlRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutAccessControlRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAccessControlRuleResponse> putAccessControlRule(
            PutAccessControlRuleRequest putAccessControlRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new access control rule for the specified organization. The rule allows or denies access to the
     * organization for the specified IPv4 addresses, access protocol actions, user IDs and impersonation IDs. Adding a
     * new rule with the same name as an existing rule replaces the older rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccessControlRuleRequest.Builder} avoiding the
     * need to create one manually via {@link PutAccessControlRuleRequest#builder()}
     * </p>
     *
     * @param putAccessControlRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.PutAccessControlRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutAccessControlRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutAccessControlRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAccessControlRuleResponse> putAccessControlRule(
            Consumer<PutAccessControlRuleRequest.Builder> putAccessControlRuleRequest) {
        return putAccessControlRule(PutAccessControlRuleRequest.builder().applyMutation(putAccessControlRuleRequest).build());
    }

    /**
     * <p>
     * Creates or updates the email monitoring configuration for a specified organization.
     * </p>
     *
     * @param putEmailMonitoringConfigurationRequest
     * @return A Java Future containing the result of the PutEmailMonitoringConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailMonitoringConfigurationResponse> putEmailMonitoringConfiguration(
            PutEmailMonitoringConfigurationRequest putEmailMonitoringConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the email monitoring configuration for a specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailMonitoringConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailMonitoringConfigurationRequest#builder()}
     * </p>
     *
     * @param putEmailMonitoringConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.PutEmailMonitoringConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutEmailMonitoringConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailMonitoringConfigurationResponse> putEmailMonitoringConfiguration(
            Consumer<PutEmailMonitoringConfigurationRequest.Builder> putEmailMonitoringConfigurationRequest) {
        return putEmailMonitoringConfiguration(PutEmailMonitoringConfigurationRequest.builder()
                .applyMutation(putEmailMonitoringConfigurationRequest).build());
    }

    /**
     * <p>
     * Enables or disables a DMARC policy for a given organization.
     * </p>
     *
     * @param putInboundDmarcSettingsRequest
     * @return A Java Future containing the result of the PutInboundDmarcSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInboundDmarcSettingsResponse> putInboundDmarcSettings(
            PutInboundDmarcSettingsRequest putInboundDmarcSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables a DMARC policy for a given organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInboundDmarcSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link PutInboundDmarcSettingsRequest#builder()}
     * </p>
     *
     * @param putInboundDmarcSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.PutInboundDmarcSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutInboundDmarcSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInboundDmarcSettingsResponse> putInboundDmarcSettings(
            Consumer<PutInboundDmarcSettingsRequest.Builder> putInboundDmarcSettingsRequest) {
        return putInboundDmarcSettings(PutInboundDmarcSettingsRequest.builder().applyMutation(putInboundDmarcSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     * </p>
     *
     * @param putMailboxPermissionsRequest
     * @return A Java Future containing the result of the PutMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMailboxPermissionsResponse> putMailboxPermissions(
            PutMailboxPermissionsRequest putMailboxPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMailboxPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link PutMailboxPermissionsRequest#builder()}
     * </p>
     *
     * @param putMailboxPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMailboxPermissionsResponse> putMailboxPermissions(
            Consumer<PutMailboxPermissionsRequest.Builder> putMailboxPermissionsRequest) {
        return putMailboxPermissions(PutMailboxPermissionsRequest.builder().applyMutation(putMailboxPermissionsRequest).build());
    }

    /**
     * <p>
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     *
     * @param putMobileDeviceAccessOverrideRequest
     * @return A Java Future containing the result of the PutMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMobileDeviceAccessOverrideResponse> putMobileDeviceAccessOverride(
            PutMobileDeviceAccessOverrideRequest putMobileDeviceAccessOverrideRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMobileDeviceAccessOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link PutMobileDeviceAccessOverrideRequest#builder()}
     * </p>
     *
     * @param putMobileDeviceAccessOverrideRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.PutMobileDeviceAccessOverrideRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMobileDeviceAccessOverrideResponse> putMobileDeviceAccessOverride(
            Consumer<PutMobileDeviceAccessOverrideRequest.Builder> putMobileDeviceAccessOverrideRequest) {
        return putMobileDeviceAccessOverride(PutMobileDeviceAccessOverrideRequest.builder()
                .applyMutation(putMobileDeviceAccessOverrideRequest).build());
    }

    /**
     * <p>
     * Puts a retention policy to the specified organization.
     * </p>
     *
     * @param putRetentionPolicyRequest
     * @return A Java Future containing the result of the PutRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutRetentionPolicyResponse> putRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts a retention policy to the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRetentionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutRetentionPolicyRequest#builder()}
     * </p>
     *
     * @param putRetentionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.PutRetentionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutRetentionPolicyResponse> putRetentionPolicy(
            Consumer<PutRetentionPolicyRequest.Builder> putRetentionPolicyRequest) {
        return putRetentionPolicy(PutRetentionPolicyRequest.builder().applyMutation(putRetentionPolicyRequest).build());
    }

    /**
     * <p>
     * Registers a new domain in WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for
     * this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use the
     * specified domain for sending your users' emails.
     * </p>
     *
     * @param registerMailDomainRequest
     * @return A Java Future containing the result of the RegisterMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainInUseException The domain you're trying to change is in use by another user or organization
     *         in your account. See the error message for details.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.RegisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterMailDomainResponse> registerMailDomain(RegisterMailDomainRequest registerMailDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a new domain in WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for
     * this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use the
     * specified domain for sending your users' emails.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterMailDomainRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterMailDomainRequest#builder()}
     * </p>
     *
     * @param registerMailDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.RegisterMailDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainInUseException The domain you're trying to change is in use by another user or organization
     *         in your account. See the error message for details.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.RegisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterMailDomainResponse> registerMailDomain(
            Consumer<RegisterMailDomainRequest.Builder> registerMailDomainRequest) {
        return registerMailDomain(RegisterMailDomainRequest.builder().applyMutation(registerMailDomainRequest).build());
    }

    /**
     * <p>
     * Registers an existing and disabled user, group, or resource for WorkMail use by associating a mailbox and
     * calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user,
     * group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a
     * href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this
     * operation is <i>Enable</i>.
     * </p>
     * <p>
     * Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your
     * directory. For more information, see <a>DeregisterFromWorkMail</a>.
     * </p>
     *
     * @param registerToWorkMailRequest
     * @return A Java Future containing the result of the RegisterToWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>EntityAlreadyRegisteredException The user, group, or resource that you're trying to register is
     *         already registered.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.RegisterToWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterToWorkMailResponse> registerToWorkMail(RegisterToWorkMailRequest registerToWorkMailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an existing and disabled user, group, or resource for WorkMail use by associating a mailbox and
     * calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user,
     * group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a
     * href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this
     * operation is <i>Enable</i>.
     * </p>
     * <p>
     * Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your
     * directory. For more information, see <a>DeregisterFromWorkMail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterToWorkMailRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterToWorkMailRequest#builder()}
     * </p>
     *
     * @param registerToWorkMailRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.RegisterToWorkMailRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterToWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>EntityAlreadyRegisteredException The user, group, or resource that you're trying to register is
     *         already registered.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.RegisterToWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterToWorkMailResponse> registerToWorkMail(
            Consumer<RegisterToWorkMailRequest.Builder> registerToWorkMailRequest) {
        return registerToWorkMail(RegisterToWorkMailRequest.builder().applyMutation(registerToWorkMailRequest).build());
    }

    /**
     * <p>
     * Allows the administrator to reset the password for a user.
     * </p>
     *
     * @param resetPasswordRequest
     * @return A Java Future containing the result of the ResetPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ResetPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResetPasswordResponse> resetPassword(ResetPasswordRequest resetPasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the administrator to reset the password for a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetPasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ResetPasswordRequest#builder()}
     * </p>
     *
     * @param resetPasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.ResetPasswordRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ResetPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ResetPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResetPasswordResponse> resetPassword(Consumer<ResetPasswordRequest.Builder> resetPasswordRequest) {
        return resetPassword(ResetPasswordRequest.builder().applyMutation(resetPasswordRequest).build());
    }

    /**
     * <p>
     * Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to
     * the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content</a> in
     * the <i>WorkMail Administrator Guide</i>.
     * </p>
     *
     * @param startMailboxExportJobRequest
     * @return A Java Future containing the result of the StartMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.StartMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/StartMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMailboxExportJobResponse> startMailboxExportJob(
            StartMailboxExportJobRequest startMailboxExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to
     * the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content</a> in
     * the <i>WorkMail Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMailboxExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartMailboxExportJobRequest#builder()}
     * </p>
     *
     * @param startMailboxExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.StartMailboxExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.StartMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/StartMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMailboxExportJobResponse> startMailboxExportJob(
            Consumer<StartMailboxExportJobRequest.Builder> startMailboxExportJobRequest) {
        return startMailboxExportJob(StartMailboxExportJobRequest.builder().applyMutation(startMailboxExportJobRequest).build());
    }

    /**
     * <p>
     * Applies the specified tags to the specified WorkMailorganization resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>TooManyTagsException The resource can have up to 50 user-applied tags.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies the specified tags to the specified WorkMailorganization resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>TooManyTagsException The resource can have up to 50 user-applied tags.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided
     * credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked
     * and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done
     * without providing either a <code>SourceArn</code> or <code>SourceAccount</code> header.
     * </p>
     * <note>
     * <p>
     * The request must contain either one provider definition (<code>EwsProvider</code> or <code>LambdaProvider</code>)
     * or the <code>DomainName</code> parameter. If the <code>DomainName</code> parameter is provided, the configuration
     * stored under the <code>DomainName</code> will be tested.
     * </p>
     * </note>
     *
     * @param testAvailabilityConfigurationRequest
     * @return A Java Future containing the result of the TestAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.TestAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TestAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestAvailabilityConfigurationResponse> testAvailabilityConfiguration(
            TestAvailabilityConfigurationRequest testAvailabilityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided
     * credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked
     * and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done
     * without providing either a <code>SourceArn</code> or <code>SourceAccount</code> header.
     * </p>
     * <note>
     * <p>
     * The request must contain either one provider definition (<code>EwsProvider</code> or <code>LambdaProvider</code>)
     * or the <code>DomainName</code> parameter. If the <code>DomainName</code> parameter is provided, the configuration
     * stored under the <code>DomainName</code> will be tested.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestAvailabilityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link TestAvailabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param testAvailabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.TestAvailabilityConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the TestAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.TestAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TestAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestAvailabilityConfigurationResponse> testAvailabilityConfiguration(
            Consumer<TestAvailabilityConfigurationRequest.Builder> testAvailabilityConfigurationRequest) {
        return testAvailabilityConfiguration(TestAvailabilityConfigurationRequest.builder()
                .applyMutation(testAvailabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Untags the specified tags from the specified WorkMail organization resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags the specified tags from the specified WorkMail organization resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     *
     * @param updateAvailabilityConfigurationRequest
     * @return A Java Future containing the result of the UpdateAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAvailabilityConfigurationResponse> updateAvailabilityConfiguration(
            UpdateAvailabilityConfigurationRequest updateAvailabilityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAvailabilityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAvailabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param updateAvailabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UpdateAvailabilityConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAvailabilityConfigurationResponse> updateAvailabilityConfiguration(
            Consumer<UpdateAvailabilityConfigurationRequest.Builder> updateAvailabilityConfigurationRequest) {
        return updateAvailabilityConfiguration(UpdateAvailabilityConfigurationRequest.builder()
                .applyMutation(updateAvailabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console
     * to suggest an email address when enabling a mail user. You can only have one default domain.
     * </p>
     *
     * @param updateDefaultMailDomainRequest
     * @return A Java Future containing the result of the UpdateDefaultMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateDefaultMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateDefaultMailDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDefaultMailDomainResponse> updateDefaultMailDomain(
            UpdateDefaultMailDomainRequest updateDefaultMailDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console
     * to suggest an email address when enabling a mail user. You can only have one default domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDefaultMailDomainRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDefaultMailDomainRequest#builder()}
     * </p>
     *
     * @param updateDefaultMailDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UpdateDefaultMailDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDefaultMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateDefaultMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateDefaultMailDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDefaultMailDomainResponse> updateDefaultMailDomain(
            Consumer<UpdateDefaultMailDomainRequest.Builder> updateDefaultMailDomainRequest) {
        return updateDefaultMailDomain(UpdateDefaultMailDomainRequest.builder().applyMutation(updateDefaultMailDomainRequest)
                .build());
    }

    /**
     * <p>
     * Updates attibutes in a group.
     * </p>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates attibutes in a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UpdateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates an impersonation role for the given WorkMail organization.
     * </p>
     *
     * @param updateImpersonationRoleRequest
     * @return A Java Future containing the result of the UpdateImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateImpersonationRoleResponse> updateImpersonationRole(
            UpdateImpersonationRoleRequest updateImpersonationRoleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an impersonation role for the given WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateImpersonationRoleRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateImpersonationRoleRequest#builder()}
     * </p>
     *
     * @param updateImpersonationRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UpdateImpersonationRoleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateImpersonationRoleResponse> updateImpersonationRole(
            Consumer<UpdateImpersonationRoleRequest.Builder> updateImpersonationRoleRequest) {
        return updateImpersonationRole(UpdateImpersonationRoleRequest.builder().applyMutation(updateImpersonationRoleRequest)
                .build());
    }

    /**
     * <p>
     * Updates a user's current mailbox quota for a specified organization and user.
     * </p>
     *
     * @param updateMailboxQuotaRequest
     * @return A Java Future containing the result of the UpdateMailboxQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateMailboxQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMailboxQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateMailboxQuotaResponse> updateMailboxQuota(UpdateMailboxQuotaRequest updateMailboxQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a user's current mailbox quota for a specified organization and user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMailboxQuotaRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMailboxQuotaRequest#builder()}
     * </p>
     *
     * @param updateMailboxQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMailboxQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateMailboxQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMailboxQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateMailboxQuotaResponse> updateMailboxQuota(
            Consumer<UpdateMailboxQuotaRequest.Builder> updateMailboxQuotaRequest) {
        return updateMailboxQuota(UpdateMailboxQuotaRequest.builder().applyMutation(updateMailboxQuotaRequest).build());
    }

    /**
     * <p>
     * Updates a mobile device access rule for the specified WorkMail organization.
     * </p>
     *
     * @param updateMobileDeviceAccessRuleRequest
     * @return A Java Future containing the result of the UpdateMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMobileDeviceAccessRuleResponse> updateMobileDeviceAccessRule(
            UpdateMobileDeviceAccessRuleRequest updateMobileDeviceAccessRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a mobile device access rule for the specified WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMobileDeviceAccessRuleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateMobileDeviceAccessRuleRequest#builder()}
     * </p>
     *
     * @param updateMobileDeviceAccessRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UpdateMobileDeviceAccessRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMobileDeviceAccessRuleResponse> updateMobileDeviceAccessRule(
            Consumer<UpdateMobileDeviceAccessRuleRequest.Builder> updateMobileDeviceAccessRuleRequest) {
        return updateMobileDeviceAccessRule(UpdateMobileDeviceAccessRuleRequest.builder()
                .applyMutation(updateMobileDeviceAccessRuleRequest).build());
    }

    /**
     * <p>
     * Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or
     * swapped between an existing alias and the current primary email), and the email provided in the input is promoted
     * as the primary.
     * </p>
     *
     * @param updatePrimaryEmailAddressRequest
     * @return A Java Future containing the result of the UpdatePrimaryEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdatePrimaryEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePrimaryEmailAddressResponse> updatePrimaryEmailAddress(
            UpdatePrimaryEmailAddressRequest updatePrimaryEmailAddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or
     * swapped between an existing alias and the current primary email), and the email provided in the input is promoted
     * as the primary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePrimaryEmailAddressRequest.Builder} avoiding
     * the need to create one manually via {@link UpdatePrimaryEmailAddressRequest#builder()}
     * </p>
     *
     * @param updatePrimaryEmailAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdatePrimaryEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdatePrimaryEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePrimaryEmailAddressResponse> updatePrimaryEmailAddress(
            Consumer<UpdatePrimaryEmailAddressRequest.Builder> updatePrimaryEmailAddressRequest) {
        return updatePrimaryEmailAddress(UpdatePrimaryEmailAddressRequest.builder()
                .applyMutation(updatePrimaryEmailAddressRequest).build());
    }

    /**
     * <p>
     * Updates data for the resource. To have the latest information, it must be preceded by a <a>DescribeResource</a>
     * call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code>
     * call.
     * </p>
     *
     * @param updateResourceRequest
     * @return A Java Future containing the result of the UpdateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidConfigurationException The configuration for a resource isn't valid. A resource must either be
     *         able to auto-respond to requests or have at least one delegate associated that can do so on its behalf.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateResourceResponse> updateResource(UpdateResourceRequest updateResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates data for the resource. To have the latest information, it must be preceded by a <a>DescribeResource</a>
     * call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code>
     * call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateResourceRequest#builder()}
     * </p>
     *
     * @param updateResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UpdateResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidConfigurationException The configuration for a resource isn't valid. A resource must either be
     *         able to auto-respond to requests or have at least one delegate associated that can do so on its behalf.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateResourceResponse> updateResource(Consumer<UpdateResourceRequest.Builder> updateResourceRequest) {
        return updateResource(UpdateResourceRequest.builder().applyMutation(updateResourceRequest).build());
    }

    /**
     * <p>
     * Updates data for the user. To have the latest information, it must be preceded by a <a>DescribeUser</a> call. The
     * dataset in the request should be the one expected when performing another <code>DescribeUser</code> call.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates data for the user. To have the latest information, it must be preceded by a <a>DescribeUser</a> call. The
     * dataset in the request should be the one expected when performing another <code>DescribeUser</code> call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workmail.model.UpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    @Override
    default WorkMailServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link WorkMailAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkMailAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkMailAsyncClient}.
     */
    static WorkMailAsyncClientBuilder builder() {
        return new DefaultWorkMailAsyncClientBuilder();
    }
}
