/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRuleEffect;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MobileDeviceAccessOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MobileDeviceAccessOverride> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(MobileDeviceAccessOverride.getter(MobileDeviceAccessOverride::userId)).setter(MobileDeviceAccessOverride.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(MobileDeviceAccessOverride.getter(MobileDeviceAccessOverride::deviceId)).setter(MobileDeviceAccessOverride.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Effect").getter(MobileDeviceAccessOverride.getter(MobileDeviceAccessOverride::effectAsString)).setter(MobileDeviceAccessOverride.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(MobileDeviceAccessOverride.getter(MobileDeviceAccessOverride::description)).setter(MobileDeviceAccessOverride.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(MobileDeviceAccessOverride.getter(MobileDeviceAccessOverride::dateCreated)).setter(MobileDeviceAccessOverride.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateModified").getter(MobileDeviceAccessOverride.getter(MobileDeviceAccessOverride::dateModified)).setter(MobileDeviceAccessOverride.setter(Builder::dateModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, DEVICE_ID_FIELD, EFFECT_FIELD, DESCRIPTION_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String deviceId;
    private final String effect;
    private final String description;
    private final Instant dateCreated;
    private final Instant dateModified;

    private MobileDeviceAccessOverride(BuilderImpl builder) {
        this.userId = builder.userId;
        this.deviceId = builder.deviceId;
        this.effect = builder.effect;
        this.description = builder.description;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
    }

    public final String userId() {
        return this.userId;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final MobileDeviceAccessRuleEffect effect() {
        return MobileDeviceAccessRuleEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final String description() {
        return this.description;
    }

    public final Instant dateCreated() {
        return this.dateCreated;
    }

    public final Instant dateModified() {
        return this.dateModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MobileDeviceAccessOverride)) {
            return false;
        }
        MobileDeviceAccessOverride other = (MobileDeviceAccessOverride)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.effectAsString(), other.effectAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateModified(), other.dateModified());
    }

    public final String toString() {
        return ToString.builder((String)"MobileDeviceAccessOverride").add("UserId", (Object)this.userId()).add("DeviceId", (Object)this.deviceId()).add("Effect", (Object)this.effectAsString()).add("Description", (Object)this.description()).add("DateCreated", (Object)this.dateCreated()).add("DateModified", (Object)this.dateModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "Effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateModified": {
                return Optional.ofNullable(clazz.cast(this.dateModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MobileDeviceAccessOverride, T> g) {
        return obj -> g.apply((MobileDeviceAccessOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String deviceId;
        private String effect;
        private String description;
        private Instant dateCreated;
        private Instant dateModified;

        private BuilderImpl() {
        }

        private BuilderImpl(MobileDeviceAccessOverride model) {
            this.userId(model.userId);
            this.deviceId(model.deviceId);
            this.effect(model.effect);
            this.description(model.description);
            this.dateCreated(model.dateCreated);
            this.dateModified(model.dateModified);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getEffect() {
            return this.effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(MobileDeviceAccessRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateModified() {
            return this.dateModified;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        public MobileDeviceAccessOverride build() {
            return new MobileDeviceAccessOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MobileDeviceAccessOverride> {
        public Builder userId(String var1);

        public Builder deviceId(String var1);

        public Builder effect(String var1);

        public Builder effect(MobileDeviceAccessRuleEffect var1);

        public Builder description(String var1);

        public Builder dateCreated(Instant var1);

        public Builder dateModified(Instant var1);
    }
}

