/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse;

public class ListOrganizationsIterable
implements SdkIterable<ListOrganizationsResponse> {
    private final WorkMailClient client;
    private final ListOrganizationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrganizationsIterable(WorkMailClient client, ListOrganizationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOrganizationsResponseFetcher();
    }

    public Iterator<ListOrganizationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListOrganizationsResponseFetcher
    implements SyncPageFetcher<ListOrganizationsResponse> {
        private ListOrganizationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrganizationsResponse nextPage(ListOrganizationsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationsIterable.this.client.listOrganizations(ListOrganizationsIterable.this.firstRequest);
            }
            return ListOrganizationsIterable.this.client.listOrganizations((ListOrganizationsRequest)((Object)ListOrganizationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

