/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMailDomainResponse extends WorkMailResponse implements
        ToCopyableBuilder<GetMailDomainResponse.Builder, GetMailDomainResponse> {
    private static final SdkField<List<DnsRecord>> RECORDS_FIELD = SdkField
            .<List<DnsRecord>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(GetMailDomainResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DnsRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(DnsRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TEST_DOMAIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTestDomain").getter(getter(GetMailDomainResponse::isTestDomain)).setter(setter(Builder::isTestDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTestDomain").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(GetMailDomainResponse::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<String> OWNERSHIP_VERIFICATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnershipVerificationStatus")
            .getter(getter(GetMailDomainResponse::ownershipVerificationStatusAsString))
            .setter(setter(Builder::ownershipVerificationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnershipVerificationStatus")
                    .build()).build();

    private static final SdkField<String> DKIM_VERIFICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DkimVerificationStatus").getter(getter(GetMailDomainResponse::dkimVerificationStatusAsString))
            .setter(setter(Builder::dkimVerificationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimVerificationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD,
            IS_TEST_DOMAIN_FIELD, IS_DEFAULT_FIELD, OWNERSHIP_VERIFICATION_STATUS_FIELD, DKIM_VERIFICATION_STATUS_FIELD));

    private final List<DnsRecord> records;

    private final Boolean isTestDomain;

    private final Boolean isDefault;

    private final String ownershipVerificationStatus;

    private final String dkimVerificationStatus;

    private GetMailDomainResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.isTestDomain = builder.isTestDomain;
        this.isDefault = builder.isDefault;
        this.ownershipVerificationStatus = builder.ownershipVerificationStatus;
        this.dkimVerificationStatus = builder.dkimVerificationStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the DNS records that WorkMail recommends adding in your DNS provider for the best user experience. The
     * records configure your domain with DMARC, SPF, DKIM, and direct incoming email traffic to SES. See admin guide
     * for more details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return A list of the DNS records that WorkMail recommends adding in your DNS provider for the best user
     *         experience. The records configure your domain with DMARC, SPF, DKIM, and direct incoming email traffic to
     *         SES. See admin guide for more details.
     */
    public final List<DnsRecord> records() {
        return records;
    }

    /**
     * <p>
     * Specifies whether the domain is a test domain provided by WorkMail, or a custom domain.
     * </p>
     * 
     * @return Specifies whether the domain is a test domain provided by WorkMail, or a custom domain.
     */
    public final Boolean isTestDomain() {
        return isTestDomain;
    }

    /**
     * <p>
     * Specifies whether the domain is the default domain for your organization.
     * </p>
     * 
     * @return Specifies whether the domain is the default domain for your organization.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * Indicates the status of the domain ownership verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ownershipVerificationStatus} will return {@link DnsRecordVerificationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #ownershipVerificationStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the domain ownership verification.
     * @see DnsRecordVerificationStatus
     */
    public final DnsRecordVerificationStatus ownershipVerificationStatus() {
        return DnsRecordVerificationStatus.fromValue(ownershipVerificationStatus);
    }

    /**
     * <p>
     * Indicates the status of the domain ownership verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ownershipVerificationStatus} will return {@link DnsRecordVerificationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #ownershipVerificationStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the domain ownership verification.
     * @see DnsRecordVerificationStatus
     */
    public final String ownershipVerificationStatusAsString() {
        return ownershipVerificationStatus;
    }

    /**
     * <p>
     * Indicates the status of a DKIM verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dkimVerificationStatus} will return {@link DnsRecordVerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dkimVerificationStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a DKIM verification.
     * @see DnsRecordVerificationStatus
     */
    public final DnsRecordVerificationStatus dkimVerificationStatus() {
        return DnsRecordVerificationStatus.fromValue(dkimVerificationStatus);
    }

    /**
     * <p>
     * Indicates the status of a DKIM verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dkimVerificationStatus} will return {@link DnsRecordVerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dkimVerificationStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a DKIM verification.
     * @see DnsRecordVerificationStatus
     */
    public final String dkimVerificationStatusAsString() {
        return dkimVerificationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTestDomain());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(ownershipVerificationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dkimVerificationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMailDomainResponse)) {
            return false;
        }
        GetMailDomainResponse other = (GetMailDomainResponse) obj;
        return hasRecords() == other.hasRecords() && Objects.equals(records(), other.records())
                && Objects.equals(isTestDomain(), other.isTestDomain()) && Objects.equals(isDefault(), other.isDefault())
                && Objects.equals(ownershipVerificationStatusAsString(), other.ownershipVerificationStatusAsString())
                && Objects.equals(dkimVerificationStatusAsString(), other.dkimVerificationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMailDomainResponse").add("Records", hasRecords() ? records() : null)
                .add("IsTestDomain", isTestDomain()).add("IsDefault", isDefault())
                .add("OwnershipVerificationStatus", ownershipVerificationStatusAsString())
                .add("DkimVerificationStatus", dkimVerificationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "IsTestDomain":
            return Optional.ofNullable(clazz.cast(isTestDomain()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "OwnershipVerificationStatus":
            return Optional.ofNullable(clazz.cast(ownershipVerificationStatusAsString()));
        case "DkimVerificationStatus":
            return Optional.ofNullable(clazz.cast(dkimVerificationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMailDomainResponse, T> g) {
        return obj -> g.apply((GetMailDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMailDomainResponse> {
        /**
         * <p>
         * A list of the DNS records that WorkMail recommends adding in your DNS provider for the best user experience.
         * The records configure your domain with DMARC, SPF, DKIM, and direct incoming email traffic to SES. See admin
         * guide for more details.
         * </p>
         * 
         * @param records
         *        A list of the DNS records that WorkMail recommends adding in your DNS provider for the best user
         *        experience. The records configure your domain with DMARC, SPF, DKIM, and direct incoming email traffic
         *        to SES. See admin guide for more details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<DnsRecord> records);

        /**
         * <p>
         * A list of the DNS records that WorkMail recommends adding in your DNS provider for the best user experience.
         * The records configure your domain with DMARC, SPF, DKIM, and direct incoming email traffic to SES. See admin
         * guide for more details.
         * </p>
         * 
         * @param records
         *        A list of the DNS records that WorkMail recommends adding in your DNS provider for the best user
         *        experience. The records configure your domain with DMARC, SPF, DKIM, and direct incoming email traffic
         *        to SES. See admin guide for more details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(DnsRecord... records);

        /**
         * <p>
         * A list of the DNS records that WorkMail recommends adding in your DNS provider for the best user experience.
         * The records configure your domain with DMARC, SPF, DKIM, and direct incoming email traffic to SES. See admin
         * guide for more details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workmail.model.DnsRecord.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workmail.model.DnsRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workmail.model.DnsRecord.Builder#build()} is called immediately and
         * its result is passed to {@link #records(List<DnsRecord>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workmail.model.DnsRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<DnsRecord>)
         */
        Builder records(Consumer<DnsRecord.Builder>... records);

        /**
         * <p>
         * Specifies whether the domain is a test domain provided by WorkMail, or a custom domain.
         * </p>
         * 
         * @param isTestDomain
         *        Specifies whether the domain is a test domain provided by WorkMail, or a custom domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTestDomain(Boolean isTestDomain);

        /**
         * <p>
         * Specifies whether the domain is the default domain for your organization.
         * </p>
         * 
         * @param isDefault
         *        Specifies whether the domain is the default domain for your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * Indicates the status of the domain ownership verification.
         * </p>
         * 
         * @param ownershipVerificationStatus
         *        Indicates the status of the domain ownership verification.
         * @see DnsRecordVerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsRecordVerificationStatus
         */
        Builder ownershipVerificationStatus(String ownershipVerificationStatus);

        /**
         * <p>
         * Indicates the status of the domain ownership verification.
         * </p>
         * 
         * @param ownershipVerificationStatus
         *        Indicates the status of the domain ownership verification.
         * @see DnsRecordVerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsRecordVerificationStatus
         */
        Builder ownershipVerificationStatus(DnsRecordVerificationStatus ownershipVerificationStatus);

        /**
         * <p>
         * Indicates the status of a DKIM verification.
         * </p>
         * 
         * @param dkimVerificationStatus
         *        Indicates the status of a DKIM verification.
         * @see DnsRecordVerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsRecordVerificationStatus
         */
        Builder dkimVerificationStatus(String dkimVerificationStatus);

        /**
         * <p>
         * Indicates the status of a DKIM verification.
         * </p>
         * 
         * @param dkimVerificationStatus
         *        Indicates the status of a DKIM verification.
         * @see DnsRecordVerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsRecordVerificationStatus
         */
        Builder dkimVerificationStatus(DnsRecordVerificationStatus dkimVerificationStatus);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private List<DnsRecord> records = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTestDomain;

        private Boolean isDefault;

        private String ownershipVerificationStatus;

        private String dkimVerificationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMailDomainResponse model) {
            super(model);
            records(model.records);
            isTestDomain(model.isTestDomain);
            isDefault(model.isDefault);
            ownershipVerificationStatus(model.ownershipVerificationStatus);
            dkimVerificationStatus(model.dkimVerificationStatus);
        }

        public final List<DnsRecord.Builder> getRecords() {
            List<DnsRecord.Builder> result = DnsRecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<DnsRecord.BuilderImpl> records) {
            this.records = DnsRecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<DnsRecord> records) {
            this.records = DnsRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(DnsRecord... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<DnsRecord.Builder>... records) {
            records(Stream.of(records).map(c -> DnsRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTestDomain() {
            return isTestDomain;
        }

        public final void setIsTestDomain(Boolean isTestDomain) {
            this.isTestDomain = isTestDomain;
        }

        @Override
        public final Builder isTestDomain(Boolean isTestDomain) {
            this.isTestDomain = isTestDomain;
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getOwnershipVerificationStatus() {
            return ownershipVerificationStatus;
        }

        public final void setOwnershipVerificationStatus(String ownershipVerificationStatus) {
            this.ownershipVerificationStatus = ownershipVerificationStatus;
        }

        @Override
        public final Builder ownershipVerificationStatus(String ownershipVerificationStatus) {
            this.ownershipVerificationStatus = ownershipVerificationStatus;
            return this;
        }

        @Override
        public final Builder ownershipVerificationStatus(DnsRecordVerificationStatus ownershipVerificationStatus) {
            this.ownershipVerificationStatus(ownershipVerificationStatus == null ? null : ownershipVerificationStatus.toString());
            return this;
        }

        public final String getDkimVerificationStatus() {
            return dkimVerificationStatus;
        }

        public final void setDkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
        }

        @Override
        public final Builder dkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
            return this;
        }

        @Override
        public final Builder dkimVerificationStatus(DnsRecordVerificationStatus dkimVerificationStatus) {
            this.dkimVerificationStatus(dkimVerificationStatus == null ? null : dkimVerificationStatus.toString());
            return this;
        }

        @Override
        public GetMailDomainResponse build() {
            return new GetMailDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
