/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An impersonation role for the given WorkMail organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImpersonationRole implements SdkPojo, Serializable,
        ToCopyableBuilder<ImpersonationRole.Builder, ImpersonationRole> {
    private static final SdkField<String> IMPERSONATION_ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImpersonationRoleId").getter(getter(ImpersonationRole::impersonationRoleId))
            .setter(setter(Builder::impersonationRoleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpersonationRoleId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ImpersonationRole::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ImpersonationRole::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateCreated").getter(getter(ImpersonationRole::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateModified").getter(getter(ImpersonationRole::dateModified)).setter(setter(Builder::dateModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPERSONATION_ROLE_ID_FIELD,
            NAME_FIELD, TYPE_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String impersonationRoleId;

    private final String name;

    private final String type;

    private final Instant dateCreated;

    private final Instant dateModified;

    private ImpersonationRole(BuilderImpl builder) {
        this.impersonationRoleId = builder.impersonationRoleId;
        this.name = builder.name;
        this.type = builder.type;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
    }

    /**
     * <p>
     * The identifier of the impersonation role.
     * </p>
     * 
     * @return The identifier of the impersonation role.
     */
    public final String impersonationRoleId() {
        return impersonationRoleId;
    }

    /**
     * <p>
     * The impersonation role name.
     * </p>
     * 
     * @return The impersonation role name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The impersonation role type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImpersonationRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The impersonation role type.
     * @see ImpersonationRoleType
     */
    public final ImpersonationRoleType type() {
        return ImpersonationRoleType.fromValue(type);
    }

    /**
     * <p>
     * The impersonation role type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImpersonationRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The impersonation role type.
     * @see ImpersonationRoleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The date when the impersonation role was created.
     * </p>
     * 
     * @return The date when the impersonation role was created.
     */
    public final Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date when the impersonation role was last modified.
     * </p>
     * 
     * @return The date when the impersonation role was last modified.
     */
    public final Instant dateModified() {
        return dateModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(impersonationRoleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateModified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImpersonationRole)) {
            return false;
        }
        ImpersonationRole other = (ImpersonationRole) obj;
        return Objects.equals(impersonationRoleId(), other.impersonationRoleId()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(dateCreated(), other.dateCreated())
                && Objects.equals(dateModified(), other.dateModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImpersonationRole").add("ImpersonationRoleId", impersonationRoleId()).add("Name", name())
                .add("Type", typeAsString()).add("DateCreated", dateCreated()).add("DateModified", dateModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImpersonationRoleId":
            return Optional.ofNullable(clazz.cast(impersonationRoleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateModified":
            return Optional.ofNullable(clazz.cast(dateModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImpersonationRole, T> g) {
        return obj -> g.apply((ImpersonationRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImpersonationRole> {
        /**
         * <p>
         * The identifier of the impersonation role.
         * </p>
         * 
         * @param impersonationRoleId
         *        The identifier of the impersonation role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impersonationRoleId(String impersonationRoleId);

        /**
         * <p>
         * The impersonation role name.
         * </p>
         * 
         * @param name
         *        The impersonation role name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The impersonation role type.
         * </p>
         * 
         * @param type
         *        The impersonation role type.
         * @see ImpersonationRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpersonationRoleType
         */
        Builder type(String type);

        /**
         * <p>
         * The impersonation role type.
         * </p>
         * 
         * @param type
         *        The impersonation role type.
         * @see ImpersonationRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpersonationRoleType
         */
        Builder type(ImpersonationRoleType type);

        /**
         * <p>
         * The date when the impersonation role was created.
         * </p>
         * 
         * @param dateCreated
         *        The date when the impersonation role was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The date when the impersonation role was last modified.
         * </p>
         * 
         * @param dateModified
         *        The date when the impersonation role was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateModified(Instant dateModified);
    }

    static final class BuilderImpl implements Builder {
        private String impersonationRoleId;

        private String name;

        private String type;

        private Instant dateCreated;

        private Instant dateModified;

        private BuilderImpl() {
        }

        private BuilderImpl(ImpersonationRole model) {
            impersonationRoleId(model.impersonationRoleId);
            name(model.name);
            type(model.type);
            dateCreated(model.dateCreated);
            dateModified(model.dateModified);
        }

        public final String getImpersonationRoleId() {
            return impersonationRoleId;
        }

        public final void setImpersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
        }

        @Override
        public final Builder impersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImpersonationRoleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateModified() {
            return dateModified;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        @Override
        public ImpersonationRole build() {
            return new ImpersonationRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
